/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.TextRunTemplate;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.POIXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAPI {
    private static final Logger logger = LoggerFactory.getLogger(RenderAPI.class);

    public static void debug(XWPFTemplate template, Map<String, Object> datas) {
        List<ElementTemplate> all = template.getElementTemplates();
        HashSet<String> tagtKeys = new HashSet<String>();
        if ((all == null || all.isEmpty()) && (null == datas || datas.isEmpty())) {
            logger.debug("no template gramer find or no render data find");
            return;
        }
        logger.debug("template tag size is :" + (null == all ? 0 : all.size()));
        for (ElementTemplate ele : all) {
            logger.debug("parse the tag:" + ele.getTagName());
            tagtKeys.add(ele.getTagName());
        }
        Set<String> keySet = datas.keySet();
        HashSet<String> copySet = new HashSet<String>(keySet);
        copySet.removeAll(tagtKeys);
        for (String key : copySet) {
            logger.warn("cannot find the gramer tag in template:" + key);
        }
    }

    public static void selfRender(XWPFTemplate template) {
        if (null == template) {
            throw new POIXMLException("template is null,should be setted first.");
        }
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        if (null == elementTemplates || elementTemplates.isEmpty()) {
            return;
        }
        for (ElementTemplate runTemplate : elementTemplates) {
            logger.debug("tag-name:" + runTemplate.getTagName());
            logger.debug(runTemplate.getClass().toString());
            RenderPolicy policy = template.getPolicy(TextRunTemplate.class);
            policy.render(runTemplate, new TextRenderData(runTemplate.getSource()), template);
        }
    }

    public static void render(XWPFTemplate template, Map<String, Object> datas) {
        if (null == template) {
            throw new POIXMLException("template is null,should be setted first.");
        }
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        if (null == elementTemplates || elementTemplates.isEmpty() || null == datas || datas.isEmpty()) {
            return;
        }
        for (ElementTemplate runTemplate : elementTemplates) {
            logger.debug("tag-name:" + runTemplate.getTagName());
            logger.debug(runTemplate.getClass().toString());
            RenderPolicy policy = template.getPolicy(runTemplate.getTagName());
            if (null == policy) {
                policy = template.getPolicy(runTemplate.getClass());
            }
            if (null == policy) {
                throw new RenderException("cannot find render policy: " + runTemplate.getTagName());
            }
            policy.render(runTemplate, datas.get(runTemplate.getTagName()), template);
        }
    }
}

