/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.table;

import org.apache.poi.xwpf.converter.core.styles.table.AbstractTableValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.apache.poi.xwpf.converter.core.utils.XWPFTableUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTablelMarginValueProvider
extends AbstractTableValueProvider<Float> {
    @Override
    public Float getValue(CTTblPr tblPr) {
        return this.getMarginValue((CTTblPrBase)tblPr);
    }

    private Float getMarginValue(CTTblPrBase tblPr) {
        if (tblPr == null) {
            return null;
        }
        CTTblCellMar margin = tblPr.getTblCellMar();
        if (margin != null) {
            CTTblWidth tblWidth = this.getValue(margin);
            if (tblWidth == null) {
                return null;
            }
            return Float.valueOf(DxaUtil.dxa2points(XWPFTableUtil.getTblWidthW(tblWidth).floatValue()));
        }
        return null;
    }

    @Override
    public Float getValue(CTTblPrBase tblPr) {
        return this.getMarginValue(tblPr);
    }

    public abstract CTTblWidth getValue(CTTblCellMar var1);
}

