/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.table.row;

import java.math.BigInteger;
import org.apache.poi.xwpf.converter.core.TableHeight;
import org.apache.poi.xwpf.converter.core.styles.table.row.AbstractTableRowValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHeightRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRowHeightValueProvider
extends AbstractTableRowValueProvider<TableHeight> {
    public static final TableRowHeightValueProvider INSTANCE = new TableRowHeightValueProvider();

    @Override
    public TableHeight getValue(CTTrPr trPr) {
        if (trPr == null) {
            return null;
        }
        if (trPr.sizeOfTrHeightArray() == 0) {
            return null;
        }
        CTHeight trHeight = trPr.getTrHeightArray(0);
        STHeightRule.Enum hRule = trHeight.getHRule();
        boolean minimum = true;
        if (hRule != null) {
            switch (hRule.intValue()) {
                case 3: {
                    minimum = true;
                    break;
                }
                case 2: {
                    minimum = false;
                    break;
                }
                case 1: {
                    return null;
                }
            }
        }
        BigInteger value = trHeight.getVal();
        float height = DxaUtil.dxa2points(value);
        return new TableHeight(height, minimum);
    }
}

