/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.utils;

import java.awt.Color;
import org.apache.poi.xwpf.converter.core.registry.ColorRegistry;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHexColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ColorHelper {
    private static final String AUTO = "auto";
    private static final String PCT = "pct";

    public static Color getFillColor(CTShd shd) {
        if (shd == null) {
            return null;
        }
        STHexColor hexColor = shd.xgetFill();
        STShd val = shd.xgetVal();
        return ColorHelper.getColor(hexColor, (Object)val, true);
    }

    public static Color getColor(CTRPr rPr) {
        CTColor ctColor;
        if (rPr != null && (ctColor = rPr.getColor()) != null) {
            STHexColor color = ctColor.xgetVal();
            Object val = ctColor.getVal();
            return ColorHelper.getColor(color, val, false);
        }
        return null;
    }

    public static Color getColor(CTParaRPr rPr) {
        CTColor ctColor;
        if (rPr != null && (ctColor = rPr.getColor()) != null) {
            STHexColor color = ctColor.xgetVal();
            Object val = ctColor.getVal();
            return ColorHelper.getColor(color, val, false);
        }
        return null;
    }

    public static Color getColor(CTShd shd) {
        if (shd == null) {
            return null;
        }
        STHexColor hexColor = shd.xgetColor();
        STShd val = shd.xgetVal();
        return ColorHelper.getColor(hexColor, (Object)val, false);
    }

    public static Color getColor(STHexColor hexColor, Object val, boolean background) {
        if (hexColor == null) {
            return null;
        }
        return ColorHelper.getColor(hexColor.getStringValue(), val, background);
    }

    public static Color getColor(String hexColor, Object val, boolean background) {
        if (hexColor != null) {
            if (AUTO.equals(hexColor)) {
                String s;
                Color autoColor;
                Color color = autoColor = background ? Color.WHITE : Color.BLACK;
                if (val != null && (s = ColorHelper.getStringVal(val)).startsWith(PCT)) {
                    s = s.substring(PCT.length(), s.length());
                    try {
                        float percent = Float.parseFloat(s) / 100.0f;
                        if (background) {
                            return ColorHelper.darken(autoColor.getRed(), autoColor.getGreen(), autoColor.getBlue(), percent);
                        }
                        return ColorHelper.lighten(autoColor.getRed(), autoColor.getGreen(), autoColor.getBlue(), percent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return autoColor;
            }
            return ColorRegistry.getInstance().getColor("0x" + hexColor);
        }
        return null;
    }

    private static String getStringVal(Object val) {
        if (val instanceof STShd) {
            STShd shd = (STShd)val;
            return shd.getStringValue();
        }
        return val.toString();
    }

    public static String toHexString(Color color) {
        String hexaWith8Digits = Integer.toHexString(color.getRGB());
        return "#" + hexaWith8Digits.substring(2, hexaWith8Digits.length());
    }

    public static Color darken(int r, int g, int b, double percent) throws IllegalArgumentException {
        return new Color(Math.max((int)((double)r * (1.0 - percent)), 0), Math.max((int)((double)g * (1.0 - percent)), 0), Math.max((int)((double)b * (1.0 - percent)), 0));
    }

    public static Color lighten(int r, int g, int b, double percent) throws IllegalArgumentException {
        int r2 = r + (int)((double)(255 - r) * percent);
        int g2 = g + (int)((double)(255 - g) * percent);
        int b2 = b + (int)((double)(255 - b) * percent);
        return new Color(r2, g2, b2);
    }

    public static Color getBorderColor(CTBorder border) {
        if (border == null) {
            return null;
        }
        Node colorAttr = border.getDomNode().getAttributes().getNamedItemNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "color");
        if (colorAttr != null) {
            STBorder.Enum val = border.getVal();
            return ColorHelper.getColor(((Attr)colorAttr).getValue(), (Object)val, false);
        }
        return null;
    }
}

