/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access;

import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.snaker.engine.helper.ConfigHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page<T> {
    public static final int NON_PAGE = -1;
    public static final int PAGE_SIZE = 15;
    private int pageNo = 1;
    private int pageSize = -1;
    private long totalCount = 0L;
    private List<T> result;

    public Page() {
        this.pageSize = ConfigHelper.getNumerProperty("jdbc.pageSize");
        if (this.pageSize <= 0) {
            this.pageSize = 15;
        }
    }

    public Page(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public Page<T> pageNo(int thePageNo) {
        this.setPageNo(thePageNo);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Page<T> pageSize(int thePageSize) {
        this.setPageSize(thePageSize);
        return this;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotalCount() {
        return this.totalCount < 0L ? 0L : this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        if (this.totalCount < 0L) {
            return 0L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public boolean isHasNext() {
        return (long)(this.pageNo + 1) <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.isHasNext()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    public boolean isHasPre() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrePage() {
        if (this.isHasPre()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

