/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.dialect;

import org.apache.commons.lang.StringUtils;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.dialect.Dialect;
import org.snaker.engine.helper.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDialect
implements Dialect {
    private static final String STR_ORDERBY = " order by ";

    @Override
    public String getPageSql(String sql, Page<?> page) {
        int orderIdx = sql.indexOf(STR_ORDERBY);
        String orderStr = null;
        if (orderIdx != -1) {
            orderStr = sql.substring(orderIdx + 10);
            sql = sql.substring(0, orderIdx);
        }
        StringBuffer pageSql = new StringBuffer();
        pageSql.append("select top ");
        pageSql.append(page.getPageSize());
        pageSql.append(" * from (select row_number() over (");
        String orderBy = this.getOrderBy(sql, orderStr);
        pageSql.append(orderBy);
        pageSql.append(") row_number, * from (");
        pageSql.append(sql);
        int start = (page.getPageNo() - 1) * page.getPageSize();
        pageSql.append(") aa ) a where row_number > ");
        pageSql.append(start);
        pageSql.append(" order by row_number");
        return pageSql.toString();
    }

    public String getOrderBy(String sql, String orderBy) {
        if (StringHelper.isEmpty(orderBy)) {
            return " order by  id desc ";
        }
        StringBuffer orderBuffer = new StringBuffer(30);
        String[] orderByArray = StringUtils.split((String)orderBy, (char)',');
        int i = 0;
        while (i < orderByArray.length) {
            String columnAlias;
            int columnIndex;
            String orderByItem = orderByArray[i].trim();
            String orderByName = null;
            String orderByDirect = "";
            if (orderByItem.indexOf(" ") == -1) {
                orderByName = orderByItem;
            } else {
                orderByName = orderByItem.substring(0, orderByItem.indexOf(" "));
                orderByDirect = orderByItem.substring(orderByItem.indexOf(" ") + 1);
            }
            if (orderByName.indexOf(".") > -1) {
                orderByName = orderByName.substring(orderByName.indexOf(".") + 1);
            }
            if ((columnIndex = sql.indexOf(columnAlias = String.valueOf(orderByName) + " as ")) == -1) {
                orderBuffer.append(orderByName).append(" ").append(orderByDirect).append(" ,");
            } else {
                String after = sql.substring(columnIndex + columnAlias.length());
                String aliasName = null;
                aliasName = after.indexOf(",") != -1 && after.indexOf(" from") > after.indexOf(",") ? after.substring(0, after.indexOf(",")) : after.substring(0, after.indexOf(" "));
                orderBuffer.append(aliasName).append(" ").append(orderByDirect).append(" ,");
            }
            ++i;
        }
        orderBuffer.deleteCharAt(orderBuffer.length() - 1);
        return STR_ORDERBY + orderBuffer.toString();
    }
}

