/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.transaction;

import javax.naming.InitialContext;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.snaker.engine.SnakerException;
import org.snaker.engine.helper.ConfigHelper;

public class JtaTransactionHelper {
    private static String userTransactionJndiName = ConfigHelper.getProperty("tx.jta.userTransaction");
    private static String transactionManagerJndiName = ConfigHelper.getProperty("tx.jta.transactionManager");

    public static UserTransaction lookupJeeUserTransaction() {
        return (UserTransaction)JtaTransactionHelper.lookupFromJndi(userTransactionJndiName);
    }

    public static Transaction lookupJeeTransaction() {
        try {
            TransactionManager transactionManager = JtaTransactionHelper.lookupJeeTransactionManager();
            return transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw new SnakerException("\u65e0\u6cd5\u4ece\u4e8b\u52a1\u7ba1\u7406\u4e2d\u83b7\u53d6\u4e8b\u52a1\u5bf9\u8c61[" + transactionManagerJndiName + "]:\n" + e.getMessage(), e);
        }
    }

    public static TransactionManager lookupJeeTransactionManager() {
        return (TransactionManager)JtaTransactionHelper.lookupFromJndi(transactionManagerJndiName);
    }

    public static Object lookupFromJndi(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext.lookup(jndiName);
        }
        catch (Exception e) {
            throw new SnakerException("\u65e0\u6cd5\u627e\u5230jndi\u540d\u79f0[" + jndiName + "]\n" + e.getMessage(), e);
        }
    }

    public static int getUserTransactionStatus(UserTransaction userTransaction) {
        int status = -1;
        try {
            status = userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new SnakerException("\u65e0\u6cd5\u83b7\u53d6\u4e8b\u52a1\u72b6\u6001:" + e.getMessage(), e);
        }
        return status;
    }

    public static boolean isRollbackOnly() {
        try {
            return JtaTransactionHelper.lookupJeeUserTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new SnakerException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4e8b\u52a1\u7684\u72b6\u6001" + e.getMessage(), e);
        }
    }

    public static void setRollbackOnly() {
        try {
            JtaTransactionHelper.lookupJeeUserTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new SnakerException("couldn't set user transaction to rollback only: " + e.getMessage(), e);
        }
    }

    public static void registerSynchronization(Synchronization synchronization) {
        try {
            JtaTransactionHelper.lookupJeeTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new SnakerException("couldn't register synchronization: " + e.getMessage(), e);
        }
    }

    public static void begin() {
        try {
            JtaTransactionHelper.lookupJeeUserTransaction().begin();
        }
        catch (Exception e) {
            throw new SnakerException("couldn't begin transaction: " + e.getMessage(), e);
        }
    }

    public static void rollback() {
        try {
            JtaTransactionHelper.lookupJeeUserTransaction().rollback();
        }
        catch (Exception e) {
            throw new SnakerException("couldn't rollback: " + e.getMessage(), e);
        }
    }

    public static void commit() {
        try {
            JtaTransactionHelper.lookupJeeUserTransaction().commit();
        }
        catch (Exception e) {
            throw new SnakerException("couldn't commit: " + e.getMessage(), e);
        }
    }

    public static Transaction suspend() {
        try {
            return JtaTransactionHelper.lookupJeeTransactionManager().suspend();
        }
        catch (Exception e) {
            throw new SnakerException("couldn't suspend: " + e.getMessage(), e);
        }
    }

    public static void resume(Transaction transaction) {
        try {
            JtaTransactionHelper.lookupJeeTransactionManager().resume(transaction);
        }
        catch (Exception e) {
            throw new SnakerException("couldn't resume: " + e.getMessage(), e);
        }
    }
}

