/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.cfg;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.Context;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StreamHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.helper.XmlHelper;
import org.snaker.engine.impl.SimpleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String BASE_CONFIG_FILE = "base.config.xml";
    private static final String EXT_CONFIG_FILE = "ext.config.xml";
    private static final String USER_CONFIG_FILE = "snaker.xml";
    private Object accessDBObject;
    private TransactionInterceptor interceptor = null;
    private Map<String, Class<?>> txClass = new HashMap();

    public Configuration() {
        this(new SimpleContext());
    }

    public Configuration(Context context) {
        ServiceContext.setContext(context);
    }

    public SnakerEngine buildSnakerEngine() throws SnakerException {
        if (log.isInfoEnabled()) {
            log.info("SnakerEngine start......");
        }
        this.parser();
        SnakerEngine configEngine = ServiceContext.getEngine();
        if (configEngine == null) {
            throw new SnakerException("\u914d\u7f6e\u65e0\u6cd5\u53d1\u73b0SnakerEngine\u7684\u5b9e\u73b0\u7c7b");
        }
        if (log.isInfoEnabled()) {
            log.info("SnakerEngine be found:" + configEngine.getClass());
        }
        return configEngine.configure(this);
    }

    protected void parser() {
        String config;
        if (log.isDebugEnabled()) {
            log.debug("Service parsing start......");
        }
        if (StringHelper.isEmpty(config = ConfigHelper.getProperty("config"))) {
            config = USER_CONFIG_FILE;
        }
        this.parser(config);
        this.parser(BASE_CONFIG_FILE);
        if (!this.isCMB()) {
            this.parser(EXT_CONFIG_FILE);
            for (Map.Entry<String, Class<?>> entry : this.txClass.entrySet()) {
                if (this.interceptor != null) {
                    Object instance = this.interceptor.getProxy(entry.getValue());
                    ServiceContext.put(entry.getKey(), instance);
                    continue;
                }
                ServiceContext.put(entry.getKey(), entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Service parsing finish......");
        }
    }

    private void parser(String resource) {
        DocumentBuilder documentBuilder = XmlHelper.createDocumentBuilder();
        try {
            if (documentBuilder != null) {
                InputStream input = StreamHelper.openStream(resource);
                if (input == null) {
                    return;
                }
                Document doc = documentBuilder.parse(input);
                Element configElement = doc.getDocumentElement();
                NodeList nodeList = configElement.getChildNodes();
                int nodeSize = nodeList.getLength();
                int i = 0;
                while (i < nodeSize) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        String name = element.getAttribute("name");
                        String className = element.getAttribute("class");
                        String proxy = element.getAttribute("proxy");
                        if (StringHelper.isEmpty(name)) {
                            name = className;
                        }
                        if (ServiceContext.exist(name)) {
                            log.warn("Duplicate name is:" + name);
                        } else {
                            Class<?> clazz = ClassHelper.loadClass(className);
                            if (TransactionInterceptor.class.isAssignableFrom(clazz)) {
                                this.interceptor = (TransactionInterceptor)ClassHelper.instantiate(clazz);
                                ServiceContext.put(name, this.interceptor);
                            } else if (proxy != null && proxy.equalsIgnoreCase("transaction")) {
                                this.txClass.put(name, clazz);
                            } else {
                                ServiceContext.put(name, clazz);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnakerException("\u8d44\u6e90\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6[" + resource + "]", e.getCause());
        }
    }

    public Configuration initAccessDBObject(Object dbObject) {
        this.accessDBObject = dbObject;
        return this;
    }

    public Configuration initProperties(String fileName) {
        ConfigHelper.loadProperties(fileName);
        return this;
    }

    public Configuration initProperties(Properties properties) {
        ConfigHelper.loadProperties(properties);
        return this;
    }

    public Object getAccessDBObject() {
        return this.accessDBObject;
    }

    public boolean isCMB() {
        return false;
    }
}

