/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.List;
import org.snaker.engine.IQueryService;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.HistoryTaskActor;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.TaskActor;
import org.snaker.engine.entity.WorkItem;
import org.snaker.engine.helper.AssertHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryService
extends AccessService
implements IQueryService {
    @Override
    public Order getOrder(String orderId) {
        return this.access().getOrder(orderId);
    }

    @Override
    public Task getTask(String taskId) {
        return this.access().getTask(taskId);
    }

    @Override
    public String[] getTaskActorsByTaskId(String taskId) {
        List<TaskActor> actors = this.access().getTaskActorsByTaskId(taskId);
        if (actors == null || actors.isEmpty()) {
            return null;
        }
        String[] actorIds = new String[actors.size()];
        int i = 0;
        while (i < actors.size()) {
            TaskActor ta = actors.get(i);
            actorIds[i] = ta.getActorId();
            ++i;
        }
        return actorIds;
    }

    @Override
    public String[] getHistoryTaskActorsByTaskId(String taskId) {
        List<HistoryTaskActor> actors = this.access().getHistTaskActorsByTaskId(taskId);
        if (actors == null || actors.isEmpty()) {
            return null;
        }
        String[] actorIds = new String[actors.size()];
        int i = 0;
        while (i < actors.size()) {
            HistoryTaskActor ta = actors.get(i);
            actorIds[i] = ta.getActorId();
            ++i;
        }
        return actorIds;
    }

    @Override
    public HistoryOrder getHistOrder(String orderId) {
        return this.access().getHistOrder(orderId);
    }

    @Override
    public HistoryTask getHistTask(String taskId) {
        return this.access().getHistTask(taskId);
    }

    @Override
    public List<Task> getActiveTasks(QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getActiveTasks(null, filter);
    }

    @Override
    public List<Task> getActiveTasks(Page<Task> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getActiveTasks(page, filter);
    }

    @Override
    public List<Order> getActiveOrders(QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getActiveOrders(null, filter);
    }

    @Override
    public List<Order> getActiveOrders(Page<Order> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getActiveOrders(page, filter);
    }

    @Override
    public List<HistoryOrder> getHistoryOrders(QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getHistoryOrders(null, filter);
    }

    @Override
    public List<HistoryOrder> getHistoryOrders(Page<HistoryOrder> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getHistoryOrders(page, filter);
    }

    @Override
    public List<HistoryTask> getHistoryTasks(QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getHistoryTasks(null, filter);
    }

    @Override
    public List<HistoryTask> getHistoryTasks(Page<HistoryTask> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getHistoryTasks(page, filter);
    }

    @Override
    public List<WorkItem> getWorkItems(Page<WorkItem> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getWorkItems(page, filter);
    }

    @Override
    public List<HistoryOrder> getCCWorks(Page<HistoryOrder> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getCCWorks(page, filter);
    }

    @Override
    public List<WorkItem> getHistoryWorkItems(Page<WorkItem> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getHistoryWorkItems(page, filter);
    }

    @Override
    public <T> T nativeQueryObject(Class<T> T, String sql, Object ... args) {
        AssertHelper.notEmpty(sql);
        AssertHelper.notNull(T);
        return this.access().queryObject(T, sql, args);
    }

    @Override
    public <T> List<T> nativeQueryList(Class<T> T, String sql, Object ... args) {
        AssertHelper.notEmpty(sql);
        AssertHelper.notNull(T);
        return this.access().queryList(T, sql, args);
    }

    @Override
    public <T> List<T> nativeQueryList(Page<T> page, Class<T> T, String sql, Object ... args) {
        AssertHelper.notEmpty(sql);
        AssertHelper.notNull(T);
        return this.access().queryList(page, new QueryFilter(), T, sql, args);
    }
}

