/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.handlers.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.core.Execution;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.handlers.IHandler;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.model.SubProcessModel;

public class StartSubProcessHandler
implements IHandler {
    private SubProcessModel model;
    private boolean isFutureRunning = false;

    public StartSubProcessHandler(SubProcessModel model) {
        this.model = model;
    }

    public StartSubProcessHandler(SubProcessModel model, boolean isFutureRunning) {
        this.model = model;
        this.isFutureRunning = isFutureRunning;
    }

    public void handle(Execution execution) {
        SnakerEngine engine = execution.getEngine();
        Process process = engine.process().getProcessByVersion(this.model.getProcessName(), this.model.getVersion(), this.model.getComId());
        Execution child = execution.createSubExecution(execution, process, this.model.getName());
        Order order = null;
        if (this.isFutureRunning) {
            ExecutorService es = Executors.newSingleThreadExecutor();
            Future<Order> future = es.submit(new ExecuteTask(execution, process, this.model.getName()));
            try {
                es.shutdown();
                order = future.get();
            }
            catch (InterruptedException e) {
                throw new SnakerException("\u521b\u5efa\u5b50\u6d41\u7a0b\u7ebf\u7a0b\u88ab\u5f3a\u5236\u7ec8\u6b62\u6267\u884c", e.getCause());
            }
            catch (ExecutionException e) {
                throw new SnakerException("\u521b\u5efa\u5b50\u6d41\u7a0b\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38.", e.getCause());
            }
        } else {
            order = engine.startInstanceByExecution(child);
        }
        AssertHelper.notNull(order, "\u5b50\u6d41\u7a0b\u521b\u5efa\u5931\u8d25");
        execution.addTasks(engine.query().getActiveTasks(new QueryFilter().setOrderId(order.getId())));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExecuteTask
    implements Callable<Order> {
        private SnakerEngine engine;
        private Execution child;

        public ExecuteTask(Execution execution, Process process, String parentNodeName) {
            this.engine = execution.getEngine();
            this.child = execution.createSubExecution(execution, process, parentNodeName);
        }

        @Override
        public Order call() throws Exception {
            return this.engine.startInstanceByExecution(this.child);
        }
    }
}

