/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    private static final Logger log = LoggerFactory.getLogger(ClassHelper.class);

    public static long castLong(Object count) {
        if (count == null) {
            return -1L;
        }
        if (count instanceof Long) {
            return (Long)count;
        }
        if (count instanceof BigDecimal) {
            return ((BigDecimal)count).longValue();
        }
        if (count instanceof Integer) {
            return ((Integer)count).longValue();
        }
        if (count instanceof BigInteger) {
            return ((BigInteger)count).longValue();
        }
        if (count instanceof Byte) {
            return ((Byte)count).longValue();
        }
        if (count instanceof Short) {
            return ((Short)count).longValue();
        }
        return -1L;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                return ClassLoader.class.getClassLoader().loadClass(className);
            }
        }
    }

    public static Object newInstance(String clazzStr) {
        try {
            log.debug("loading class:" + clazzStr);
            Class<?> clazz = ClassHelper.loadClass(clazzStr);
            return ClassHelper.instantiate(clazz);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found.", (Throwable)e);
        }
        catch (Exception ex) {
            log.error("\u7c7b\u578b\u5b9e\u4f8b\u5316\u5931\u8d25[class=" + clazzStr + "]\n" + ex.getMessage());
        }
        return null;
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz.isInterface()) {
            log.error("\u6240\u4f20\u9012\u7684class\u7c7b\u578b\u53c2\u6570\u4e3a\u63a5\u53e3\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            log.error("\u68c0\u67e5\u4f20\u9012\u7684class\u7c7b\u578b\u53c2\u6570\u662f\u5426\u4e3a\u62bd\u8c61\u7c7b?", ex.getCause());
            return null;
        }
    }
}

