/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DecisionHandler;
import org.snaker.engine.Expression;
import org.snaker.engine.SnakerException;
import org.snaker.engine.core.Execution;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.TransitionModel;

public class DecisionModel
extends NodeModel {
    private static final Logger log = LoggerFactory.getLogger(DecisionModel.class);
    private static final long serialVersionUID = -806621814645169999L;
    private String expr;
    private String handleClass;
    private DecisionHandler decide;
    private transient Expression expression;

    public void exec(Execution execution) {
        log.info(String.valueOf(execution.getOrder().getId()) + "->decision execution.getArgs():" + execution.getArgs());
        if (this.expression == null) {
            this.expression = ServiceContext.getContext().find(Expression.class);
        }
        log.info("expression is " + this.expression);
        if (this.expression == null) {
            throw new SnakerException("\u8868\u8fbe\u5f0f\u89e3\u6790\u5668\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e.");
        }
        String next = null;
        if (StringHelper.isNotEmpty(this.expr)) {
            next = this.expression.eval(String.class, this.expr, execution.getArgs());
        } else if (this.decide != null) {
            next = this.decide.decide(execution);
        }
        log.info(String.valueOf(execution.getOrder().getId()) + "->decision expression[expr=" + this.expr + "] return result:" + next);
        boolean isfound = false;
        for (TransitionModel tm : this.getOutputs()) {
            if (StringHelper.isEmpty(next)) {
                String expr = tm.getExpr();
                if (!StringHelper.isNotEmpty(expr) || !this.expression.eval(Boolean.class, expr, execution.getArgs()).booleanValue()) continue;
                tm.setEnabled(true);
                tm.execute(execution);
                isfound = true;
                continue;
            }
            if (!tm.getName().equals(next)) continue;
            tm.setEnabled(true);
            tm.execute(execution);
            isfound = true;
        }
        if (!isfound) {
            throw new SnakerException(String.valueOf(execution.getOrder().getId()) + "->decision\u8282\u70b9\u65e0\u6cd5\u786e\u5b9a\u4e0b\u4e00\u6b65\u6267\u884c\u8def\u7ebf");
        }
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public String getHandleClass() {
        return this.handleClass;
    }

    public void setHandleClass(String handleClass) {
        this.handleClass = handleClass;
        if (StringHelper.isNotEmpty(handleClass)) {
            this.decide = (DecisionHandler)ClassHelper.newInstance(handleClass);
        }
    }
}

