/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.model;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.Action;
import org.snaker.engine.SnakerException;
import org.snaker.engine.SnakerInterceptor;
import org.snaker.engine.core.Execution;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.BaseModel;
import org.snaker.engine.model.ForkModel;
import org.snaker.engine.model.JoinModel;
import org.snaker.engine.model.StartModel;
import org.snaker.engine.model.SubProcessModel;
import org.snaker.engine.model.TaskModel;
import org.snaker.engine.model.TransitionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeModel
extends BaseModel
implements Action {
    private static final long serialVersionUID = -2377317472320109317L;
    private static final Logger log = LoggerFactory.getLogger(NodeModel.class);
    private List<TransitionModel> inputs = new ArrayList<TransitionModel>();
    private List<TransitionModel> outputs = new ArrayList<TransitionModel>();
    private String layout;
    private String preInterceptors;
    private String postInterceptors;
    private List<SnakerInterceptor> preInterceptorList = new ArrayList<SnakerInterceptor>();
    private List<SnakerInterceptor> postInterceptorList = new ArrayList<SnakerInterceptor>();

    protected abstract void exec(Execution var1);

    @Override
    public void execute(Execution execution) {
        this.intercept(this.preInterceptorList, execution);
        this.exec(execution);
        this.intercept(this.postInterceptorList, execution);
    }

    protected void runOutTransition(Execution execution) {
        for (TransitionModel tm : this.getOutputs()) {
            tm.setEnabled(true);
            tm.execute(execution);
        }
    }

    private void intercept(List<SnakerInterceptor> interceptorList, Execution execution) {
        try {
            for (SnakerInterceptor interceptor : interceptorList) {
                interceptor.intercept(execution);
            }
        }
        catch (Exception e) {
            log.error("\u62e6\u622a\u5668\u6267\u884c\u5931\u8d25=" + e.getMessage());
            throw new SnakerException(e);
        }
    }

    public static boolean canRejected(NodeModel current, NodeModel parent) {
        if (parent instanceof TaskModel && !((TaskModel)parent).isPerformAny()) {
            return false;
        }
        boolean result = false;
        for (TransitionModel tm : current.getInputs()) {
            NodeModel source = tm.getSource();
            if (source == parent) {
                return true;
            }
            if (source instanceof ForkModel || source instanceof JoinModel || source instanceof SubProcessModel || source instanceof StartModel) continue;
            boolean bl = result = result || NodeModel.canRejected(source, parent);
        }
        return result;
    }

    public <T> List<T> getNextModels(Class<T> clazz) {
        ArrayList models = new ArrayList();
        for (TransitionModel tm : this.getOutputs()) {
            this.addNextModels(models, tm, clazz);
        }
        return models;
    }

    protected <T> void addNextModels(List<T> models, TransitionModel tm, Class<T> clazz) {
        if (clazz.isInstance(tm.getTarget())) {
            models.add(tm.getTarget());
        } else {
            for (TransitionModel tm2 : tm.getTarget().getOutputs()) {
                this.addNextModels(models, tm2, clazz);
            }
        }
    }

    public List<TransitionModel> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<TransitionModel> inputs) {
        this.inputs = inputs;
    }

    public List<TransitionModel> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<TransitionModel> outputs) {
        this.outputs = outputs;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getPreInterceptors() {
        return this.preInterceptors;
    }

    public void setPreInterceptors(String preInterceptors) {
        this.preInterceptors = preInterceptors;
        if (StringHelper.isNotEmpty(preInterceptors)) {
            String[] stringArray = preInterceptors.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String interceptor = stringArray[n2];
                SnakerInterceptor instance = (SnakerInterceptor)ClassHelper.newInstance(interceptor);
                if (instance != null) {
                    this.preInterceptorList.add(instance);
                }
                ++n2;
            }
        }
    }

    public String getPostInterceptors() {
        return this.postInterceptors;
    }

    public void setPostInterceptors(String postInterceptors) {
        this.postInterceptors = postInterceptors;
        if (StringHelper.isNotEmpty(postInterceptors)) {
            String[] stringArray = postInterceptors.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String interceptor = stringArray[n2];
                SnakerInterceptor instance = (SnakerInterceptor)ClassHelper.newInstance(interceptor);
                if (instance != null) {
                    this.postInterceptorList.add(instance);
                }
                ++n2;
            }
        }
    }
}

