/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.config;

import com.googlecode.ehcache.annotations.SelfPopulatingCacheScope;
import com.googlecode.ehcache.annotations.impl.CacheAttributeSourceImpl;
import com.googlecode.ehcache.annotations.impl.CacheStaticMethodMatcherPointcut;
import com.googlecode.ehcache.annotations.interceptor.EhCacheInterceptor;
import com.googlecode.ehcache.annotations.key.CacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.CachingReflectionHelper;
import com.googlecode.ehcache.annotations.key.HashCodeCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.MessageDigestCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReflectionHashCodeCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReflectionHelperAware;
import com.googlecode.ehcache.annotations.key.StringCacheKeyGenerator;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDrivenEhCacheBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String XSD_ATTR__CREATE_MISSING_CACHES = "create-missing-caches";
    public static final String XSD_ATTR__CACHE_MANAGER = "cache-manager";
    public static final String XSD_ATTR__DEFAULT_CACHE_KEY_GENERATOR = "default-cache-key-generator";
    public static final String XSD_ATTR__SELF_POPULATING_CACHE_SCOPE = "self-populating-cache-scope";
    static final String EHCACHE_CACHING_ADVISOR_BEAN_NAME = AnnotationDrivenEhCacheBeanDefinitionParser.class.getPackage().getName() + ".internalEhCacheCachingAdvisor";
    static final String DEFAULT_CACHE_KEY_GENERATOR = "com.googlecode.ehcache.annotations.key.HashCodeCacheKeyGenerator.DEFAULT_BEAN_NAME";
    static final String CACHING_REFLECTION_HELPER_BEAN_NAME = CachingReflectionHelper.class.getName();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        if (!parserContext.getRegistry().containsBeanDefinition(EHCACHE_CACHING_ADVISOR_BEAN_NAME)) {
            Object elementSource = parserContext.extractSource((Object)element);
            RuntimeBeanReference cachingReflectionHelperReference = this.setupCachingReflectionHelper(parserContext, elementSource);
            RuntimeBeanReference defaultCacheKeyGeneratorReference = this.setupDefaultCacheKeyGenerators(element, parserContext, elementSource);
            RuntimeBeanReference cacheAttributeSourceReference = this.setupCacheAttributeSource(element, parserContext, elementSource, defaultCacheKeyGeneratorReference, cachingReflectionHelperReference);
            RuntimeBeanReference pointcutReference = this.setupPointcut(element, parserContext, elementSource, cacheAttributeSourceReference);
            RuntimeBeanReference interceptorReference = this.setupInterceptor(element, parserContext, elementSource, cacheAttributeSourceReference);
            this.setupPointcutAdvisor(element, parserContext, elementSource, pointcutReference, interceptorReference);
        }
        return null;
    }

    protected RuntimeBeanReference setupCachingReflectionHelper(ParserContext parserContext, Object elementSource) {
        RootBeanDefinition defaultKeyGenerator = new RootBeanDefinition(CachingReflectionHelper.class);
        defaultKeyGenerator.setSource(elementSource);
        defaultKeyGenerator.setRole(2);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(CACHING_REFLECTION_HELPER_BEAN_NAME, (BeanDefinition)defaultKeyGenerator);
        return new RuntimeBeanReference(CACHING_REFLECTION_HELPER_BEAN_NAME);
    }

    protected RuntimeBeanReference setupDefaultCacheKeyGenerators(Element element, ParserContext parserContext, Object elementSource) {
        this.setupDefaultCacheKeyGenerator(ListCacheKeyGenerator.class, parserContext, elementSource);
        this.setupDefaultCacheKeyGenerator(HashCodeCacheKeyGenerator.class, parserContext, elementSource);
        this.setupDefaultCacheKeyGenerator(MessageDigestCacheKeyGenerator.class, parserContext, elementSource);
        this.setupDefaultCacheKeyGenerator(ReflectionHashCodeCacheKeyGenerator.class, parserContext, elementSource);
        this.setupDefaultCacheKeyGenerator(StringCacheKeyGenerator.class, parserContext, elementSource);
        String defaultCacheKeyGeneratorName = element.getAttribute(XSD_ATTR__DEFAULT_CACHE_KEY_GENERATOR);
        if (StringUtils.hasLength((String)defaultCacheKeyGeneratorName)) {
            return new RuntimeBeanReference(defaultCacheKeyGeneratorName);
        }
        return new RuntimeBeanReference(DEFAULT_CACHE_KEY_GENERATOR);
    }

    protected final void setupDefaultCacheKeyGenerator(Class<? extends CacheKeyGenerator<? extends Serializable>> generatorClass, ParserContext parserContext, Object elementSource) {
        String generatorName;
        try {
            Field field = generatorClass.getField("DEFAULT_BEAN_NAME");
            generatorName = (String)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not access static field 'DEFAULT_BEAN_NAME' on " + generatorClass + ". This field is required to be setup as a default CacheKeyGenerator", e);
        }
        RootBeanDefinition defaultKeyGenerator = new RootBeanDefinition(generatorClass);
        defaultKeyGenerator.setSource(elementSource);
        defaultKeyGenerator.setRole(2);
        if (ReflectionHelperAware.class.isAssignableFrom(generatorClass)) {
            RuntimeBeanReference cacheManagerReference = new RuntimeBeanReference(CACHING_REFLECTION_HELPER_BEAN_NAME);
            MutablePropertyValues propertyValues = defaultKeyGenerator.getPropertyValues();
            propertyValues.addPropertyValue("reflectionHelper", (Object)cacheManagerReference);
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(generatorName, (BeanDefinition)defaultKeyGenerator);
    }

    protected RuntimeBeanReference setupCacheAttributeSource(Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference defaultCacheKeyGenerator, RuntimeBeanReference cachingReflectionHelper) {
        RootBeanDefinition cacheAttributeSource = new RootBeanDefinition(CacheAttributeSourceImpl.class);
        cacheAttributeSource.setSource(elementSource);
        cacheAttributeSource.setRole(2);
        MutablePropertyValues propertyValues = cacheAttributeSource.getPropertyValues();
        RuntimeBeanReference cacheManagerReference = new RuntimeBeanReference(element.getAttribute(XSD_ATTR__CACHE_MANAGER));
        propertyValues.addPropertyValue("cacheManager", (Object)cacheManagerReference);
        propertyValues.addPropertyValue("createCaches", (Object)Boolean.parseBoolean(element.getAttribute(XSD_ATTR__CREATE_MISSING_CACHES)));
        propertyValues.addPropertyValue("defaultCacheKeyGenerator", (Object)defaultCacheKeyGenerator);
        propertyValues.addPropertyValue("reflectionHelper", (Object)cachingReflectionHelper);
        String blockingCacheScope = element.getAttribute(XSD_ATTR__SELF_POPULATING_CACHE_SCOPE);
        if (blockingCacheScope != null) {
            propertyValues.addPropertyValue("selfPopulatingCacheScope", (Object)SelfPopulatingCacheScope.valueOf(blockingCacheScope.toUpperCase()));
        }
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String cacheAttributeSourceBeanName = readerContext.registerWithGeneratedName((BeanDefinition)cacheAttributeSource);
        return new RuntimeBeanReference(cacheAttributeSourceBeanName);
    }

    protected RuntimeBeanReference setupPointcut(Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheAttributeSource) {
        RootBeanDefinition pointcut = new RootBeanDefinition(CacheStaticMethodMatcherPointcut.class);
        pointcut.setSource(elementSource);
        pointcut.setRole(2);
        MutablePropertyValues propertyValues = pointcut.getPropertyValues();
        propertyValues.addPropertyValue("cacheAttributeSource", (Object)cacheAttributeSource);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String pointcutBeanName = readerContext.registerWithGeneratedName((BeanDefinition)pointcut);
        return new RuntimeBeanReference(pointcutBeanName);
    }

    protected RuntimeBeanReference setupInterceptor(Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheableAttributeSourceRuntimeReference) {
        RootBeanDefinition interceptor = new RootBeanDefinition(EhCacheInterceptor.class);
        interceptor.setSource(elementSource);
        interceptor.setRole(2);
        MutablePropertyValues propertyValues = interceptor.getPropertyValues();
        propertyValues.addPropertyValue("cacheAttributeSource", (Object)cacheableAttributeSourceRuntimeReference);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        String interceptorBeanName = readerContext.registerWithGeneratedName((BeanDefinition)interceptor);
        return new RuntimeBeanReference(interceptorBeanName);
    }

    protected RuntimeBeanReference setupPointcutAdvisor(Element element, ParserContext parserContext, Object elementSource, RuntimeBeanReference cacheablePointcutBeanReference, RuntimeBeanReference cachingInterceptorBeanReference) {
        RootBeanDefinition pointcutAdvisor = new RootBeanDefinition(DefaultBeanFactoryPointcutAdvisor.class);
        pointcutAdvisor.setSource(elementSource);
        pointcutAdvisor.setRole(2);
        MutablePropertyValues propertyValues = pointcutAdvisor.getPropertyValues();
        propertyValues.addPropertyValue("adviceBeanName", (Object)cachingInterceptorBeanReference.getBeanName());
        propertyValues.addPropertyValue("pointcut", (Object)cacheablePointcutBeanReference);
        if (element.hasAttribute("order")) {
            propertyValues.addPropertyValue("order", (Object)element.getAttribute("order"));
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition(EHCACHE_CACHING_ADVISOR_BEAN_NAME, (BeanDefinition)pointcutAdvisor);
        return new RuntimeBeanReference(EHCACHE_CACHING_ADVISOR_BEAN_NAME);
    }
}

