/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.config;

import com.googlecode.ehcache.annotations.config.ExactCacheNameMatcherImpl;
import com.googlecode.ehcache.annotations.config.NotCacheNameMatcherImpl;
import com.googlecode.ehcache.annotations.config.PatternCacheNameMatcherImpl;
import com.googlecode.ehcache.annotations.impl.CacheNameMatcher;
import com.googlecode.ehcache.annotations.impl.ExpiredElementEvictor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EhCacheConfigBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String XSD_ELEMENT__EVICT_EXPIRED_ELEMENTS = "evict-expired-elements";
    public static final String XSD_ATTRIBUTE__INTERVAL = "interval";
    public static final String XSD_ELEMENT__INCLUDE = "include";
    public static final String XSD_ELEMENT__EXCLUDE = "exclude";
    public static final String XSD_ATTRIBUTE__NAME = "name";
    public static final String XSD_ATTRIBUTE__PATTERN = "pattern";
    public static final String EHCACHE_CONFIG_EVICTION_TASK_BEAN_NAME = EhCacheConfigBeanDefinitionParser.class.getPackage().getName() + ".internalEhCacheEvictionTask";
    public static final CacheNameMatcher INCLUDE_ALL_CACHE_NAME_MATCHER = new PatternCacheNameMatcherImpl(".*");

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object elementSource = parserContext.extractSource((Object)element);
        NodeList evictExpiredElements = element.getElementsByTagNameNS(element.getNamespaceURI(), XSD_ELEMENT__EVICT_EXPIRED_ELEMENTS);
        if (evictExpiredElements.getLength() > 1) {
            throw new BeanCreationException("Only one 'evict-expired-elements' is allowed");
        }
        int evictExpiredElementsLength = evictExpiredElements.getLength();
        if (evictExpiredElementsLength == 1) {
            Element evictExpiredElement = (Element)evictExpiredElements.item(0);
            String interval = evictExpiredElement.getAttribute(XSD_ATTRIBUTE__INTERVAL);
            List<CacheNameMatcher> cacheNameMatchers = this.parseEvictExpiredElement(evictExpiredElement);
            RuntimeBeanReference cacheManagerReference = new RuntimeBeanReference(element.getAttribute("cache-manager"));
            RootBeanDefinition expiredElementEvictor = new RootBeanDefinition(ExpiredElementEvictor.class);
            expiredElementEvictor.setSource(elementSource);
            expiredElementEvictor.setRole(2);
            MutablePropertyValues propertyValues = expiredElementEvictor.getPropertyValues();
            propertyValues.addPropertyValue("cacheManager", (Object)cacheManagerReference);
            propertyValues.addPropertyValue("cacheNameMatchers", cacheNameMatchers);
            propertyValues.addPropertyValue(XSD_ATTRIBUTE__INTERVAL, (Object)interval);
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            registry.registerBeanDefinition(EHCACHE_CONFIG_EVICTION_TASK_BEAN_NAME, (BeanDefinition)expiredElementEvictor);
        }
        return null;
    }

    protected List<CacheNameMatcher> parseEvictExpiredElement(Element evictExpiredElement) {
        List<Object> cacheNameMatchers = new ArrayList();
        NodeList childNodes = evictExpiredElement.getChildNodes();
        int childNodesLength = childNodes.getLength();
        boolean configContainsExcludes = false;
        boolean configContainsIncludes = false;
        if (0 != childNodesLength) {
            for (int index = 0; index < childNodesLength; ++index) {
                Node childNode = childNodes.item(index);
                if (1 != childNode.getNodeType()) continue;
                String childName = childNode.getLocalName();
                NamedNodeMap childAttributes = childNode.getAttributes();
                Node nameAttr = childAttributes.getNamedItem(XSD_ATTRIBUTE__NAME);
                CacheNameMatcher matcher = null;
                if (null != nameAttr) {
                    String matcherValue = nameAttr.getTextContent();
                    matcher = new ExactCacheNameMatcherImpl(matcherValue);
                } else {
                    Node patternAttr = childAttributes.getNamedItem(XSD_ATTRIBUTE__PATTERN);
                    if (null != patternAttr) {
                        String matcherValue = patternAttr.getTextContent();
                        matcher = new PatternCacheNameMatcherImpl(matcherValue);
                    }
                }
                if (null == matcher) continue;
                if (XSD_ELEMENT__INCLUDE.equals(childName)) {
                    cacheNameMatchers.add(matcher);
                    configContainsIncludes = true;
                    continue;
                }
                if (!XSD_ELEMENT__EXCLUDE.equals(childName)) continue;
                cacheNameMatchers.add(new NotCacheNameMatcherImpl(matcher));
                configContainsExcludes = true;
            }
        }
        if (0 == cacheNameMatchers.size()) {
            cacheNameMatchers = Collections.singletonList(INCLUDE_ALL_CACHE_NAME_MATCHER);
        } else if (!configContainsIncludes && configContainsExcludes) {
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.add(INCLUDE_ALL_CACHE_NAME_MATCHER);
            newList.addAll(cacheNameMatchers);
            cacheNameMatchers = newList;
        }
        return Collections.unmodifiableList(cacheNameMatchers);
    }
}

