/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.CacheKeyGenerator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheKeyGenerator<T extends Serializable>
implements CacheKeyGenerator<T> {
    private static final ThreadLocal<Map<Object, Object>> REGISTRY = new ThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return new IdentityHashMap<Object, Object>();
        }
    };
    private boolean checkforCycles = false;
    private boolean includeMethod = true;
    private boolean includeParameterTypes = true;

    public AbstractCacheKeyGenerator() {
        this(true, true);
    }

    public AbstractCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        this.includeMethod = includeMethod;
        this.includeParameterTypes = includeParameterTypes;
    }

    public final boolean isIncludeMethod() {
        return this.includeMethod;
    }

    public final void setIncludeMethod(boolean includeMethod) {
        this.includeMethod = includeMethod;
    }

    public final boolean isIncludeParameterTypes() {
        return this.includeParameterTypes;
    }

    public final void setIncludeParameterTypes(boolean includeParameterTypes) {
        this.includeParameterTypes = includeParameterTypes;
    }

    public final boolean isCheckforCycles() {
        return this.checkforCycles;
    }

    public final void setCheckforCycles(boolean checkforCycles) {
        this.checkforCycles = checkforCycles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T generateKey(MethodInvocation methodInvocation) {
        Object[] arguments = methodInvocation.getArguments();
        if (this.includeMethod) {
            Method method = methodInvocation.getMethod();
            Class<?> declaringClass = method.getDeclaringClass();
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            if (this.includeParameterTypes) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                return this.generateKey(declaringClass, name, returnType, parameterTypes, arguments);
            }
            return this.generateKey(declaringClass, name, returnType, arguments);
        }
        try {
            T t = this.generateKey(arguments);
            return t;
        }
        finally {
            if (this.checkforCycles) {
                REGISTRY.remove();
            }
        }
    }

    protected final boolean register(Object element) {
        if (!this.checkforCycles) {
            return true;
        }
        Map<Object, Object> registry = REGISTRY.get();
        return registry.put(element, element) == null;
    }

    protected final void unregister(Object element) {
        if (!this.checkforCycles) {
            return;
        }
        Map<Object, Object> registry = REGISTRY.get();
        registry.remove(element);
    }

    @Override
    public abstract T generateKey(Object ... var1);
}

