/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling;

import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableCellProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableRowProperties;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

public abstract class AbstractDocumentHandler
extends Writer
implements IDocumentHandler {
    private final BufferedElement parent;
    private final IContext context;
    private final Stack<Boolean> listStack;
    private StringWriter beforeWriter;
    private StringWriter bodyWriter;
    private StringWriter endWriter;
    private StringWriter currentWriter;
    private final String entryName;
    private Stack<TableProperties> tablesStack;
    private Stack<Writer> tempWriterStack;

    public AbstractDocumentHandler(BufferedElement parent, IContext context, String entryName) {
        this.parent = parent;
        this.context = context;
        this.listStack = new Stack();
        this.entryName = entryName;
        this.tablesStack = null;
    }

    public void handleString(String s) throws IOException {
        this.getCurrentWriter().write(s);
    }

    public final void startOrderedList(ListProperties properties) throws IOException {
        this.listStack.push(true);
        this.doStartOrderedList(properties);
    }

    public final void endOrderedList() throws IOException {
        this.listStack.pop();
        this.doEndOrderedList();
    }

    public final void startUnorderedList(ListProperties properties) throws IOException {
        this.listStack.push(false);
        this.doStartUnorderedList(properties);
    }

    public final void endUnorderedList() throws IOException {
        this.listStack.pop();
        this.doEndUnorderedList();
    }

    protected boolean getCurrentListOrder() {
        if (this.listStack.isEmpty()) {
            return false;
        }
        return this.listStack.peek();
    }

    protected int getCurrentListIndex() {
        if (this.listStack.isEmpty()) {
            return 0;
        }
        return this.listStack.size() - 1;
    }

    public final void startTable(TableProperties properties) throws IOException {
        if (this.tablesStack == null) {
            this.tablesStack = new Stack();
        }
        this.tablesStack.push(properties);
        this.doStartTable(properties);
    }

    public final void endTable() throws IOException {
        TableProperties properties = this.tablesStack.pop();
        this.doEndTable(properties);
    }

    public final void startTableRow(TableRowProperties properties) throws IOException {
        TableProperties tableProperties = this.tablesStack.peek();
        tableProperties.setRowCount(tableProperties.getRowCount() + 1);
        tableProperties.setColumnCount(0);
        this.doStartTableRow(properties);
    }

    public final void endTableRow() throws IOException {
        this.doEndTableRow();
    }

    public final void startTableCell(TableCellProperties properties) throws IOException {
        TableProperties tableProperties = this.tablesStack.peek();
        tableProperties.setColumnCount(tableProperties.getColumnCount() + 1);
        this.doStartTableCell(properties);
    }

    public final void endTableCell() throws IOException {
        this.doEndTableCell();
    }

    public BufferedElement getParent() {
        return this.parent;
    }

    public IContext getContext() {
        return this.context;
    }

    public String getTextBefore() {
        if (this.beforeWriter != null) {
            return this.beforeWriter.toString();
        }
        return "";
    }

    public String getTextBody() {
        if (this.bodyWriter != null) {
            return this.bodyWriter.toString();
        }
        return "";
    }

    public String getTextEnd() {
        if (this.endWriter != null) {
            return this.endWriter.toString();
        }
        return "";
    }

    public void setTextLocation(IDocumentHandler.TextLocation location) {
        switch (location) {
            case Before: {
                if (this.beforeWriter == null) {
                    this.beforeWriter = new StringWriter();
                }
                this.currentWriter = this.beforeWriter;
                break;
            }
            case Body: {
                if (this.bodyWriter == null) {
                    this.bodyWriter = new StringWriter();
                }
                this.currentWriter = this.bodyWriter;
                break;
            }
            case End: {
                if (this.endWriter == null) {
                    this.endWriter = new StringWriter();
                }
                this.currentWriter = this.endWriter;
            }
        }
    }

    public void pushTempWriter() {
        if (this.tempWriterStack == null) {
            this.tempWriterStack = new Stack();
        }
        this.tempWriterStack.push(new StringWriter());
    }

    public void popTempWriter(String before) throws IOException {
        Writer writer = this.tempWriterStack.pop();
        this.getCurrentWriter().append(before);
        this.getCurrentWriter().append(writer.toString());
    }

    public void close() throws IOException {
        this.getCurrentWriter().close();
    }

    public void flush() throws IOException {
        this.getCurrentWriter().flush();
    }

    public void write(char[] arg0, int arg1, int arg2) throws IOException {
        this.getCurrentWriter().write(arg0, arg1, arg2);
    }

    public Writer getCurrentWriter() {
        if (this.tempWriterStack != null && !this.tempWriterStack.isEmpty()) {
            return this.tempWriterStack.peek();
        }
        if (this.currentWriter == null) {
            this.setTextLocation(IDocumentHandler.TextLocation.Body);
        }
        return this.currentWriter;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("@textBefore=" + this.getTextBefore());
        result.append("\n");
        result.append("@textBody=" + this.getTextBody());
        result.append("\n");
        result.append("@textEnd=" + this.getTextEnd());
        return result.toString();
    }

    protected abstract void doStartUnorderedList(ListProperties var1) throws IOException;

    protected abstract void doStartOrderedList(ListProperties var1) throws IOException;

    protected abstract void doEndUnorderedList() throws IOException;

    protected abstract void doEndOrderedList() throws IOException;

    protected abstract void doStartTable(TableProperties var1) throws IOException;

    protected abstract void doEndTable(TableProperties var1) throws IOException;

    protected abstract void doStartTableRow(TableRowProperties var1) throws IOException;

    protected abstract void doEndTableRow() throws IOException;

    protected abstract void doStartTableCell(TableCellProperties var1) throws IOException;

    protected abstract void doEndTableCell() throws IOException;
}

