/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.ClassLocator;
import flexjson.JSONTokener;
import flexjson.ObjectBinder;
import flexjson.ObjectFactory;
import flexjson.Path;
import flexjson.factories.ClassLocatorObjectFactory;
import flexjson.locators.StaticClassLocator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONDeserializer<T> {
    private Map<Class, ObjectFactory> typeFactories = new HashMap<Class, ObjectFactory>();
    private Map<Path, ObjectFactory> pathFactories = new HashMap<Path, ObjectFactory>();

    public T deserialize(String input) {
        ObjectBinder binder = this.createObjectBinder();
        return (T)binder.bind(new JSONTokener(input).nextValue());
    }

    public T deserialize(String input, Class root) {
        ObjectBinder binder = this.createObjectBinder();
        return (T)binder.bind(new JSONTokener(input).nextValue(), root);
    }

    private ObjectBinder createObjectBinder() {
        ObjectBinder binder = new ObjectBinder();
        for (Class clazz : this.typeFactories.keySet()) {
            binder.use(clazz, this.typeFactories.get(clazz));
        }
        for (Path p : this.pathFactories.keySet()) {
            binder.use(p, this.pathFactories.get(p));
        }
        return binder;
    }

    public JSONDeserializer<T> use(String path, ClassLocator locator) {
        this.pathFactories.put(Path.parse(path), new ClassLocatorObjectFactory(locator));
        return this;
    }

    public JSONDeserializer<T> use(String path, Class clazz) {
        return this.use(path, new StaticClassLocator(clazz));
    }

    public JSONDeserializer<T> use(Class clazz, ObjectFactory factory) {
        this.typeFactories.put(clazz, factory);
        return this;
    }

    public JSONDeserializer<T> use(String path, ObjectFactory factory) {
        this.pathFactories.put(Path.parse(path), factory);
        return this;
    }

    public JSONDeserializer<T> use(ObjectFactory factory, String ... paths) {
        for (String p : paths) {
            this.use(p, factory);
        }
        return this;
    }
}

