/*
 * Decompiled with CFR 0.152.
 */
package flexjson.transformer;

import flexjson.ChainedSet;
import flexjson.JSONContext;
import flexjson.JSONException;
import flexjson.Path;
import flexjson.TypeContext;
import flexjson.transformer.AbstractTransformer;
import flexjson.transformer.TransformerWrapper;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ObjectTransformer
extends AbstractTransformer {
    public void transform(Object object) {
        JSONContext context = this.getContext();
        Path path = context.getPath();
        ChainedSet visits = context.getVisits();
        try {
            if (!visits.contains(object)) {
                TransformerWrapper transformer;
                Object value;
                context.setVisits(new ChainedSet(visits));
                context.getVisits().add(object);
                BeanInfo info = Introspector.getBeanInfo(this.resolveClass(object));
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                TypeContext typeContext = context.writeOpenObject();
                for (PropertyDescriptor prop : props) {
                    String name = prop.getName();
                    path.enqueue(name);
                    Method accessor = prop.getReadMethod();
                    if (accessor != null && context.isIncluded(prop)) {
                        value = accessor.invoke(object, (Object[])null);
                        if (!context.getVisits().contains(value)) {
                            transformer = (TransformerWrapper)context.getTransformer(value);
                            if (!transformer.isInline().booleanValue()) {
                                if (!typeContext.isFirst()) {
                                    context.writeComma();
                                }
                                typeContext.setFirst(false);
                                context.writeName(name);
                            }
                            typeContext.setPropertyName(name);
                            transformer.transform(value);
                        }
                    }
                    path.pop();
                }
                for (Class<?> current = object.getClass(); current != null; current = current.getSuperclass()) {
                    Field[] ff;
                    for (Field field : ff = current.getDeclaredFields()) {
                        path.enqueue(field.getName());
                        if (context.isValidField(field) && context.isIncluded(field) && !context.getVisits().contains(field.get(object))) {
                            value = field.get(object);
                            transformer = (TransformerWrapper)context.getTransformer(value);
                            if (!transformer.isInline().booleanValue()) {
                                if (!typeContext.isFirst()) {
                                    context.writeComma();
                                }
                                typeContext.setFirst(false);
                                context.writeName(field.getName());
                            }
                            typeContext.setPropertyName(field.getName());
                            transformer.transform(value);
                        }
                        path.pop();
                    }
                }
                context.writeCloseObject();
                context.setVisits((ChainedSet)context.getVisits().getParent());
            }
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException("Error trying to deepSerialize", e);
        }
    }

    protected Class resolveClass(Object obj) {
        return obj.getClass();
    }
}

