/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.jfinal.access;

import com.jfinal.plugin.activerecord.Config;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.transaction.DataSourceTransactionInterceptor;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.access.transaction.TransactionStatus;
import org.snaker.jfinal.JfinalHelper;

public class JfinalTransactionInterceptor
extends DataSourceTransactionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TransactionInterceptor.class);

    public void initialize(Object accessObject) {
    }

    protected TransactionStatus getTransaction() {
        try {
            boolean isNew = false;
            Config config = JfinalHelper.getConfig();
            Connection conn = config.getThreadLocalConnection();
            if (conn == null) {
                conn = config.getConnection();
                config.setThreadLocalConnection(conn);
                conn.setAutoCommit(false);
                isNew = true;
            }
            return new TransactionStatus((Object)conn, isNew);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void commit(TransactionStatus status) {
        super.commit(status);
        Config config = JfinalHelper.getConfig();
        config.removeThreadLocalConnection();
    }

    protected void rollback(TransactionStatus status) {
        super.rollback(status);
        Config config = JfinalHelper.getConfig();
        config.removeThreadLocalConnection();
    }
}

