/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.components.ContextBean;
import org.apache.struts2.components.Param;
import org.apache.struts2.util.TextProviderHelper;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="text", tldTagClass="org.apache.struts2.views.jsp.TextTag", description="Render a I18n text message")
public class Text
extends ContextBean
implements Param.UnnamedParametric {
    private static final Logger LOG = LogManager.getLogger(Text.class);
    protected List<Object> values = Collections.emptyList();
    protected String actualName;
    protected String name;
    protected String searchStack;

    public Text(ValueStack stack) {
        super(stack);
    }

    @StrutsTagAttribute(description="Name of resource property to fetch", required=true)
    public void setName(String name) {
        this.name = name;
    }

    @StrutsTagAttribute(description="Search the stack if property is not found on resources", type="Boolean", defaultValue="false")
    public void setSearchValueStack(String searchStack) {
        this.searchStack = searchStack;
    }

    @Override
    public boolean usesBody() {
        return true;
    }

    @Override
    public boolean end(Writer writer, String body) {
        String msg;
        this.actualName = this.findString(this.name, "name", "You must specify the i18n key. Example: welcome.header");
        String defaultMessage = StringUtils.isNotEmpty((CharSequence)body) ? body : this.actualName;
        Boolean doSearchStack = false;
        if (this.searchStack != null) {
            Object value = this.findValue(this.searchStack, Boolean.class);
            doSearchStack = value != null ? (Boolean)value : false;
        }
        if ((msg = TextProviderHelper.getText(this.actualName, defaultMessage, this.values, this.getStack(), doSearchStack)) != null) {
            try {
                if (this.getVar() == null) {
                    writer.write(msg);
                } else {
                    this.putInContext(msg);
                }
            }
            catch (IOException e) {
                LOG.error("Could not write out Text tag", (Throwable)e);
            }
        }
        return super.end(writer, "");
    }

    @Override
    public void addParameter(String key, Object value) {
        this.addParameter(value);
    }

    @Override
    public void addParameter(Object value) {
        if (this.values.isEmpty()) {
            this.values = new ArrayList<Object>(4);
        }
        this.values.add(value);
    }
}

