/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.result.StrutsResultSupport;
import org.apache.struts2.views.util.UrlHelper;

public class ServletDispatcherResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1970659272360685627L;
    private static final Logger LOG = LogManager.getLogger(ServletDispatcherResult.class);
    private UrlHelper urlHelper;

    public ServletDispatcherResult() {
    }

    public ServletDispatcherResult(String location) {
        super(location);
    }

    @Inject
    public void setUrlHelper(UrlHelper urlHelper) {
        this.urlHelper = urlHelper;
    }

    @Override
    public void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        LOG.debug("Forwarding to location: {}", (Object)finalLocation);
        PageContext pageContext = ServletActionContext.getPageContext();
        if (pageContext != null) {
            pageContext.include(finalLocation);
        } else {
            HttpServletRequest request = ServletActionContext.getRequest();
            HttpServletResponse response = ServletActionContext.getResponse();
            RequestDispatcher dispatcher = request.getRequestDispatcher(finalLocation);
            if (StringUtils.isNotEmpty((CharSequence)finalLocation) && finalLocation.indexOf("?") > 0) {
                String queryString = finalLocation.substring(finalLocation.indexOf("?") + 1);
                HttpParameters parameters = this.getParameters(invocation);
                Map<String, Object> queryParams = this.urlHelper.parseQueryString(queryString, true);
                if (queryParams != null && !queryParams.isEmpty()) {
                    parameters = HttpParameters.create(queryParams).withParent(parameters).build();
                    invocation.getInvocationContext().setParameters(parameters);
                    invocation.getInvocationContext().getContextMap().put("parameters", parameters);
                }
            }
            if (dispatcher == null) {
                LOG.warn("Location {} not found!", (Object)finalLocation);
                response.sendError(404, "result '" + finalLocation + "' not found");
                return;
            }
            Boolean insideActionTag = (Boolean)ObjectUtils.defaultIfNull((Object)request.getAttribute("struts.actiontag.invocation"), (Object)Boolean.FALSE);
            if (!insideActionTag.booleanValue() && !response.isCommitted() && request.getAttribute("javax.servlet.include.servlet_path") == null) {
                request.setAttribute("struts.view_uri", (Object)finalLocation);
                request.setAttribute("struts.request_uri", (Object)request.getRequestURI());
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected HttpParameters getParameters(ActionInvocation invocation) {
        return invocation.getInvocationContext().getParameters();
    }
}

