/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.hssf.util.Region;
import org.jxls.Formula;
import org.jxls.Property;
import org.jxls.Row;
import org.jxls.RowCollection;

public class Cell {
    private Row row;
    private Property collectionProperty;
    private HSSFCell hssfCell;
    private Formula formula;
    private String label;
    private int dependentRowNumber;
    private String collectionName;
    private String hssfCellValue;
    private String stringCellValue;
    private String metaInfo;
    private Region mergedRegion;
    private List expressions = new ArrayList();
    private RowCollection rowCollection;

    public Cell(HSSFCell hssfCell, Row row) {
        this.setHssfCell(hssfCell);
        this.setRow(row);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List expressions) {
        this.expressions = expressions;
    }

    public Region getMergedRegion() {
        return this.mergedRegion;
    }

    public int getDependentRowNumber() {
        return this.dependentRowNumber;
    }

    public RowCollection getRowCollection() {
        return this.rowCollection;
    }

    public void setRowCollection(RowCollection rowCollection) {
        this.rowCollection = rowCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    public void setCollectionProperty(Property collectionProperty) {
        this.collectionProperty = collectionProperty;
    }

    public HSSFCell getHssfCell() {
        return this.hssfCell;
    }

    public void setHssfCell(HSSFCell hssfCell) {
        this.hssfCell = hssfCell;
    }

    public String toCellName() {
        CellReference cellRef = new CellReference(this.getRow().getHssfRow().getRowNum(), (int)this.getHssfCell().getCellNum());
        return cellRef.toString();
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public boolean isFormula() {
        return this.getFormula() != null;
    }

    public String getHssfCellValue() {
        return this.hssfCellValue;
    }

    public String getStringCellValue() {
        return this.stringCellValue;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    public boolean isEmpty() {
        return this.getHssfCellValue() == null || this.getHssfCellValue().length() == 0 || this.getHssfCell().getCellType() == 3;
    }

    public boolean isNull() {
        return this.getHssfCell() == null;
    }

    public String toString() {
        return this.getHssfCellValue();
    }

    public void setDependentRowNumber(int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setHssfCellValue(String hssfCellValue) {
        this.hssfCellValue = hssfCellValue;
    }

    public void setStringCellValue(String stringCellValue) {
        this.stringCellValue = stringCellValue;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setMergedRegion(Region mergedRegion) {
        this.mergedRegion = mergedRegion;
    }
}

