/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.jxls.Cell;
import org.jxls.Configuration;
import org.jxls.DateUtil;
import org.jxls.Expression;
import org.jxls.Formula;
import org.jxls.ParsePropertyException;
import org.jxls.Row;
import org.jxls.Util;

public final class CellParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Cell cell;
    private Configuration configuration;

    public CellParser(HSSFCell hssfCell, Row row) {
        this.cell = new Cell(hssfCell, row);
    }

    public CellParser(HSSFCell hssfCell, Row row, Configuration configuration) {
        this.cell = new Cell(hssfCell, row);
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public CellParser(Cell cell) {
        this.cell = cell;
    }

    final Cell parseCell(Map beans) {
        if (this.cell.getHssfCell() != null) {
            try {
                if (this.cell.getHssfCell().getCellType() == 1) {
                    this.cell.setHssfCellValue(this.cell.getHssfCell().getStringCellValue());
                    this.parseCellValue(beans);
                }
            }
            catch (ParsePropertyException e) {
                this.log.error((Object)("Can't get value for property=" + this.cell.getCollectionProperty().getProperty()), (Throwable)e);
                throw new RuntimeException(e);
            }
            this.updateMergedRegions();
        }
        return this.cell;
    }

    private void parseFormula() {
        int i = this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken());
        String expr = this.cell.getHssfCellValue().substring(2, i);
        this.cell.setFormula(new Formula(expr));
        this.cell.getFormula().setRowNum(new Integer(this.cell.getRow().getHssfRow().getRowNum()));
        this.cell.getFormula().setCellNum(new Integer(this.cell.getHssfCell().getCellNum()));
        if (i + 1 < this.cell.getHssfCellValue().length()) {
            String tail = this.cell.getHssfCellValue().substring(i + 1);
            int j = tail.indexOf(this.configuration.getMetaInfoToken());
            if (j >= 0) {
                this.cell.setMetaInfo(tail.substring(j));
                if (j > 0) {
                    this.cell.setLabel(tail.substring(0, j));
                }
                this.cell.setCollectionName(tail.substring(j + 2));
            } else {
                this.cell.setLabel(tail);
            }
        }
        this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, i + 1));
    }

    private void parseCellExpression(Map beans) {
        int k;
        this.cell.setCollectionProperty(null);
        String curValue = this.cell.getHssfCellValue();
        int depRowNum = 0;
        int j = curValue.lastIndexOf(this.configuration.getMetaInfoToken());
        if (j >= 0) {
            this.cell.setStringCellValue(this.cell.getHssfCellValue().substring(0, j));
            this.cell.setMetaInfo(this.cell.getHssfCellValue().substring(j + 2));
            String tail = curValue.substring(j + 2);
            k = tail.indexOf(":");
            if (k >= 0) {
                try {
                    depRowNum = Integer.parseInt(tail.substring(k + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.cell.setCollectionName(tail.substring(0, k));
            } else {
                this.cell.setCollectionName(tail);
            }
            curValue = curValue.substring(0, j);
        } else {
            this.cell.setStringCellValue(this.cell.getHssfCellValue());
        }
        try {
            while (curValue.length() > 0) {
                int i = curValue.indexOf(this.configuration.getStartExpressionToken());
                if (i >= 0) {
                    k = curValue.indexOf(this.configuration.getEndExpressionToken(), i + 2);
                    if (k >= 0) {
                        Expression expression;
                        String expr = curValue.substring(i + 2, k);
                        if (i > 0) {
                            String before = curValue.substring(0, i);
                            this.cell.getExpressions().add(new Expression(before));
                        }
                        if ((expression = new Expression(expr, beans)).getCollectionProperty() != null) {
                            if (this.cell.getCollectionProperty() == null) {
                                this.cell.setCollectionName(expression.getCollectionProperty().getFullCollectionName());
                                this.cell.setCollectionProperty(expression.getCollectionProperty());
                                this.cell.setDependentRowNumber(depRowNum);
                            } else if (this.log.isInfoEnabled()) {
                                this.log.info((Object)"Only the same collection property in a cell is allowed.");
                            }
                        }
                        this.cell.getExpressions().add(expression);
                        curValue = curValue.substring(k + 1, curValue.length());
                        continue;
                    }
                    this.cell.getExpressions().add(new Expression(curValue));
                    continue;
                }
                if (curValue.length() != this.cell.getHssfCellValue().length()) {
                    this.cell.getExpressions().add(new Expression(curValue));
                }
                curValue = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)"Can't parse expression", (Throwable)e);
        }
    }

    private void parseCellValue(Map beans) throws ParsePropertyException {
        if (this.cell.getHssfCellValue() != null) {
            if (this.cell.getHssfCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getHssfCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            } else {
                this.parseCellExpression(beans);
            }
        }
    }

    final void updateCellContent() {
        try {
            if (this.cell.getHssfCell() != null && this.cell.getHssfCell().getCellType() == 1) {
                this.cell.getHssfCell().setEncoding((short)1);
                if (this.cell.getCollectionProperty() == null) {
                    if (this.cell.getFormula() == null) {
                        if (this.cell.getExpressions().size() == 0) {
                            if (this.cell.getMetaInfo() != null) {
                                this.cell.getHssfCell().setCellValue(this.cell.getStringCellValue());
                            }
                        } else if (this.cell.getExpressions().size() == 1) {
                            Object value = ((Expression)this.cell.getExpressions().get(0)).evaluate();
                            if (value == null) {
                                this.cell.getHssfCell().setCellValue("");
                            } else if (value instanceof Double) {
                                this.cell.getHssfCell().setCellValue(((Double)value).doubleValue());
                            } else if (value instanceof BigDecimal) {
                                this.cell.getHssfCell().setCellValue(((BigDecimal)value).doubleValue());
                            } else if (value instanceof Date) {
                                this.cell.getHssfCell().setCellValue(DateUtil.convertDateToString((Date)value));
                            } else if (value instanceof Integer) {
                                this.cell.getHssfCell().setCellValue((double)((Integer)value).intValue());
                            } else if (value instanceof Long) {
                                this.cell.getHssfCell().setCellValue((double)((Long)value).longValue());
                            } else {
                                String fixedValue = value.toString();
                                if (fixedValue != null) {
                                    fixedValue = fixedValue.replaceAll("\r\n", "\n");
                                }
                                this.cell.getHssfCell().setCellValue(fixedValue);
                            }
                        } else if (this.cell.getExpressions().size() > 1) {
                            String value = "";
                            int i = 0;
                            while (i < this.cell.getExpressions().size()) {
                                Expression expr = (Expression)this.cell.getExpressions().get(i);
                                Object propValue = expr.evaluate();
                                if (propValue != null) {
                                    if (propValue instanceof Date) {
                                        propValue = DateUtil.convertDateToString((Date)propValue);
                                    }
                                    value = String.valueOf(value) + propValue.toString();
                                }
                                ++i;
                            }
                            this.cell.getHssfCell().setCellValue(value);
                        }
                    } else {
                        this.processFormulaCell();
                    }
                } else {
                    String value = "";
                    int i = 0;
                    while (i < this.cell.getExpressions().size()) {
                        Expression expr = (Expression)this.cell.getExpressions().get(i);
                        value = expr.getCollectionProperty() == null ? String.valueOf(value) + expr.evaluate() : String.valueOf(value) + this.configuration.getStartExpressionToken() + expr.getExpression() + this.configuration.getEndExpressionToken();
                        ++i;
                    }
                    this.cell.getHssfCell().setCellValue(value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.debug((Object)"Can't parse expression");
        }
    }

    private void processFormulaCell() {
        Formula formula = this.cell.getFormula();
        if (formula.isInline()) {
            if (this.cell.getCollectionName() != null) {
                this.cell.getHssfCell().setCellValue(this.cell.getStringCellValue());
            } else {
                String formulaString = formula.getInlineFormula(this.cell.getRow().getHssfRow().getRowNum() + 1);
                this.cell.getHssfCell().setCellFormula(formulaString);
            }
        }
    }

    private void updateMergedRegions() {
        this.cell.setMergedRegion(Util.getMergedRegion(this.cell.getRow().getHssfSheet(), this.cell.getRow().getHssfRow().getRowNum(), this.cell.getHssfCell().getCellNum()));
    }
}

