/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static String defaultDatePattern = "yyyy-MM-dd";
    private static String timePattern = "HH:mm";
    private static final SimpleDateFormat mFormatIso8601Day = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat mFormatZh = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    private static final SimpleDateFormat mFormatIso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static final String getDate(Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate != null) {
            df = new SimpleDateFormat(DateUtil.getDatePattern());
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final Date convertStringToDate(String aMask, String strDate) throws ParseException {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(aMask);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converting '" + strDate + "' to date with mask '" + aMask + "'"));
        }
        try {
            date = df.parse(strDate);
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return date;
    }

    public static final java.sql.Date convertUtilDateToSqlDate(Date date) {
        java.sql.Date current = new java.sql.Date(date.getTime());
        return current;
    }

    public static String getTimeNow(Date theTime) {
        return DateUtil.getDateTime(timePattern, theTime);
    }

    public static Calendar getToday() throws ParseException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getDatePattern());
        String todayAsString = df.format(today);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtil.convertStringToDate(todayAsString));
        return cal;
    }

    public static final String getDateTime(String aMask, Date aDate) {
        SimpleDateFormat df = null;
        String returnValue = "";
        if (aDate == null) {
            log.error((Object)"aDate is null!");
        } else {
            df = new SimpleDateFormat(aMask);
            returnValue = df.format(aDate);
        }
        return returnValue;
    }

    public static final String convertDateToString(Date aDate) {
        return DateUtil.getDateTime(DateUtil.getDatePattern(), aDate);
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        Date aDate = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("converting date with pattern: " + DateUtil.getDatePattern()));
            }
            aDate = DateUtil.convertStringToDate(DateUtil.getDatePattern(), strDate);
        }
        catch (ParseException pe) {
            log.error((Object)("Could not convert '" + strDate + "' to a date, throwing exception"));
            pe.printStackTrace();
            throw new ParseException(pe.getMessage(), pe.getErrorOffset());
        }
        return aDate;
    }

    public static String format(Date aDate, SimpleDateFormat aFormat) {
        if (aDate == null || aFormat == null) {
            return "";
        }
        return aFormat.format(aDate);
    }

    public static String format(Date aDate, String aFormat) {
        if (aDate == null || aFormat == null) {
            return "";
        }
        return new SimpleDateFormat(aFormat).format(aDate);
    }

    public static String getDefaultDateFormat(Date aDate) {
        return DateUtil.format(aDate, mFormatIso8601Day);
    }

    public static String getTimeFormat(Date aDate) {
        return DateUtil.format(aDate, mFormatIso8601);
    }

    public static String getZhTimeFormat(Date data) {
        return DateUtil.format(data, mFormatZh);
    }

    public static String getDefaultDateFormat(long aDate) {
        Date date = new Date();
        date.setTime(aDate);
        return DateUtil.format(date, mFormatIso8601Day);
    }

    public static String getDateofneed(int number) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date myDate = new Date();
        long myTime = myDate.getTime() / 1000L + (long)(86400 * number);
        myDate.setTime(myTime * 1000L);
        String needDate = formatter.format(myDate);
        return needDate;
    }

    public static String getYear(Date date) {
        String currentTime = DateUtil.getDefaultDateFormat(date.getTime());
        String year = currentTime.substring(0, 4);
        return year;
    }

    public static String getMonth(Date date) {
        String currentTime = DateUtil.getDefaultDateFormat(date.getTime());
        String month = currentTime.substring(5, 7);
        return month;
    }

    public static String getDay(Date date) {
        String currentTime = DateUtil.getDefaultDateFormat(date.getTime());
        String day = currentTime.substring(8, 10);
        return day;
    }

    public static String getDirectoryByDate(Date date) {
        return String.valueOf(DateUtil.getYear(date)) + File.separator + DateUtil.getMonth(date) + File.separator;
    }

    public static String getUrlByDate(Date date) {
        return String.valueOf(DateUtil.getYear(date)) + "/" + DateUtil.getMonth(date) + "/";
    }

    public static synchronized Date Add(Date date, int days, int hours, int minutes, int seconds) {
        Date dt = date;
        if (dt != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dt);
            if (days != 0) {
                calendar.add(5, days);
            }
            if (hours != 0) {
                calendar.add(10, hours);
            }
            if (minutes != 0) {
                calendar.add(12, minutes);
            }
            if (seconds != 0) {
                calendar.add(13, seconds);
            }
            dt = calendar.getTime();
        }
        return dt;
    }

    public static int getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }
}

