/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.jxls.Property;

public class Expression {
    String expression;
    Map beans;
    List properties = new ArrayList();
    org.apache.commons.jexl.Expression jexlExpresssion;
    Property collectionProperty;
    private static final String identifierRegex = "[a-zA-Z_][\\.a-zA-Z0-9_]*";
    private static final Pattern identifierPattern = Pattern.compile("[a-zA-Z_][\\.a-zA-Z0-9_]*");
    private static Matcher identifierMatcher = identifierPattern.matcher("");

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    public List getProperties() {
        return this.properties;
    }

    public String getExpression() {
        return this.expression;
    }

    public Expression(String expression) {
        this.expression = expression;
    }

    public Expression(String expression, Map beans) throws Exception {
        this.expression = expression;
        this.beans = beans;
        this.jexlExpresssion = ExpressionFactory.createExpression((String)expression);
        this.parse();
    }

    public Object evaluate() throws Exception {
        if (this.beans != null && !this.beans.isEmpty() && this.properties.size() > 0) {
            JexlContext context = JexlHelper.createContext();
            int i = 0;
            while (i < this.properties.size()) {
                Property prop = (Property)this.properties.get(i);
                context.getVars().put(prop.getProperty(), prop.getPropertyValue());
                ++i;
            }
            return this.jexlExpresssion.evaluate(context);
        }
        return this.expression;
    }

    private void parse() {
        identifierMatcher.reset(this.expression);
        while (identifierMatcher.find()) {
            Property property = new Property(identifierMatcher.group(), this.beans);
            this.properties.add(property);
            if (!property.isCollection() || this.collectionProperty != null) continue;
            this.collectionProperty = property;
        }
    }

    public String toString() {
        return this.expression;
    }
}

