/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jxls.Cell;
import org.jxls.ListRange;

public class Formula {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String formula;
    private Integer rowNum;
    private Integer cellNum;
    static final String inlineFormulaToken = "#";
    static final String formulaListRangeToken = "@";

    public Formula(String formula) {
        this.formula = formula;
    }

    public Formula() {
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getCellNum() {
        return this.cellNum;
    }

    public void setCellNum(Integer cellNum) {
        this.cellNum = cellNum;
    }

    public boolean isInline() {
        return this.formula.indexOf(inlineFormulaToken) >= 0;
    }

    public String getInlineFormula(int n) {
        if (this.isInline()) {
            return this.formula.replaceAll(inlineFormulaToken, Integer.toString(n));
        }
        return this.formula;
    }

    /*
     * Enabled aggressive block sorting
     */
    String getAppliedFormula(Map listRanges, Map namedCells) {
        String codedFormula = this.formula;
        String appliedFormula = "";
        String delimiter = formulaListRangeToken;
        int index = codedFormula.indexOf(delimiter);
        boolean isExpression = false;
        while (index >= 0) {
            String token = codedFormula.substring(0, index);
            if (isExpression) {
                if (listRanges.containsKey(token)) {
                    appliedFormula = String.valueOf(appliedFormula) + ((ListRange)listRanges.get(token)).toExcelCellRange();
                } else {
                    if (!namedCells.containsKey(token)) {
                        this.log.warn((Object)("can't find list range or named cell for " + token));
                        return null;
                    }
                    appliedFormula = String.valueOf(appliedFormula) + ((Cell)namedCells.get(token)).toCellName();
                }
            } else {
                appliedFormula = String.valueOf(appliedFormula) + token;
            }
            codedFormula = codedFormula.substring(index + 1);
            index = codedFormula.indexOf(delimiter);
            boolean bl = isExpression = !isExpression;
        }
        return String.valueOf(appliedFormula) + codedFormula;
    }

    public String toString() {
        return "Formula{formula='" + this.formula + "'" + ", rowNum=" + this.rowNum + ", cellNum=" + this.cellNum + "}";
    }
}

