/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Property {
    protected final Log log = LogFactory.getLog(this.getClass());
    List propertyTokens = new ArrayList();
    private String beanName;
    private Object bean;
    private String collectionName;
    private Collection collection;
    private String property;
    private Object propertyValue;

    public Property(String value) {
        this.propertyValue = value;
    }

    Property(String property, Map beans) {
        this.property = property;
        this.propertyValue = this.getPropertyValue(beans);
    }

    public boolean isConstant() {
        return this.property == null;
    }

    public Object getPropertyValue(Map beans) {
        Object propertyValue = null;
        StringTokenizer parser = new StringTokenizer(this.property, ".");
        String prop = null;
        this.beanName = null;
        this.collectionName = null;
        this.collection = null;
        this.bean = null;
        while (parser.hasMoreTokens() && this.collection == null) {
            String propToken = parser.nextToken();
            if (this.bean == null) {
                if (beans.containsKey(propToken)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found bean for beanName=" + propToken));
                    }
                    this.bean = beans.get(propToken);
                    this.beanName = propToken;
                    if (!(this.bean instanceof Collection)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Bean is collection");
                    }
                    this.collectionName = this.beanName;
                    this.collection = (Collection)this.bean;
                    this.beanName = null;
                    this.bean = null;
                    continue;
                }
                this.log.error((Object)("Can't find bean " + propToken));
                return null;
            }
            propertyValue = this.getProperty(this.bean, prop = prop == null ? propToken : String.valueOf(prop) + "." + propToken);
            if (propertyValue instanceof Collection) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found collection property = " + prop + " in bean " + this.bean + " (beanName=" + this.beanName + ")"));
                }
                this.collectionName = prop;
                this.collection = (Collection)propertyValue;
                continue;
            }
            if (propertyValue == null) break;
        }
        if (this.collectionName != null) {
            propertyValue = null;
        }
        this.propertyValue = propertyValue;
        return propertyValue;
    }

    public boolean isCollection() {
        return this.collectionName != null;
    }

    public boolean isNull() {
        return this.getPropertyValue() == null;
    }

    private Object getProperty(Object bean, String propertyName) {
        Object value = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getting property=" + propertyName + " for bean=" + bean.getClass().getName()));
            }
            value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            this.log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        return value;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getProperty() {
        return this.property;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getFullCollectionName() {
        if (this.beanName == null) {
            return this.collectionName;
        }
        return String.valueOf(this.beanName) + "." + this.collectionName;
    }

    public String getPropertyNameAfterLastDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.lastIndexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String getPropertyNameAfterFirstDot() {
        String propertyName = null;
        if (this.property != null) {
            int dotIndex = this.property.indexOf(".");
            propertyName = dotIndex >= 0 ? this.property.substring(dotIndex + 1) : this.property;
        }
        return propertyName;
    }

    public String toString() {
        return "Property{property='" + this.property + "'}";
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(Object propertyValue) {
        this.propertyValue = propertyValue;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }
}

