/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.jxls.Cell;
import org.jxls.MergedRegion;
import org.jxls.Property;
import org.jxls.RowCollection;

public class Row {
    private HSSFRow hssfRow;
    private HSSFSheet hssfSheet;
    private HSSFWorkbook hssfWorkbook;
    private List cells = new ArrayList();
    private List rowCollections = new ArrayList();
    private List mergedRegions = new ArrayList();
    private Row parentRow;

    public Row getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(Row parentRow) {
        this.parentRow = parentRow;
    }

    public Row(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet, HSSFRow hssfRow) {
        this.hssfWorkbook = hssfWorkbook;
        this.hssfSheet = hssfSheet;
        this.hssfRow = hssfRow;
    }

    public HSSFSheet getHssfSheet() {
        return this.hssfSheet;
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public RowCollection getMaxNumberOfRowsCollection() {
        if (this.rowCollections.size() == 0) {
            return null;
        }
        RowCollection maxNumberOfRowsCollection = (RowCollection)this.rowCollections.get(0);
        int i = 1;
        while (i < this.rowCollections.size()) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getNumberOfRows() > maxNumberOfRowsCollection.getNumberOfRows()) {
                maxNumberOfRowsCollection = rowCollection;
            }
            ++i;
        }
        return maxNumberOfRowsCollection;
    }

    public RowCollection getMaxSizeCollection() {
        if (this.rowCollections.size() == 0) {
            return null;
        }
        RowCollection maxSizeRowCollection = (RowCollection)this.rowCollections.get(0);
        int i = 1;
        while (i < this.rowCollections.size()) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getCollectionProperty().getCollection().size() > maxSizeRowCollection.getCollectionProperty().getCollection().size()) {
                maxSizeRowCollection = rowCollection;
            }
            ++i;
        }
        return maxSizeRowCollection;
    }

    public RowCollection getRowCollectionByCollectionName(String collectionName) {
        int i = 0;
        while (i < this.rowCollections.size()) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getCollectionProperty().getFullCollectionName().equals(collectionName)) {
                return rowCollection;
            }
            ++i;
        }
        return null;
    }

    public List getRowCollections() {
        return this.rowCollections;
    }

    private RowCollection getRowCollection(Property collectionProperty, int dependentRowNumber) {
        int i = 0;
        while (i < this.rowCollections.size()) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getCollectionProperty().getFullCollectionName().equals(collectionProperty.getFullCollectionName())) {
                return rowCollection;
            }
            ++i;
        }
        RowCollection rowCollection = new RowCollection(this, collectionProperty, dependentRowNumber);
        this.rowCollections.add(rowCollection);
        return rowCollection;
    }

    public void addRowCollection(RowCollection rowCollection) {
        this.rowCollections.add(rowCollection);
    }

    private void addMergedRegion(MergedRegion mergedRegion) {
        this.mergedRegions.add(mergedRegion);
    }

    public RowCollection addCell(Cell cell) {
        RowCollection rowCollection = null;
        this.cells.add(cell);
        if (cell.getCollectionProperty() != null) {
            rowCollection = this.getRowCollection(cell.getCollectionProperty(), cell.getDependentRowNumber());
            rowCollection.addCell(cell);
            if (cell.getMergedRegion() != null) {
                MergedRegion mergedRegion = new MergedRegion(cell.getMergedRegion(), rowCollection);
                this.addMergedRegion(mergedRegion);
            }
        } else if (cell.getMergedRegion() != null && cell.isEmpty() && (rowCollection = this.getRowCollection(cell.getMergedRegion())) != null) {
            rowCollection.addCell(cell);
        }
        return rowCollection;
    }

    private RowCollection getRowCollection(Region mergedRegion) {
        int i = 0;
        while (i < this.mergedRegions.size()) {
            MergedRegion region = (MergedRegion)this.mergedRegions.get(i);
            if (region.getRegion().equals(mergedRegion)) {
                return region.getRowCollection();
            }
            ++i;
        }
        return null;
    }

    public List getCells() {
        return this.cells;
    }

    public void setCells(List cells) {
        this.cells = cells;
    }

    public HSSFRow getHssfRow() {
        return this.hssfRow;
    }

    public void setHssfRow(HSSFRow hssfRow) {
        this.hssfRow = hssfRow;
    }

    public int getMinDependentRowNumber() {
        if (this.rowCollections.size() == 0) {
            return 0;
        }
        int minDependentRowNumber = ((RowCollection)this.rowCollections.get(0)).getDependentRowNumber();
        int i = 1;
        while (i < this.rowCollections.size()) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getDependentRowNumber() < minDependentRowNumber) {
                minDependentRowNumber = rowCollection.getDependentRowNumber();
            }
            ++i;
        }
        return minDependentRowNumber;
    }
}

