/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jxls.Cell;
import org.jxls.Property;
import org.jxls.Row;

public class RowCollection {
    private int dependentRowNumber = 0;
    private Property collectionProperty;
    private List cells = new ArrayList();
    private Row parentRow;
    private String collectionItemName;
    private int numberOfRows;
    private Iterator iterator;
    private int iterateStep;
    private int iterateIndex;
    private Object iterateObject;

    public RowCollection(Row parentRow, Property collectionProperty, int dependentRowNumber) {
        this.parentRow = parentRow;
        this.setCollectionProperty(collectionProperty, dependentRowNumber);
    }

    public RowCollection(Property property) {
        this.setCollectionProperty(property, 0);
    }

    public RowCollection(Property collectionProperty, int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
        this.setCollectionProperty(collectionProperty, dependentRowNumber);
    }

    public Row getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(Row parentRow) {
        this.parentRow = parentRow;
    }

    public void addCell(Cell cell) {
        this.cells.add(cell);
        cell.setRowCollection(this);
    }

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    private void setCollectionProperty(Property collectionProperty, int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
        this.collectionProperty = collectionProperty;
        this.numberOfRows = (collectionProperty.getCollection().size() - 1) * (dependentRowNumber + 1);
    }

    public List getCells() {
        return this.cells;
    }

    public int getDependentRowNumber() {
        return this.dependentRowNumber;
    }

    public void setDependentRowNumber(int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
    }

    public boolean containsCell(Cell cell) {
        return cell.getHssfCell() == null || cell.getRowCollection() != null && this.collectionProperty.getFullCollectionName().equals(cell.getRowCollection().getCollectionProperty().getFullCollectionName());
    }

    public String getCollectionItemName() {
        return this.collectionItemName;
    }

    public void setCollectionItemName(String collectionItemName) {
        this.collectionItemName = collectionItemName;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public Object getIterateObject() {
        return this.iterateObject;
    }

    public Object getNextObject() {
        if (this.iterateIndex % (this.dependentRowNumber + 1) == 0) {
            this.iterateObject = this.iterator.next();
        }
        this.iterateIndex += this.iterateStep + 1;
        return this.iterateObject;
    }

    public boolean hasNextObject() {
        return this.iterator.hasNext();
    }

    public void createIterator(int step) {
        if (step != this.dependentRowNumber) {
            throw new IllegalArgumentException("Not supported yet");
        }
        this.iterator = this.collectionProperty.getCollection().iterator();
        this.iterateStep = step;
        this.iterateIndex = 0;
    }

    public String toString() {
        return this.collectionProperty.getFullCollectionName();
    }
}

