/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.jxls.Cell;
import org.jxls.Row;
import org.jxls.RowCollection;

public final class Util {
    static void removeRowCollectionPropertiesFromRow(RowCollection rowCollection) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        int i = 0;
        while (i <= rowCollection.getDependentRowNumber()) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            short j = hssfRow.getFirstCellNum();
            while (j <= hssfRow.getLastCellNum()) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.removeRowCollectionPropertyFromCell(cell, rowCollection.getCollectionProperty().getCollectionName());
                j = (short)(j + 1);
            }
            ++i;
        }
    }

    private static void removeRowCollectionPropertyFromCell(HSSFCell cell, String collectionName) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getStringCellValue();
            cell.setCellValue(cellValue.replaceAll("${" + collectionName + "}", ""));
        }
    }

    private static void removeMergedRegion(HSSFSheet sheet, Region region) {
        int index = Util.getMergedRegionIndex(sheet, region);
        sheet.removeMergedRegion(index);
    }

    private static int getMergedRegionIndex(HSSFSheet sheet, Region mergedRegion) {
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            Region region = sheet.getMergedRegionAt(i);
            if (region.equals(mergedRegion)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isNewMergedRegion(Region region, Collection mergedRegions) {
        return !mergedRegions.contains(region);
    }

    static Region getMergedRegion(HSSFSheet sheet, int rowNum, short cellNum) {
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            Region merged = sheet.getMergedRegionAt(i);
            if (merged.contains(rowNum, cellNum)) {
                return merged;
            }
            ++i;
        }
        return null;
    }

    static void prepareCollectionPropertyInRowForDuplication(RowCollection rowCollection, String collectionItemName) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        int i = 0;
        while (i <= rowCollection.getDependentRowNumber()) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            short j = hssfRow.getFirstCellNum();
            while (j <= hssfRow.getLastCellNum()) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.prepareCollectionPropertyInCellForDuplication(cell, rowCollection.getCollectionProperty().getFullCollectionName(), collectionItemName);
                j = (short)(j + 1);
            }
            ++i;
        }
    }

    private static void prepareCollectionPropertyInCellForDuplication(HSSFCell cell, String collectionName, String collectionItemName) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getStringCellValue();
            String newValue = cellValue.replaceAll(collectionName, collectionItemName);
            cell.setCellValue(newValue);
        }
    }

    static void prepareCollectionPropertyInRowForContentDuplication(RowCollection rowCollection) {
        int i = 0;
        while (i < rowCollection.getCells().size()) {
            Cell cell = (Cell)rowCollection.getCells().get(i);
            Util.prepareCollectionPropertyInCellForDuplication(cell.getHssfCell(), rowCollection.getCollectionProperty().getFullCollectionName(), rowCollection.getCollectionItemName());
            ++i;
        }
    }

    static void duplicateRowCollectionProperty(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int rowNum = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFRow srcRow = rowCollection.getParentRow().getHssfRow();
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        if (collection.size() > 1) {
            int i = 1;
            while (i < collection.size()) {
                HSSFRow destRow = sheet.getRow(rowNum + i);
                int j = 0;
                while (j < rowCollection.getCells().size()) {
                    Cell cell = (Cell)rowCollection.getCells().get(j);
                    if (!cell.isEmpty()) {
                        HSSFCell destCell = destRow.getCell(cell.getHssfCell().getCellNum());
                        if (destCell == null) {
                            destCell = destRow.createCell(cell.getHssfCell().getCellNum());
                        }
                        Util.copyCell(srcRow.getCell(cell.getHssfCell().getCellNum()), destCell, false);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    static int duplicateRow(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int row = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        if (collection.size() > 1) {
            if (rowCollection.getDependentRowNumber() == 0) {
                sheet.shiftRows(row + 1, sheet.getLastRowNum(), collection.size() - 1, true, false);
                Util.duplicateStyle(rowCollection, row, row + 1, collection.size() - 1);
                Util.shiftUncoupledCellsUp(rowCollection);
            } else {
                int i = 0;
                while (i < collection.size() - 1) {
                    Util.shiftCopyRowCollection(rowCollection);
                    ++i;
                }
                Util.shiftUncoupledCellsUp(rowCollection);
            }
        }
        return (collection.size() - 1) * (rowCollection.getDependentRowNumber() + 1);
    }

    private static void shiftCopyRowCollection(RowCollection rowCollection) {
        HSSFSheet hssfSheet = rowCollection.getParentRow().getHssfSheet();
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber();
        hssfSheet.shiftRows(startRow + num + 1, hssfSheet.getLastRowNum(), num + 1, true, false);
        Util.copyRowCollection(rowCollection);
    }

    private static void copyRowCollection(RowCollection rowCollection) {
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        int from = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber() + 1;
        int to = from + num;
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        int i = from;
        while (i < from + num) {
            HSSFRow srcRow = sheet.getRow(i);
            HSSFRow destRow = sheet.getRow(to + i - from);
            if (destRow == null) {
                destRow = sheet.createRow(to + i - from);
            }
            destRow.setHeight(srcRow.getHeight());
            short j = srcRow.getFirstCellNum();
            while (j <= srcRow.getLastCellNum()) {
                HSSFCell srcCell = srcRow.getCell(j);
                if (srcCell != null) {
                    Region newMergedRegion;
                    HSSFCell destCell = destRow.createCell(j);
                    Util.copyCell(srcCell, destCell, true);
                    Region mergedRegion = Util.getMergedRegion(sheet, i, j);
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new Region(to - from + mergedRegion.getRowFrom(), mergedRegion.getColumnFrom(), to - from + mergedRegion.getRowTo(), mergedRegion.getColumnTo()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                    }
                }
                j = (short)(j + 1);
            }
            ++i;
        }
        for (Region region : mergedRegions) {
            sheet.addMergedRegion(region);
        }
    }

    private static void shiftUncoupledCellsUp(RowCollection rowCollection) {
        Row row = rowCollection.getParentRow();
        if (row.getCells().size() > rowCollection.getCells().size()) {
            int i = 0;
            while (i < row.getCells().size()) {
                Cell cell = (Cell)row.getCells().get(i);
                if (!rowCollection.containsCell(cell)) {
                    Util.shiftColumnUp(cell, row.getHssfRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size(), rowCollection.getCollectionProperty().getCollection().size() - 1);
                }
                ++i;
            }
        }
    }

    private static void shiftColumnUp(Cell cell, int startRow, int shiftNumber) {
        HSSFSheet sheet = cell.getRow().getHssfSheet();
        short cellNum = cell.getHssfCell().getCellNum();
        ArrayList<Region> hssfMergedRegions = new ArrayList<Region>();
        int i = startRow;
        while (i <= sheet.getLastRowNum()) {
            Region region = Util.getMergedRegion(sheet, i, cellNum);
            if (region != null && Util.isNewMergedRegion(region, hssfMergedRegions)) {
                hssfMergedRegions.add(region);
            }
            ++i;
        }
        i = startRow;
        while (i <= sheet.getLastRowNum()) {
            if (sheet.getRow(i).getCell(cellNum) != null) {
                HSSFCell destCell = sheet.getRow(i - shiftNumber).getCell(cellNum);
                if (destCell == null) {
                    destCell = sheet.getRow(i - shiftNumber).createCell(cellNum);
                }
                Util.moveCell(sheet.getRow(i).getCell(cellNum), destCell);
            }
            ++i;
        }
        Iterator iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            Util.removeMergedRegion(sheet, (Region)iterator.next());
        }
        for (Region region : hssfMergedRegions) {
            Region newRegion = new Region(region.getRowFrom() - shiftNumber, region.getColumnFrom(), region.getRowTo() - shiftNumber, region.getColumnTo());
            sheet.addMergedRegion(newRegion);
        }
        i = sheet.getLastRowNum();
        while (sheet.getRow(i).getCell(cellNum) == null && i >= startRow) {
            --i;
        }
        int j = 0;
        while (j < shiftNumber && i >= startRow) {
            sheet.getRow(i).removeCell(sheet.getRow(i).getCell(cellNum));
            ++j;
            --i;
        }
    }

    private static void moveCell(HSSFCell srcCell, HSSFCell destCell) {
        destCell.setCellStyle(srcCell.getCellStyle());
        switch (srcCell.getCellType()) {
            case 1: {
                destCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case 0: {
                destCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case 3: {
                destCell.setCellType(3);
                break;
            }
            case 4: {
                destCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case 5: {
                destCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
        srcCell.setCellType(3);
    }

    private static void duplicateStyle(RowCollection rowCollection, int rowToCopy, int startRow, int num) {
        HSSFSheet sheet = rowCollection.getParentRow().getHssfSheet();
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        HSSFRow srcRow = sheet.getRow(rowToCopy);
        int i = startRow;
        while (i < startRow + num) {
            HSSFRow destRow = sheet.getRow(i);
            if (destRow == null) {
                destRow = sheet.createRow(i);
            }
            destRow.setHeight(srcRow.getHeight());
            int j = 0;
            while (j < rowCollection.getCells().size()) {
                Cell cell = (Cell)rowCollection.getCells().get(j);
                HSSFCell hssfCell = cell.getHssfCell();
                if (hssfCell != null) {
                    Region newMergedRegion;
                    HSSFCell newCell = destRow.createCell(hssfCell.getCellNum());
                    Util.copyCell(hssfCell, newCell, true);
                    Region mergedRegion = Util.getMergedRegion(sheet, rowToCopy, hssfCell.getCellNum());
                    if (mergedRegion != null && Util.isNewMergedRegion(newMergedRegion = new Region(i, mergedRegion.getColumnFrom(), i + mergedRegion.getRowTo() - mergedRegion.getRowFrom(), mergedRegion.getColumnTo()), mergedRegions)) {
                        mergedRegions.add(newMergedRegion);
                        sheet.addMergedRegion(newMergedRegion);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void copyCell(HSSFCell oldCell, HSSFCell newCell, boolean copyStyle) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
    }

    static void writeToFile(String fileName, HSSFWorkbook workbook) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HSSFCellStyle duplicateStyle(HSSFWorkbook workbook, HSSFCellStyle style) {
        HSSFCellStyle newStyle = workbook.createCellStyle();
        newStyle.setAlignment(style.getAlignment());
        newStyle.setBorderBottom(style.getBorderBottom());
        newStyle.setBorderLeft(style.getBorderLeft());
        newStyle.setBorderRight(style.getBorderRight());
        newStyle.setBorderTop(style.getBorderTop());
        newStyle.setBottomBorderColor(style.getBottomBorderColor());
        newStyle.setDataFormat(style.getDataFormat());
        newStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        newStyle.setFillForegroundColor(style.getFillForegroundColor());
        newStyle.setFillPattern(style.getFillPattern());
        newStyle.setFont(workbook.getFontAt(style.getFontIndex()));
        newStyle.setHidden(style.getHidden());
        newStyle.setIndention(style.getIndention());
        newStyle.setLeftBorderColor(style.getLeftBorderColor());
        newStyle.setLocked(style.getLocked());
        newStyle.setRightBorderColor(style.getRightBorderColor());
        newStyle.setTopBorderColor(style.getTopBorderColor());
        newStyle.setVerticalAlignment(style.getVerticalAlignment());
        newStyle.setWrapText(style.getWrapText());
        return newStyle;
    }
}

