/*
 * Decompiled with CFR 0.152.
 */
package org.jxls;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jxls.Cell;
import org.jxls.CellParser;
import org.jxls.CellProcessor;
import org.jxls.Configuration;
import org.jxls.Formula;
import org.jxls.ListRange;
import org.jxls.ParsePropertyException;
import org.jxls.Property;
import org.jxls.PropertyPreprocessor;
import org.jxls.Row;
import org.jxls.RowCollection;
import org.jxls.RowProcessor;
import org.jxls.Util;

public class XLSTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List propertyPreprocessors = new ArrayList();
    private List rowProcessors = new ArrayList();
    private List cellProcessors = new ArrayList();
    private HSSFWorkbook sourceWorkbook;
    private short[] columnsToHide;
    private Set spreadsheetsToHide = new HashSet();
    private Map spreadsheetsToRename = new HashMap();
    private String[] columnPropertyNamesToHide;
    private List formulas = new ArrayList();
    private Map listRanges = new HashMap();
    private Map namedCells = new HashMap();
    private Set fixedSizeCollections = new HashSet();
    private Set groupedCollections = new HashSet();
    private Configuration configuration;
    private int index = 0;

    public void registerPropertyPreprocessor(PropertyPreprocessor propPreprocessor) {
        if (propPreprocessor != null) {
            this.propertyPreprocessors.add(propPreprocessor);
        }
    }

    public void registerRowProcessor(RowProcessor rowProcessor) {
        if (rowProcessor != null) {
            this.rowProcessors.add(rowProcessor);
        }
    }

    public void registerCellProcessor(CellProcessor cellProcessor) {
        if (cellProcessor != null) {
            this.cellProcessors.add(cellProcessor);
        }
    }

    public void markAsFixedSizeCollection(String collectionName) {
        this.fixedSizeCollections.add(collectionName);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public XLSTransformer() {
        this.configuration = new Configuration();
    }

    public XLSTransformer(Configuration configuration) {
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public void groupCollection(String collectionName) {
        this.groupedCollections.add(collectionName);
    }

    public void transformXLS(String srcFilePath, Map beanParams, String destFilePath) throws ParsePropertyException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(srcFilePath));
        HSSFWorkbook workbook = this.transformXLS(is, beanParams);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFilePath));
        workbook.write((OutputStream)os);
        ((InputStream)is).close();
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    public HSSFWorkbook transformXLS(InputStream is, Map beanParams) throws ParsePropertyException {
        HSSFWorkbook workbook = null;
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            this.sourceWorkbook = workbook = new HSSFWorkbook(fs);
            this.preprocess(workbook);
            int sheetNo = 0;
            while (sheetNo < workbook.getNumberOfSheets()) {
                String spreadsheetName = workbook.getSheetName(sheetNo);
                if (!this.isSpreadsheetToHide(spreadsheetName)) {
                    if (this.isSpreadsheetToRename(spreadsheetName)) {
                        workbook.setSheetName(sheetNo, this.getSpreadsheetToReName(spreadsheetName));
                    }
                    this.formulas.clear();
                    HSSFSheet sheet = workbook.getSheetAt(sheetNo);
                    int i = sheet.getFirstRowNum();
                    while (i <= sheet.getLastRowNum()) {
                        HSSFRow hssfRow = sheet.getRow(i);
                        if (hssfRow != null) {
                            Row row = this.processRow(sheet, hssfRow, beanParams);
                            this.applyRowProcessors(row);
                            int shiftNumber = this.processRowCollections(sheet, row, beanParams);
                            i += shiftNumber;
                        }
                        ++i;
                    }
                    this.updateFormulas(sheet, false);
                    this.groupRows(sheet);
                } else {
                    workbook.removeSheetAt(sheetNo);
                }
                ++sheetNo;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return workbook;
    }

    private void groupRows(HSSFSheet sheet) {
        for (String collectionName : this.groupedCollections) {
            if (!this.listRanges.containsKey(collectionName)) continue;
            ListRange listRange = (ListRange)this.listRanges.get(collectionName);
            sheet.groupRow(listRange.getFirstRowNum(), listRange.getLastRowNum());
        }
    }

    private void updateFormulas(HSSFSheet sheet, boolean ignoreUnresolved) {
        int i = 0;
        while (i < this.formulas.size()) {
            Formula formula = (Formula)this.formulas.get(i);
            String formulaString = formula.getAppliedFormula(this.listRanges, this.namedCells);
            HSSFRow hssfRow = sheet.getRow(formula.getRowNum().intValue());
            HSSFCell hssfCell = hssfRow.getCell(formula.getCellNum().shortValue());
            if (formulaString != null) {
                hssfCell.setCellFormula(formulaString);
            } else if (!ignoreUnresolved) {
                hssfCell.setCellValue("");
                this.formulas.remove(i--);
            }
            ++i;
        }
    }

    private int processRows(HSSFSheet sheet, int startRow, int endRow, Map beans, Row parentRow) throws ParsePropertyException {
        int mainShiftNumber = 0;
        int i = startRow;
        while (i <= endRow + mainShiftNumber) {
            HSSFRow hssfRow = sheet.getRow(i);
            Row row = this.processRow(sheet, hssfRow, beans);
            row.setParentRow(parentRow);
            this.applyRowProcessors(row);
            int shiftNumber = this.processRowCollections(sheet, row, beans);
            i += shiftNumber;
            mainShiftNumber += shiftNumber;
            ++i;
        }
        return mainShiftNumber;
    }

    private int processRowCollections(HSSFSheet sheet, Row row, Map beans) throws ParsePropertyException {
        int maxShiftNumber = 0;
        int rowNum = row.getHssfRow().getRowNum();
        HashSet<String> keys = new HashSet<String>(beans.keySet());
        int i = 0;
        while (i < row.getRowCollections().size()) {
            RowCollection rowCollection = (RowCollection)row.getRowCollections().get(i);
            if (!rowCollection.getCollectionProperty().getCollection().isEmpty()) {
                Property collectionProperty = rowCollection.getCollectionProperty();
                String collectionItem = this.generateCollectionItem(collectionProperty.getFullCollectionName(), keys);
                rowCollection.setCollectionItemName(collectionItem);
                keys.add(collectionItem);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("----collection-property--------->" + collectionProperty.getCollectionName()));
                }
                ListRange listRange = new ListRange(rowNum, rowNum + collectionProperty.getCollection().size() - 1, 0);
                listRange.setListName(collectionProperty.getCollectionName());
                listRange.setListAlias(rowCollection.getCollectionItemName());
                this.addListRange(sheet, rowCollection.getCollectionItemName(), listRange);
                this.addListRange(sheet, collectionProperty.getFullCollectionName(), listRange);
                if (!this.fixedSizeCollections.contains(collectionProperty.getCollectionName())) {
                    Util.prepareCollectionPropertyInRowForDuplication(rowCollection, rowCollection.getCollectionItemName());
                    Util.duplicateRow(rowCollection);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Fixed size collection found: " + collectionProperty.getCollectionName()));
                    }
                    if (rowCollection.getDependentRowNumber() != 0) {
                        this.log.warn((Object)"Dependent rows for fixed size collections are not supported.");
                    }
                    Util.prepareCollectionPropertyInRowForContentDuplication(rowCollection);
                    Util.duplicateRowCollectionProperty(rowCollection);
                }
            } else {
                Util.removeRowCollectionPropertiesFromRow(rowCollection);
            }
            ++i;
        }
        if (row.getRowCollections().size() > 0) {
            RowCollection maxSizeCollection = row.getMaxSizeCollection();
            int minDependentRowNumber = row.getMinDependentRowNumber();
            int mainShiftNumber = 0;
            int i2 = 0;
            while (i2 < row.getRowCollections().size()) {
                RowCollection rowCollection = (RowCollection)row.getRowCollections().get(i2);
                rowCollection.createIterator(minDependentRowNumber);
                ++i2;
            }
            int k = 0;
            while (k < maxSizeCollection.getCollectionProperty().getCollection().size()) {
                int i3 = 0;
                while (i3 < row.getRowCollections().size()) {
                    RowCollection rowCollection = (RowCollection)row.getRowCollections().get(i3);
                    if (rowCollection.hasNextObject()) {
                        Object o = rowCollection.getNextObject();
                        beans.put(rowCollection.getCollectionItemName(), o);
                    }
                    ++i3;
                }
                int shiftNumber = this.processRows(sheet, rowNum + (minDependentRowNumber + 1) * k, rowNum + (minDependentRowNumber + 1) * k + minDependentRowNumber, beans, row);
                mainShiftNumber += shiftNumber + 1;
                rowNum += shiftNumber;
                ++k;
            }
            i2 = 0;
            while (i2 < row.getRowCollections().size()) {
                RowCollection rowCollection = (RowCollection)row.getRowCollections().get(i2);
                beans.remove(rowCollection.getCollectionItemName());
                ++i2;
            }
            if (mainShiftNumber - 1 > maxShiftNumber) {
                maxShiftNumber = mainShiftNumber - 1;
            }
        }
        return maxShiftNumber;
    }

    private String generateCollectionItem(String collectionName, Set keys) {
        String key = String.valueOf(collectionName.replace('.', '_')) + this.index++;
        while (keys.contains(key)) {
            key = String.valueOf(key) + this.index++;
        }
        return key;
    }

    private Row processRow(HSSFSheet sheet, HSSFRow hssfRow, Map beans) {
        Row row = new Row(this.sourceWorkbook, sheet, hssfRow);
        short j = hssfRow.getFirstCellNum();
        while (j <= hssfRow.getLastCellNum()) {
            HSSFCell hssfCell = hssfRow.getCell(j);
            CellParser cellParser = new CellParser(hssfCell, row, this.configuration);
            Cell cell = cellParser.parseCell(beans);
            if (cell.getLabel() != null && cell.getLabel().length() > 0) {
                this.addNamedCell(cell.getLabel(), cell);
            }
            this.applyCellProcessors(cell);
            cellParser.updateCellContent();
            RowCollection rowCollection = row.addCell(cell);
            if (cell.getCollectionProperty() != null) {
                ListRange listRange = new ListRange(row.getHssfRow().getRowNum(), row.getHssfRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size() - 1, j);
                this.addListRange(sheet, cell.getCollectionProperty().getProperty(), listRange);
            }
            j = (short)(j + 1);
        }
        int i = 0;
        while (i < row.getCells().size()) {
            Cell cell = (Cell)row.getCells().get(i);
            if (cell.getRowCollection() == null && cell.getCollectionName() != null) {
                RowCollection rowCollection = row.getRowCollectionByCollectionName(cell.getCollectionName());
                if (rowCollection != null) {
                    rowCollection.addCell(cell);
                } else {
                    this.log.warn((Object)("RowCollection with name " + cell.getCollectionName() + " not found"));
                }
            } else if (cell.isEmpty() && cell.getRowCollection() == null && cell.getMergedRegion() == null && row.getRowCollections().size() == 1) {
                ((RowCollection)row.getRowCollections().get(0)).addCell(cell);
            }
            if (cell.isFormula()) {
                if (!cell.getFormula().isInline()) {
                    this.addFormula(cell.getFormula());
                }
                if (cell.getFormula().isInline() && cell.getLabel() != null && cell.getLabel().length() > 0) {
                    ListRange listRange = new ListRange(row.getHssfRow().getRowNum(), row.getHssfRow().getRowNum() + cell.getRowCollection().getCollectionProperty().getCollection().size() - 1, cell.getHssfCell().getCellNum());
                    this.addListRange(row.getHssfSheet(), cell.getLabel(), listRange);
                }
            }
            ++i;
        }
        return row;
    }

    private boolean formulaExists(Formula formula) {
        int i = 0;
        while (i < this.formulas.size()) {
            Formula cur = (Formula)this.formulas.get(i);
            if (cur.getFormula().equals(formula.getFormula())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void applyCellProcessors(Cell cell) {
        int i = 0;
        while (i < this.cellProcessors.size()) {
            CellProcessor cellProcessor = (CellProcessor)this.cellProcessors.get(i);
            cellProcessor.processCell(cell, this.namedCells);
            ++i;
        }
    }

    private void applyRowProcessors(Row row) {
        int i = 0;
        while (i < this.rowProcessors.size()) {
            RowProcessor rowProcessor = (RowProcessor)this.rowProcessors.get(i);
            rowProcessor.processRow(row, this.namedCells);
            ++i;
        }
    }

    private void preprocess(HSSFWorkbook workbook) {
        this.hideColumns(workbook);
        this.hideColumnsByPropertyName(workbook);
        int sheet_no = 0;
        while (sheet_no < workbook.getNumberOfSheets()) {
            HSSFSheet sheet = workbook.getSheetAt(sheet_no);
            int i = sheet.getFirstRowNum();
            while (i <= sheet.getLastRowNum()) {
                HSSFRow hssfRow = sheet.getRow(i);
                if (hssfRow != null) {
                    short j = hssfRow.getFirstCellNum();
                    while (j <= hssfRow.getLastCellNum()) {
                        HSSFCell cell = hssfRow.getCell(j);
                        if (cell != null && cell.getCellType() == 1) {
                            String value = cell.getStringCellValue();
                            int k = 0;
                            while (k < this.propertyPreprocessors.size()) {
                                PropertyPreprocessor propertyPreprocessor = (PropertyPreprocessor)this.propertyPreprocessors.get(k);
                                String newValue = propertyPreprocessor.processProperty(value);
                                if (newValue != null) {
                                    cell.setCellValue(newValue);
                                }
                                ++k;
                            }
                        }
                        j = (short)(j + 1);
                    }
                }
                ++i;
            }
            ++sheet_no;
        }
    }

    private void hideColumns(HSSFWorkbook workbook) {
        if (this.columnsToHide != null) {
            int i = 0;
            while (i < this.columnsToHide.length) {
                short column = this.columnsToHide[i];
                int sheet_no = 0;
                while (sheet_no < workbook.getNumberOfSheets()) {
                    HSSFSheet sheet = workbook.getSheetAt(sheet_no);
                    sheet.setColumnWidth(column, (short)0);
                    ++sheet_no;
                }
                ++i;
            }
        }
    }

    private void hideColumnsByPropertyName(HSSFWorkbook workbook) {
        if (this.columnPropertyNamesToHide == null) {
            return;
        }
        int sheet_no = 0;
        while (sheet_no < workbook.getNumberOfSheets()) {
            HSSFSheet sheet = workbook.getSheetAt(sheet_no);
            int i = sheet.getFirstRowNum();
            while (i <= sheet.getLastRowNum()) {
                HSSFRow hssfRow = sheet.getRow(i);
                if (hssfRow != null) {
                    short j = hssfRow.getFirstCellNum();
                    while (j <= hssfRow.getLastCellNum()) {
                        HSSFCell cell = hssfRow.getCell(j);
                        if (cell != null && cell.getCellType() == 1) {
                            String value = cell.getStringCellValue();
                            int prptIndx = 0;
                            while (prptIndx < this.columnPropertyNamesToHide.length) {
                                if (value != null && value.indexOf(this.columnPropertyNamesToHide[prptIndx]) != -1) {
                                    sheet.setColumnWidth(j, (short)0);
                                    break;
                                }
                                ++prptIndx;
                            }
                        }
                        j = (short)(j + 1);
                    }
                }
                ++i;
            }
            ++sheet_no;
        }
    }

    public short[] getColumnsToHide() {
        return this.columnsToHide;
    }

    public void setColumnsToHide(short[] columnsToHide) {
        this.columnsToHide = columnsToHide;
    }

    public String[] getColumnPropertyNamesToHide() {
        return this.columnPropertyNamesToHide;
    }

    public void setColumnPropertyNamesToHide(String[] columnPropertyNamesToHide) {
        this.columnPropertyNamesToHide = columnPropertyNamesToHide;
    }

    public void setSpreadsheetsToHide(String[] names) {
        this.spreadsheetsToHide.clear();
        int i = 0;
        while (i < names.length) {
            this.spreadsheetsToHide.add(names[i]);
            ++i;
        }
    }

    public void setSpreadsheetToRename(String name, String newName) {
        this.spreadsheetsToRename.put(name, newName);
    }

    protected boolean isSpreadsheetToHide(String name) {
        return this.spreadsheetsToHide.contains(name);
    }

    protected boolean isSpreadsheetToRename(String name) {
        return this.spreadsheetsToRename.containsKey(name);
    }

    protected String getSpreadsheetToReName(String name) {
        String newName = (String)this.spreadsheetsToRename.get(name);
        if (newName != null) {
            return newName;
        }
        return name;
    }

    private boolean addListRange(HSSFSheet sheet, String rangeName, ListRange range) {
        if (this.listRanges.containsKey(rangeName)) {
            this.updateFormulas(sheet, true);
            this.listRanges.put(rangeName, range);
            return true;
        }
        this.listRanges.put(rangeName, range);
        return false;
    }

    private void addNamedCell(String label, Cell cell) {
        this.namedCells.put(label, cell);
    }

    private void addFormula(Formula formula) {
        if (this.formulaExists(formula) && this.log.isInfoEnabled()) {
            this.log.info((Object)("Formula " + formula + " exists"));
        }
        this.formulas.add(formula);
    }
}

