/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConverter
extends DefaultTypeConverter {
    @Override
    public Object convertValue(Map<String, Object> context, Object target, Member member, String propertyName, Object value, Class toType) {
        Object[] objArray;
        if (value instanceof String) {
            if (toType == BigDecimal.class) {
                return new BigDecimal((String)value);
            }
            if (toType == BigInteger.class) {
                return new BigInteger((String)value);
            }
            if (toType.isPrimitive()) {
                String stringValue;
                Object convertedValue = super.convertValue(context, value, toType);
                if (!this.isInRange((Number)convertedValue, stringValue = (String)value, toType)) {
                    throw new XWorkException("Overflow or underflow casting: \"" + stringValue + "\" into class " + convertedValue.getClass().getName());
                }
                return convertedValue;
            }
            String stringValue = (String)value;
            if (!(toType.isPrimitive() || stringValue != null && stringValue.length() != 0)) {
                return null;
            }
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            ParsePosition parsePos = new ParsePosition(0);
            if (this.isIntegerType(toType)) {
                numFormat.setParseIntegerOnly(true);
            }
            numFormat.setGroupingUsed(true);
            Number number = numFormat.parse(stringValue, parsePos);
            if (parsePos.getIndex() != stringValue.length()) {
                throw new XWorkException("Unparseable number: \"" + stringValue + "\" at position " + parsePos.getIndex());
            }
            if (!this.isInRange(number, stringValue, toType)) {
                throw new XWorkException("Overflow or underflow casting: \"" + stringValue + "\" into class " + number.getClass().getName());
            }
            value = super.convertValue(context, number, toType);
        } else if (value instanceof Object[] && (objArray = (Object[])value).length == 1) {
            return this.convertValue(context, null, null, null, objArray[0], toType);
        }
        return super.convertValue(context, value, toType);
    }

    protected boolean isInRange(Number value, String stringValue, Class toType) {
        Number upperBound;
        Number lowerBound;
        Number bigValue;
        block9: {
            bigValue = null;
            lowerBound = null;
            upperBound = null;
            try {
                if (Double.TYPE == toType || Double.class == toType) {
                    bigValue = new BigDecimal(stringValue);
                    lowerBound = BigDecimal.valueOf(Double.MAX_VALUE).negate();
                    upperBound = BigDecimal.valueOf(Double.MAX_VALUE);
                    break block9;
                }
                if (Float.TYPE == toType || Float.class == toType) {
                    bigValue = new BigDecimal(stringValue);
                    lowerBound = BigDecimal.valueOf(3.4028234663852886E38).negate();
                    upperBound = BigDecimal.valueOf(3.4028234663852886E38);
                    break block9;
                }
                if (Byte.TYPE == toType || Byte.class == toType) {
                    bigValue = new BigInteger(stringValue);
                    lowerBound = BigInteger.valueOf(-128L);
                    upperBound = BigInteger.valueOf(127L);
                    break block9;
                }
                if (Character.TYPE == toType || Character.class == toType) {
                    bigValue = new BigInteger(stringValue);
                    lowerBound = BigInteger.valueOf(0L);
                    upperBound = BigInteger.valueOf(65535L);
                    break block9;
                }
                if (Short.TYPE == toType || Short.class == toType) {
                    bigValue = new BigInteger(stringValue);
                    lowerBound = BigInteger.valueOf(-32768L);
                    upperBound = BigInteger.valueOf(32767L);
                    break block9;
                }
                if (Integer.TYPE == toType || Integer.class == toType) {
                    bigValue = new BigInteger(stringValue);
                    lowerBound = BigInteger.valueOf(Integer.MIN_VALUE);
                    upperBound = BigInteger.valueOf(Integer.MAX_VALUE);
                    break block9;
                }
                if (Long.TYPE == toType || Long.class == toType) {
                    bigValue = new BigInteger(stringValue);
                    lowerBound = BigInteger.valueOf(Long.MIN_VALUE);
                    upperBound = BigInteger.valueOf(Long.MAX_VALUE);
                    break block9;
                }
                throw new IllegalArgumentException("Unexpected numeric type: " + toType.getName());
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return ((Comparable)((Object)bigValue)).compareTo(lowerBound) >= 0 && ((Comparable)((Object)bigValue)).compareTo(upperBound) <= 0;
    }

    private boolean isIntegerType(Class type) {
        return Double.TYPE != type && Float.TYPE != type && Double.class != type && Float.class != type && Character.TYPE != type && Character.class != type;
    }
}

