/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlNullHandlerWrapper;
import com.opensymphony.xwork2.ognl.OgnlValueStack;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.util.Map;
import java.util.Set;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;

public class OgnlValueStackFactory
implements ValueStackFactory {
    private XWorkConverter xworkConverter;
    private CompoundRootAccessor compoundRootAccessor;
    private TextProvider textProvider;
    private Container container;
    private boolean allowStaticMethodAccess;

    @Inject
    public void setXWorkConverter(XWorkConverter conv) {
        this.xworkConverter = conv;
    }

    @Inject(value="system")
    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Inject(value="allowStaticMethodAccess", required=false)
    public void setAllowStaticMethodAccess(String allowStaticMethodAccess) {
        this.allowStaticMethodAccess = "true".equalsIgnoreCase(allowStaticMethodAccess);
    }

    public ValueStack createValueStack() {
        OgnlValueStack stack = new OgnlValueStack(this.xworkConverter, this.compoundRootAccessor, this.textProvider, this.allowStaticMethodAccess);
        this.container.inject(stack);
        stack.getContext().put("com.opensymphony.xwork2.ActionContext.container", this.container);
        return stack;
    }

    public ValueStack createValueStack(ValueStack stack) {
        OgnlValueStack result = new OgnlValueStack(stack, this.xworkConverter, this.compoundRootAccessor, this.allowStaticMethodAccess);
        this.container.inject(result);
        stack.getContext().put("com.opensymphony.xwork2.ActionContext.container", this.container);
        return result;
    }

    @Inject
    public void setContainer(Container container) throws ClassNotFoundException {
        Class<?> cls;
        Set<String> names = container.getInstanceNames(PropertyAccessor.class);
        for (String name : names) {
            cls = Class.forName(name);
            if (cls == null) continue;
            if (Map.class.isAssignableFrom(cls)) {
                PropertyAccessor acc = container.getInstance(PropertyAccessor.class, name);
            }
            OgnlRuntime.setPropertyAccessor(cls, (PropertyAccessor)container.getInstance(PropertyAccessor.class, name));
            if (this.compoundRootAccessor != null || !CompoundRoot.class.isAssignableFrom(cls)) continue;
            this.compoundRootAccessor = (CompoundRootAccessor)container.getInstance(PropertyAccessor.class, name);
        }
        names = container.getInstanceNames(MethodAccessor.class);
        for (String name : names) {
            cls = Class.forName(name);
            if (cls == null) continue;
            OgnlRuntime.setMethodAccessor(cls, (MethodAccessor)container.getInstance(MethodAccessor.class, name));
        }
        names = container.getInstanceNames(com.opensymphony.xwork2.conversion.NullHandler.class);
        for (String name : names) {
            cls = Class.forName(name);
            if (cls == null) continue;
            OgnlRuntime.setNullHandler(cls, (NullHandler)new OgnlNullHandlerWrapper(container.getInstance(com.opensymphony.xwork2.conversion.NullHandler.class, name)));
        }
        if (this.compoundRootAccessor == null) {
            throw new IllegalStateException("Couldn't find the compound root accessor");
        }
        this.container = container;
    }
}

