/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.TxMasterStyleAtom;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;

public final class HSLFSlideMaster
extends HSLFMasterSheet {
    private final List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();
    private TxMasterStyleAtom[] _txmaster;

    public HSLFSlideMaster(MainMaster record, int sheetNo) {
        super(record, sheetNo);
        for (List<HSLFTextParagraph> l : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(l)) continue;
            this._paragraphs.add(l);
        }
        for (List<HSLFTextParagraph> p : this._paragraphs) {
            for (HSLFTextParagraph htp : p) {
                htp.supplySheet(this);
            }
        }
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        return null;
    }

    @Override
    public TextProp getStyleAttribute(int txtype, int level, String name, boolean isCharacter) {
        if (this._txmaster.length <= txtype) {
            return null;
        }
        TxMasterStyleAtom t = this._txmaster[txtype];
        List<TextPropCollection> styles = isCharacter ? t.getCharacterStyles() : t.getParagraphStyles();
        TextProp prop = null;
        for (int i = Math.min(level, styles.size() - 1); prop == null && i >= 0; --i) {
            prop = styles.get(i).findByName(name);
        }
        if (prop != null) {
            return prop;
        }
        switch (txtype) {
            case 5: 
            case 7: 
            case 8: {
                txtype = 1;
                break;
            }
            case 6: {
                txtype = 0;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getStyleAttribute(txtype, level, name, isCharacter);
    }

    @Override
    public void setSlideShow(HSLFSlideShow ss) {
        super.setSlideShow(ss);
        if (this._txmaster == null) {
            TxMasterStyleAtom txdoc;
            this._txmaster = new TxMasterStyleAtom[9];
            this._txmaster[txdoc.getTextType()] = txdoc = this.getSlideShow().getDocumentRecord().getEnvironment().getTxMasterStyleAtom();
            TxMasterStyleAtom[] txrec = ((MainMaster)this.getSheetContainer()).getTxMasterStyleAtoms();
            for (int i = 0; i < txrec.length; ++i) {
                int txType = txrec[i].getTextType();
                if (this._txmaster[txType] != null) continue;
                this._txmaster[txType] = txrec[i];
            }
        }
    }

    @Override
    protected void onAddTextShape(HSLFTextShape shape) {
        List<HSLFTextParagraph> runs = shape.getTextParagraphs();
        this._paragraphs.add(runs);
    }

    public TxMasterStyleAtom[] getTxMasterStyleAtoms() {
        return this._txmaster;
    }
}

