/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.spring;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.ClientBehaviorPolicyType;
import org.apache.cxf.transport.jms.ClientConfig;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSConduitBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String JMS_NS = "http://cxf.apache.org/transports/jms";

    @Override
    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        bean.setAbstract(true);
        this.mapElementToJaxbProperty(element, bean, new QName(JMS_NS, "clientConfig"), "clientConfig", ClientConfig.class);
        this.mapElementToJaxbProperty(element, bean, new QName(JMS_NS, "runtimePolicy"), "runtimePolicy", ClientBehaviorPolicyType.class);
        this.mapElementToJaxbProperty(element, bean, new QName(JMS_NS, "address"), "address", AddressType.class);
        this.mapElementToJaxbProperty(element, bean, new QName(JMS_NS, "sessionPool"), "sessionPool", SessionPoolType.class);
        List<Element> elemList = DOMUtils.findAllElementsByTagNameNS(element, JMS_NS, "jmsConfig-ref");
        if (elemList.size() == 1) {
            Node el1 = elemList.get(0);
            bean.addPropertyReference("jmsConfig", el1.getTextContent());
        }
    }

    @Override
    protected Class<?> getBeanClass(Element arg0) {
        return JMSConduit.class;
    }
}

