/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.internal.OracleConnection;

public class OracleLocalTransaction
implements LocalTransaction {
    private OracleManagedConnection m_omc = null;
    private Connection m_conn = null;
    private boolean m_isBeginCalled = false;
    private static final String RAERR_LTXN_COMMIT = "commit without begin";
    private static final String RAERR_LTXN_ROLLBACK = "rollback without begin";

    OracleLocalTransaction(OracleManagedConnection oracleManagedConnection) throws ResourceException {
        this.m_omc = oracleManagedConnection;
        this.m_conn = oracleManagedConnection.getPhysicalConnection();
        this.m_isBeginCalled = false;
    }

    public void begin() throws ResourceException {
        try {
            if (((OracleConnection)this.m_conn).getTxnMode() != 0) {
                IllegalStateException illegalStateException = new IllegalStateException("Could not start a new transaction inside an active transaction");
                throw illegalStateException;
            }
            if (this.m_conn.getAutoCommit()) {
                this.m_conn.setAutoCommit(false);
            }
            this.m_isBeginCalled = true;
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
        this.m_omc.eventOccurred(2);
    }

    public void commit() throws ResourceException {
        if (!this.m_isBeginCalled) {
            throw new LocalTransactionException("begin() must be called before commit()", RAERR_LTXN_COMMIT);
        }
        try {
            this.m_conn.commit();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
        this.m_omc.eventOccurred(3);
    }

    public void rollback() throws ResourceException {
        if (!this.m_isBeginCalled) {
            throw new LocalTransactionException("begin() must be called before rollback()", RAERR_LTXN_ROLLBACK);
        }
        try {
            this.m_conn.rollback();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
        this.m_omc.eventOccurred(4);
    }
}

