/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static final int max_length = 11;
    static int INV_ZONEID = -1;

    TimestampltzAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 231, 231, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    TimestampltzAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 231, 231, s, false);
        this.initForDescribe(231, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 11;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = this.t_max_length;
    }

    String getString(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        Calendar calendar = this.stmt.connection.getDbTzCalendar();
        String string = this.stmt.connection.getSessionTimeZone();
        if (string == null) {
            throw new SQLException("Session Time Zone not set!");
        }
        TimeZone timeZone = this.defaultTZ;
        timeZone.setID(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n2 = this.columnIndex + this.byteLength * n;
        short s = this.rowSpaceIndicator[this.lengthIndex + n];
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        this.TimeZoneAdjust(calendar, calendar2);
        n3 = calendar2.get(1);
        int n4 = calendar2.get(2) + 1;
        int n5 = calendar2.get(5);
        int n6 = calendar2.get(11);
        int n7 = calendar2.get(12);
        int n8 = calendar2.get(13);
        int n9 = 0;
        if (s == 11) {
            n9 = this.oracleNanos(n2);
        }
        return n3 + "-" + n4 + "-" + n5 + " " + n6 + "." + n7 + "." + n8 + "." + n9;
    }

    Date getDate(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        Calendar calendar = this.stmt.connection.getDbTzCalendar();
        String string = this.stmt.connection.getSessionTimeZone();
        if (string == null) {
            throw new SQLException("Session Time Zone not set!");
        }
        TimeZone timeZone = this.defaultTZ;
        timeZone.setID(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n2 = this.columnIndex + this.byteLength * n;
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        this.TimeZoneAdjust(calendar, calendar2);
        long l = calendar2.getTime().getTime();
        return new Date(l);
    }

    Time getTime(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        Calendar calendar = this.stmt.connection.getDbTzCalendar();
        String string = this.stmt.connection.getSessionTimeZone();
        if (string == null) {
            throw new SQLException("Session Time Zone not set!");
        }
        TimeZone timeZone = this.defaultTZ;
        timeZone.setID(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n2 = this.columnIndex + this.byteLength * n;
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        this.TimeZoneAdjust(calendar, calendar2);
        long l = calendar2.getTime().getTime();
        return new Time(l);
    }

    Timestamp getTimestamp(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        Calendar calendar = this.stmt.connection.getDbTzCalendar();
        String string = this.stmt.connection.getSessionTimeZone();
        if (string == null) {
            throw new SQLException("Session Time Zone not set!");
        }
        TimeZone timeZone = this.defaultTZ;
        timeZone.setID(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        int n2 = this.columnIndex + this.byteLength * n;
        short s = this.rowSpaceIndicator[this.lengthIndex + n];
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        this.TimeZoneAdjust(calendar, calendar2);
        long l = calendar2.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        if (s == 11) {
            timestamp.setNanos(this.oracleNanos(n2));
        }
        return timestamp;
    }

    Object getObject(int n) throws SQLException {
        return this.getTIMESTAMPLTZ(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getTIMESTAMPLTZ(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getTIMESTAMPLTZ(n);
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            tIMESTAMPLTZ = new TIMESTAMPLTZ(byArray);
        }
        return tIMESTAMPLTZ;
    }

    void TimeZoneAdjust(Calendar calendar, Calendar calendar2) throws SQLException {
        int n;
        int n2;
        int n3;
        String string = calendar.getTimeZone().getID();
        String string2 = calendar2.getTimeZone().getID();
        if (!string2.equals(string)) {
            int n4;
            OffsetDST offsetDST = new OffsetDST();
            n3 = this.getZoneOffset(calendar, offsetDST);
            n2 = offsetDST.getOFFSET();
            calendar.add(11, -(n2 / 3600000));
            calendar.add(12, -(n2 % 3600000) / 60000);
            if (string2.equals("Custom") || string2.startsWith("GMT") && string2.length() > 3) {
                n4 = calendar2.getTimeZone().getRawOffset();
            } else {
                n = ZONEIDMAP.getID(string2);
                if (n == INV_ZONEID) {
                    throw new SQLException("Timezone not supported");
                }
                if (TIMEZONETAB.checkID(n)) {
                    TIMEZONETAB.updateTable(this.stmt.connection, n);
                }
                n4 = TIMEZONETAB.getOffset(calendar, n);
            }
            calendar.add(11, n4 / 3600000);
            calendar.add(12, n4 % 3600000 / 60000);
        }
        if (string2.equals("Custom") && string.equals("Custom") || string2.startsWith("GMT") && string2.length() > 3 && string.startsWith("GMT") && string.length() > 3) {
            int n5 = calendar.getTimeZone().getRawOffset();
            n3 = calendar2.getTimeZone().getRawOffset();
            n2 = 0;
            if (n5 != n3) {
                n2 = n5 - n3;
                int n6 = n2 = n2 > 0 ? n2 : -n2;
            }
            if (n5 > n3) {
                n2 = -n2;
            }
            calendar.add(11, n2 / 3600000);
            calendar.add(12, n2 % 3600000 / 60000);
        }
        int n7 = calendar.get(1);
        n3 = calendar.get(2);
        n2 = calendar.get(5);
        n = calendar.get(11);
        int n8 = calendar.get(12);
        int n9 = calendar.get(13);
        int n10 = calendar.get(14);
        calendar2.set(1, n7);
        calendar2.set(2, n3);
        calendar2.set(5, n2);
        calendar2.set(11, n);
        calendar2.set(12, n8);
        calendar2.set(13, n9);
        calendar2.set(14, n10);
    }

    byte getZoneOffset(Calendar calendar, OffsetDST offsetDST) throws SQLException {
        byte by = 0;
        String string = calendar.getTimeZone().getID();
        if (string == "Custom" || string.startsWith("GMT") && string.length() > 3) {
            offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
        } else {
            int n = ZONEIDMAP.getID(string);
            if (n == INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n)) {
                TIMEZONETAB.updateTable(this.stmt.connection, n);
            }
            by = TIMEZONETAB.getLocalOffset(calendar, n, offsetDST);
        }
        return by;
    }
}

