/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.AbstractDBAccess;
import org.snaker.engine.access.hibernate.HibernateHelper;
import org.snaker.engine.entity.CCOrder;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.HistoryTaskActor;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Surrogate;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.TaskActor;
import org.snaker.engine.helper.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateAccess
extends AbstractDBAccess
implements DBAccess {
    private static final Logger log = LoggerFactory.getLogger(HibernateAccess.class);
    protected SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void initialize(Object accessObject) {
        if (accessObject == null) {
            return;
        }
        if (accessObject instanceof SessionFactory) {
            this.sessionFactory = (SessionFactory)accessObject;
        }
    }

    public Session getSession() {
        return HibernateHelper.getSession(this.sessionFactory);
    }

    protected Connection getConnection() throws SQLException {
        return null;
    }

    public void updateProcess(Process process) {
        try {
            if (process.getBytes() != null) {
                Blob blob = this.createBlob(process.getBytes());
                process.setContent(blob);
            }
        }
        catch (Exception e) {
            throw new SnakerException(e.getMessage(), e.getCause());
        }
        this.getSession().saveOrUpdate((Object)process);
    }

    public void saveProcess(Process process) {
        try {
            if (process.getBytes() != null) {
                Blob blob = this.createBlob(process.getBytes());
                process.setContent(blob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnakerException(e.getMessage(), e.getCause());
        }
        this.getSession().saveOrUpdate((Object)process);
    }

    public void deleteProcess(Process process) {
        this.getSession().delete((Object)process);
    }

    public void deleteTask(Task task) {
        List actors = this.getTaskActorsByTaskId(task.getId());
        for (TaskActor actor : actors) {
            this.getSession().delete((Object)actor);
        }
        this.getSession().delete((Object)task);
    }

    public void deleteOrder(Order order) {
        this.getSession().delete((Object)order);
    }

    public void deleteHistoryOrder(HistoryOrder historyOrder) {
        this.getSession().delete((Object)historyOrder);
    }

    public void deleteHistoryTask(HistoryTask historyTask) {
        List actors = this.getHistTaskActorsByTaskId(historyTask.getId());
        for (HistoryTaskActor actor : actors) {
            this.getSession().delete((Object)actor);
        }
        this.getSession().delete((Object)historyTask);
    }

    public void deleteSurrogate(Surrogate surrogate) {
        this.getSession().delete((Object)surrogate);
    }

    public void deleteCCOrder(CCOrder ccorder) {
        this.getSession().delete((Object)ccorder);
    }

    public void removeTaskActor(String taskId, String ... actors) {
        String[] stringArray = actors;
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            String actorId = stringArray[n2];
            TaskActor ta = new TaskActor();
            ta.setTaskId(taskId);
            ta.setActorId(actorId);
            this.getSession().delete((Object)ta);
            ++n2;
        }
    }

    public boolean isORM() {
        return true;
    }

    public void saveOrUpdate(Map<String, Object> map) {
        this.getSession().saveOrUpdate(map.get("ENTITY"));
    }

    public Integer getLatestProcessVersion(String name, Long comId) {
        SQLQuery query = this.getSession().createSQLQuery("select max(version) from wf_process  where name = ? and com_id=?");
        query.setParameter(0, (Object)name);
        query.setParameter(1, (Object)comId);
        Object result = query.uniqueResult();
        return new Long(ClassHelper.castLong((Object)result)).intValue();
    }

    public <T> T queryObject(Class<T> T, String sql, Object ... args) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(T);
        int i = 0;
        while (i < args.length) {
            query.setParameter(i, args[i]);
            ++i;
        }
        return (T)query.uniqueResult();
    }

    public <T> List<T> queryList(Class<T> clazz, String sql, Object ... args) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(clazz);
        int i = 0;
        while (i < args.length) {
            query.setParameter(i, args[i]);
            ++i;
        }
        return query.list();
    }

    public Object queryCount(String sql, Object ... args) {
        SQLQuery countQuery = this.getSession().createSQLQuery(sql);
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                countQuery.setParameter(i, args[i]);
                ++i;
            }
        }
        return countQuery.uniqueResult();
    }

    public abstract Blob createBlob(byte[] var1);
}

