/*
 * Decompiled with CFR 0.152.
 */
package jespa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jcifs.util.Base64;
import jespa.util.LogStream;

public final class License {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    private static final byte[] ZEROS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static LogStream log = null;
    public String serialNumber = null;
    public int userLimit = 0;
    public int groupLimit = 0;
    public long expiration = 0L;
    public String description = null;

    public License(InputStream in) throws Exception {
        log = LogStream.getInstance();
        this.load(in);
    }

    private final byte[] decrypt(byte[] src) throws Exception {
        byte[] _key = new byte[]{-80, -24, -123, -3, -15, -120, 66, 90, 9, 41, 110, 5, -46, 60, -99, -1};
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        _key[0] = (byte)(_key[0] | 4);
        IvParameterSpec iv = new IvParameterSpec(ZEROS);
        _key[8] = (byte)(_key[8] | 0x90);
        c.init(2, (Key)new SecretKeySpec(_key, "AES"), iv);
        return c.doFinal(src, 0, src.length);
    }

    private final byte[] readFully(InputStream in, int maxSize) throws Exception {
        byte[] buf = new byte[maxSize];
        int bi = 0;
        while (true) {
            if (bi == buf.length) {
                throw new Exception("Invalid license.key size");
            }
            int n = in.read(buf, bi, buf.length - bi);
            if (n == -1) break;
            bi += n;
        }
        byte[] ret = new byte[bi];
        System.arraycopy(buf, 0, ret, 0, bi);
        return ret;
    }

    private final String getCodeSource() {
        String ret = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        if (ret.startsWith("file:")) {
            ret = ret.substring(5);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(InputStream in) throws Exception {
        int bi;
        byte[] buf;
        try {
            block50: {
                ZipEntry ze;
                if (in == null) {
                    int retry = 0;
                    while (true) {
                        Class<?> klass;
                        if (retry == 0) {
                            klass = this.getClass();
                        } else if (retry == 1) {
                            klass = Thread.currentThread().getClass();
                        } else {
                            throw new Exception("Failed to retrieve jespa/license.key resource");
                        }
                        if (klass == null) {
                            if (LogStream.level >= 3) {
                                log.println(retry + ": Failed to determine Class");
                            }
                        } else {
                            ClassLoader cl = klass.getClassLoader();
                            if (cl == null) {
                                cl = ClassLoader.getSystemClassLoader();
                                if (LogStream.level >= 3) {
                                    log.println(retry + ": Failed to determine ClassLoader, trying System ClassLoader ...");
                                }
                            }
                            if (cl == null) {
                                if (LogStream.level >= 3) {
                                    log.println(retry + ": Failed to determine ClassLoader");
                                }
                            } else {
                                URL url = cl.getResource("jespa/license.key");
                                if (url == null) {
                                    if (LogStream.level >= 3) {
                                        log.println(retry + ": Failed to get Resource: jespa/license.key");
                                    }
                                } else {
                                    in = url.openStream();
                                    if (in != null) {
                                        if (LogStream.level >= 3) {
                                            log.println(retry + ": Successfully opened Resource stream: jespa/license.key");
                                        }
                                        break block50;
                                    }
                                    if (LogStream.level >= 3) {
                                        log.println(retry + ": Failed to open Resource stream");
                                    }
                                }
                            }
                        }
                        ++retry;
                    }
                }
                if (LogStream.level >= 3) {
                    log.println("Loading JAR from stream");
                }
                ZipInputStream zi = new ZipInputStream(in);
                do {
                    if ((ze = zi.getNextEntry()) != null) continue;
                    throw new Exception("Failed to read jespa/license.key from JAR stream");
                } while (!"jespa/license.key".equals(ze.getName()));
                if (LogStream.level >= 3) {
                    log.println(ze);
                }
                in = zi;
            }
            buf = this.readFully(in, 1024);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        int ee = 0;
        int es = 0;
        int fi = 0;
        for (bi = 0; bi < buf.length; ++bi) {
            if (fi < 10 && buf[bi] == 124) {
                ++fi;
                es = bi + 1;
                continue;
            }
            if (buf[bi] != 10 && buf[bi] != 13) continue;
            ee = bi;
            break;
        }
        if (LogStream.level >= 2) {
            log.println("Jespa license.key: " + new String(buf, 0, es));
            String codesource = this.getCodeSource();
            log.println("Jespa code-source: " + codesource);
        }
        if (fi != 10 || ee <= es) {
            throw new Exception("Invalid license.key");
        }
        String b64 = new String(buf, es, ee - es);
        byte[] tmp = Base64.decode((String)b64);
        tmp = this.decrypt(tmp);
        for (bi = 0; bi < es; ++bi) {
            if (buf[bi] == tmp[bi]) continue;
            throw new Exception("Failed to decrypt jespa/license.key");
        }
        int bs = 0;
        fi = 0;
        bi = 0;
        while (fi < 10) {
            if (buf[bi] == 124) {
                String s = new String(buf, bs, bi - bs);
                switch (fi) {
                    case 0: {
                        if (buf[fi] != tmp[fi]) {
                            throw new Exception("Failed to decrypt jespa/license.key");
                        }
                    }
                    case 4: {
                        if (fi == 0) {
                            this.serialNumber = s;
                        } else if (fi == 4) {
                            this.description = s;
                        }
                        if (buf[12] == tmp[12]) break;
                        throw new Exception("Failed to decrypt jespa/license.key");
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        int i = Integer.parseInt(s);
                        if (fi == 1) {
                            this.userLimit = i;
                            break;
                        }
                        if (fi == 2) {
                            if (buf[16 + fi] != tmp[18]) {
                                throw new Exception("Failed to decrypt jespa/license.key");
                            }
                            this.groupLimit = i;
                            break;
                        }
                        if (fi != 3) break;
                        this.expiration = (long)i * 1000L;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        if (buf[fi] == tmp[fi]) break;
                        throw new Exception("Failed to decrypt jespa/license.key");
                    }
                }
                bs = bi + 1;
                ++fi;
            }
            ++bi;
        }
        if (this.expiration > 0L && System.currentTimeMillis() > this.expiration) {
            this.userLimit = 25;
            this.groupLimit = 25;
        }
        if (LogStream.level >= 3) {
            log.println("Jespa license.key decrypted successfully:\r\n" + this.toString());
        }
        String[] revoked = new String[]{"S" + "N311".toString() + "1120110223"};
        for (int ri = 0; ri < revoked.length; ++ri) {
            if (!revoked[ri].equalsIgnoreCase(this.serialNumber)) continue;
            throw new Exception("The license has been revoked and is no longer valid");
        }
    }

    public String toString() {
        String exp = this.expiration == 0L ? "0" : new Date(this.expiration).toString();
        return "serialNumber: [" + this.serialNumber + "]\r\n" + "   userLimit: [" + this.userLimit + "]\r\n" + "  groupLimit: [" + this.groupLimit + "]\r\n" + "  expiration: [" + exp + "]\r\n" + " description: [" + this.description + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overwrite(File dstfile, String srcpath) throws Exception {
        if (LogStream.level >= 2) {
            log.println("Deleting " + dstfile + " and overwriting with " + srcpath);
        }
        FileOutputStream fos = new FileOutputStream(dstfile);
        FileInputStream fis = new FileInputStream(srcpath);
        try {
            int n;
            byte[] buf = new byte[4096];
            while ((n = fis.read(buf, 0, buf.length)) > -1) {
                fos.write(buf, 0, n);
            }
        }
        finally {
            fis.close();
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private License update(URI jaruri, String keypath) throws Exception {
        License ret = null;
        File jarfile = new File(jaruri);
        if (LogStream.level >= 3) {
            log.println("jarfile[" + jarfile + "] keypath[" + keypath + "]");
        }
        File tmp = File.createTempFile("jespa_", null);
        String tmppath = tmp.getAbsolutePath();
        try {
            ZipEntry ze;
            ZipOutputStream zo = new ZipOutputStream(new FileOutputStream(tmp));
            ZipInputStream zi = new ZipInputStream(new FileInputStream(jarfile));
            FileInputStream li = new FileInputStream(keypath);
            byte[] buf = new byte[4096];
            while ((ze = zi.getNextEntry()) != null) {
                int n;
                String name;
                if (LogStream.level >= 3) {
                    log.println(ze);
                }
                if ("jespa/license.key".equals(name = ze.getName())) {
                    int tot = 0;
                    zo.putNextEntry(new ZipEntry(name));
                    while ((n = li.read(buf, 0, buf.length)) > -1) {
                        zo.write(buf, 0, n);
                        tot += n;
                    }
                    if (LogStream.level >= 2) {
                        log.println("jespa/license.key resource updated: " + tot + " bytes");
                    }
                } else {
                    zo.putNextEntry(ze);
                    while ((n = zi.read(buf, 0, buf.length)) > -1) {
                        zo.write(buf, 0, n);
                    }
                }
                zi.closeEntry();
                zo.closeEntry();
            }
            li.close();
            zi.close();
            zo.close();
            ret = new License(new FileInputStream(tmppath));
            this.overwrite(jarfile, tmppath);
        }
        finally {
            tmp = new File(tmppath);
            tmp.delete();
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String keypath = null;
        for (int ai = 0; ai < args.length; ++ai) {
            if (args[ai].equals("-h")) {
                System.err.println("Usage: java -cp jespa.jar jespa.License [-h] [-u <keypath>]");
                System.exit(1);
                continue;
            }
            if (!args[ai].equals("-u")) continue;
            keypath = args[++ai];
        }
        String logLevel = System.getenv("LOG_LEVEL");
        LogStream.setLevel(Integer.parseInt(logLevel == null ? "1" : logLevel));
        License lic = new License(null);
        if (keypath != null) {
            URI jaruri = lic.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            System.err.print("To update the jar file " + jaruri + " with the license key " + keypath + " enter 'Y': ");
            int ch = System.in.read();
            if (ch == 89 || ch == 121) {
                lic = lic.update(jaruri, keypath);
                System.err.println("The license key was updated successfully");
            } else {
                System.err.println("The license key was not updated");
            }
        }
        if (lic.expiration > 0L && System.currentTimeMillis() > lic.expiration) {
            System.err.println("WARNING: This Jespa license appears to have expired. User and group limits are in effect.");
        }
        System.out.println(lic.toString());
    }
}

