/*
 * Decompiled with CFR 0.152.
 */
package jespa.dcerpc;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcSecurityProvider;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jespa.io.ByteBuffer;
import jespa.util.LogStream;

public class SecureChannelDcerpcSecurityProvider
extends HashMap
implements DcerpcSecurityProvider {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    static LogStream log = LogStream.getInstance();
    static final SecureRandom RANDOM = new SecureRandom();
    static final byte[] SIGNATURE = new byte[]{119, 0, 122, 0, -1, -1, 0, 0};
    static final byte[] ZEROS = new byte[]{0, 0, 0, 0};
    int _sequenceNumber = 0;

    public SecureChannelDcerpcSecurityProvider(Map properties) {
        super(properties);
    }

    public Object getProperty(String name) throws DcerpcException {
        if (this.containsKey(name)) {
            return this.get(name);
        }
        throw new DcerpcException("Property not set or constructed: " + name);
    }

    byte[] computeChecksum(byte[] sessionKey, byte[] confounder, byte[] data, int off, int len) throws GeneralSecurityException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(ZEROS, 0, 4);
        md5.update(SIGNATURE, 0, 8);
        md5.update(confounder, 0, 8);
        md5.update(data, off, len);
        HMACT64 hmac = new HMACT64(sessionKey);
        hmac.update(md5.digest());
        byte[] checksum = new byte[8];
        System.arraycopy(hmac.digest(), 0, checksum, 0, 8);
        return checksum;
    }

    void sequenceNumberCrypt(byte[] sessionKey, int opmode, byte[] checksum, byte[] sequenceNumber) throws GeneralSecurityException {
        HMACT64 hmac = new HMACT64(sessionKey);
        hmac.update(ZEROS);
        hmac = new HMACT64(hmac.digest());
        hmac.update(checksum, 0, 8);
        byte[] sequenceKey = hmac.digest();
        this.crypt(opmode, sequenceKey, sequenceNumber, 0, 8);
    }

    byte[] getEncryptionKey(byte[] sessionKey, byte[] sequenceNumber) {
        byte[] xorKey = new byte[16];
        for (int ki = 0; ki < sessionKey.length; ++ki) {
            xorKey[ki] = (byte)(sessionKey[ki] ^ 0xF0);
        }
        HMACT64 hmac = new HMACT64(xorKey);
        hmac.update(ZEROS);
        hmac = new HMACT64(hmac.digest());
        hmac.update(sequenceNumber, 0, 8);
        return hmac.digest();
    }

    void crypt(int opmode, byte[] encryptionKey, byte[] data, int off, int len) throws GeneralSecurityException {
        Cipher rc4 = Cipher.getInstance("RC4");
        rc4.init(opmode, new SecretKeySpec(encryptionKey, "RC4"));
        rc4.update(data, off, len, data, off);
    }

    public void wrap(NdrBuffer outgoing) throws DcerpcException {
        try {
            outgoing.setIndex(2);
            int ptype = outgoing.dec_ndr_small();
            outgoing.setIndex(outgoing.getLength());
            int auth_pad_length = outgoing.align(4, (byte)0);
            ByteBuffer vdbb = new ByteBuffer(outgoing.getBuffer(), outgoing.getLength(), 0);
            vdbb.setStart();
            vdbb.encodeUint8(68);
            vdbb.encodeUint8(6);
            vdbb.encodeUint8(auth_pad_length);
            vdbb.encodeUint8(0);
            vdbb.encodeUint32le(1);
            if (ptype == 11) {
                vdbb.encodeUint32le(0);
                vdbb.encodeUint32le(3);
                String netbiosDomain = (String)this.getProperty("domain.netbios.name");
                String netbiosName = (String)this.getProperty("localhost.netbios.name");
                vdbb.encodeBytes(netbiosDomain.getBytes(), 0, netbiosDomain.length());
                vdbb.encodeUint8(0);
                vdbb.encodeBytes(netbiosName.getBytes(), 0, netbiosName.length());
                vdbb.encodeUint8(0);
            } else if (ptype == 0) {
                byte[] sessionKey = (byte[])this.getProperty("sessionKey");
                byte[] sequenceNumber = new byte[8];
                byte[] confounder = new byte[8];
                RANDOM.nextBytes(confounder);
                byte[] checksum = this.computeChecksum(sessionKey, confounder, outgoing.getBuffer(), 24, outgoing.getLength() - 24);
                Encdec.enc_uint32be((int)this._sequenceNumber, (byte[])sequenceNumber, (int)0);
                Encdec.enc_uint32le((int)128, (byte[])sequenceNumber, (int)4);
                byte[] encryptionKey = this.getEncryptionKey(sessionKey, sequenceNumber);
                this.crypt(1, encryptionKey, confounder, 0, 8);
                this.crypt(1, encryptionKey, outgoing.getBuffer(), 24, outgoing.getLength() - 24);
                this.sequenceNumberCrypt(sessionKey, 1, checksum, sequenceNumber);
                vdbb.encodeBytes(SIGNATURE, 0, 8);
                vdbb.encodeBytes(sequenceNumber, 0, 8);
                vdbb.encodeBytes(checksum, 0, 8);
                vdbb.encodeBytes(confounder, 0, 8);
                ++this._sequenceNumber;
            }
            int auth_length = vdbb.getLength() - 8;
            int frag_length = outgoing.getLength() + 8 + auth_length;
            outgoing.setIndex(8);
            outgoing.enc_ndr_short(frag_length);
            outgoing.enc_ndr_short(auth_length);
            outgoing.setIndex(outgoing.getLength());
            outgoing.advance(8 + auth_length);
        }
        catch (Exception e) {
            throw new DcerpcException("DCERPC Secure Channel wrap failure", (Throwable)e);
        }
    }

    public void unwrap(NdrBuffer incoming) throws DcerpcException {
        try {
            incoming.setIndex(2);
            int ptype = incoming.dec_ndr_small();
            incoming.setIndex(8);
            int frag_length = incoming.dec_ndr_short();
            int auth_length = incoming.dec_ndr_short();
            frag_length -= 8 + auth_length;
            if (ptype != 12 && ptype == 2) {
                byte[] sessionKey = (byte[])this.getProperty("sessionKey");
                ByteBuffer vebb = new ByteBuffer(incoming.getBuffer(), frag_length, 8 + auth_length);
                vebb.setStart();
                byte[] sequenceNumber = new byte[8];
                byte[] checksum = new byte[8];
                byte[] confounder = new byte[8];
                vebb.setIndex(16);
                vebb.decodeBytes(sequenceNumber, 0, 8);
                vebb.decodeBytes(checksum, 0, 8);
                vebb.decodeBytes(confounder, 0, 8);
                byte[] sequenceNumberExpected = new byte[8];
                Encdec.enc_uint32be((int)this._sequenceNumber, (byte[])sequenceNumberExpected, (int)0);
                Encdec.enc_uint32le((int)0, (byte[])sequenceNumberExpected, (int)4);
                this.sequenceNumberCrypt(sessionKey, 1, checksum, sequenceNumberExpected);
                if (!Arrays.equals(sequenceNumber, sequenceNumberExpected)) {
                    throw new DcerpcException("SEC_E_MESSAGE_ALTERED: SequenceNumber failure");
                }
                this.sequenceNumberCrypt(sessionKey, 2, checksum, sequenceNumber);
                byte[] encryptionKey = this.getEncryptionKey(sessionKey, sequenceNumber);
                this.crypt(2, encryptionKey, confounder, 0, 8);
                this.crypt(2, encryptionKey, incoming.getBuffer(), 24, frag_length - 24);
                byte[] checksumExpected = this.computeChecksum(sessionKey, confounder, incoming.getBuffer(), 24, frag_length - 24);
                if (!Arrays.equals(checksum, checksumExpected)) {
                    throw new DcerpcException("SEC_E_MESSAGE_ALTERED: Checksum failure");
                }
                ++this._sequenceNumber;
            }
            incoming.setIndex(8);
            incoming.enc_ndr_short(frag_length);
            incoming.enc_ndr_short(0);
            incoming.setLength(frag_length);
        }
        catch (DcerpcException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DcerpcException("DCERPC Secure Channel unwrap failure", (Throwable)e);
        }
    }
}

