/*
 * Decompiled with CFR 0.152.
 */
package jespa.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.msrpc.samr;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.rpc;

public class netlogon {
    public static final int NETLOGON_GUEST = 1;
    public static final int NETLOGON_NOENCRYPTION = 2;
    public static final int NETLOGON_CACHED_ACCOUNT = 4;
    public static final int NETLOGON_USED_LM_PASSWORD = 8;
    public static final int NETLOGON_EXTRA_SIDS = 32;
    public static final int NETLOGON_SUBAUTH_SESSION_KEY = 64;
    public static final int NETLOGON_SERVER_TRUST_ACCOUNT = 128;
    public static final int NETLOGON_NTLMV2_ENABLED = 256;
    public static final int NETLOGON_RESOURCE_GROUPS = 512;
    public static final int NETLOGON_PROFILE_PATH_RETURNED = 1024;
    public static final int DS_DOMAIN_IN_FOREST = 1;
    public static final int DS_DOMAIN_DIRECT_OUTBOUND = 2;
    public static final int DS_DOMAIN_TREE_ROOT = 4;
    public static final int DS_DOMAIN_PRIMARY = 8;
    public static final int DS_DOMAIN_NATIVE_MODE = 10;
    public static final int DS_DOMAIN_DIRECT_INBOUND = 20;

    public static String getSyntax() {
        return "12345678-1234-abcd-ef00-01234567cffb:1.0";
    }

    public static class NetrDsEnumerateDomainTrusts
    extends DcerpcMessage {
        public int retval;
        public String server_name;
        public int flags;
        public NetrTrustedDomainArray domains;

        public int getOpnum() {
            return 40;
        }

        public NetrDsEnumerateDomainTrusts(String server_name, int flags, NetrTrustedDomainArray domains) {
            this.server_name = server_name;
            this.flags = flags;
            this.domains = domains;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            _dst.enc_ndr_referent((Object)this.server_name, 1);
            if (this.server_name != null) {
                _dst.enc_ndr_string(this.server_name);
            }
            _dst.enc_ndr_long(this.flags);
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            this.domains.decode(_src);
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class NetrTrustedDomainArray
    extends NdrObject {
        public int domain_count;
        public NetrDomainTrust[] domains;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_long(this.domain_count);
            _dst.enc_ndr_referent((Object)this.domains, 1);
            if (this.domains != null) {
                _dst = _dst.deferred;
                int _domainss = this.domain_count;
                _dst.enc_ndr_long(_domainss);
                int _domainsi = _dst.index;
                _dst.advance(44 * _domainss);
                _dst = _dst.derive(_domainsi);
                for (int _i = 0; _i < _domainss; ++_i) {
                    this.domains[_i].encode(_dst);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            this.domain_count = _src.dec_ndr_long();
            int _domainsp = _src.dec_ndr_long();
            if (_domainsp != 0) {
                _src = _src.deferred;
                int _domainss = _src.dec_ndr_long();
                int _domainsi = _src.index;
                _src.advance(44 * _domainss);
                if (this.domains == null) {
                    if (_domainss < 0 || _domainss > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.domains = new NetrDomainTrust[_domainss];
                }
                _src = _src.derive(_domainsi);
                for (int _i = 0; _i < _domainss; ++_i) {
                    if (this.domains[_i] == null) {
                        this.domains[_i] = new NetrDomainTrust();
                    }
                    this.domains[_i].decode(_src);
                }
            }
        }
    }

    public static class NetrDomainTrust
    extends NdrObject {
        public String netbios_domain_name;
        public String dns_domain_name;
        public int flags;
        public int parent_index;
        public int trust_type;
        public int trust_attributes;
        public rpc.sid_t domain_sid;
        public rpc.uuid_t domain_guid;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_referent((Object)this.netbios_domain_name, 1);
            _dst.enc_ndr_referent((Object)this.dns_domain_name, 1);
            _dst.enc_ndr_long(this.flags);
            _dst.enc_ndr_long(this.parent_index);
            _dst.enc_ndr_long(this.trust_type);
            _dst.enc_ndr_long(this.trust_attributes);
            _dst.enc_ndr_referent((Object)this.domain_sid, 1);
            _dst.enc_ndr_long(this.domain_guid.time_low);
            _dst.enc_ndr_short((int)this.domain_guid.time_mid);
            _dst.enc_ndr_short((int)this.domain_guid.time_hi_and_version);
            _dst.enc_ndr_small((int)this.domain_guid.clock_seq_hi_and_reserved);
            _dst.enc_ndr_small((int)this.domain_guid.clock_seq_low);
            int _domain_guid_nodes = 6;
            int _domain_guid_nodei = _dst.index;
            _dst.advance(1 * _domain_guid_nodes);
            if (this.netbios_domain_name != null) {
                _dst = _dst.deferred;
                _dst.enc_ndr_string(this.netbios_domain_name);
            }
            if (this.dns_domain_name != null) {
                _dst = _dst.deferred;
                _dst.enc_ndr_string(this.dns_domain_name);
            }
            if (this.domain_sid != null) {
                _dst = _dst.deferred;
                this.domain_sid.encode(_dst);
            }
            _dst = _dst.derive(_domain_guid_nodei);
            for (int _i = 0; _i < _domain_guid_nodes; ++_i) {
                _dst.enc_ndr_small((int)this.domain_guid.node[_i]);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            int _netbios_domain_namep = _src.dec_ndr_long();
            int _dns_domain_namep = _src.dec_ndr_long();
            this.flags = _src.dec_ndr_long();
            this.parent_index = _src.dec_ndr_long();
            this.trust_type = _src.dec_ndr_long();
            this.trust_attributes = _src.dec_ndr_long();
            int _domain_sidp = _src.dec_ndr_long();
            _src.align(4);
            if (this.domain_guid == null) {
                this.domain_guid = new rpc.uuid_t();
            }
            this.domain_guid.time_low = _src.dec_ndr_long();
            this.domain_guid.time_mid = (short)_src.dec_ndr_short();
            this.domain_guid.time_hi_and_version = (short)_src.dec_ndr_short();
            this.domain_guid.clock_seq_hi_and_reserved = (byte)_src.dec_ndr_small();
            this.domain_guid.clock_seq_low = (byte)_src.dec_ndr_small();
            int _domain_guid_nodes = 6;
            int _domain_guid_nodei = _src.index;
            _src.advance(1 * _domain_guid_nodes);
            if (_netbios_domain_namep != 0) {
                _src = _src.deferred;
                this.netbios_domain_name = _src.dec_ndr_string();
            }
            if (_dns_domain_namep != 0) {
                _src = _src.deferred;
                this.dns_domain_name = _src.dec_ndr_string();
            }
            if (_domain_sidp != 0) {
                if (this.domain_sid == null) {
                    this.domain_sid = new rpc.sid_t();
                }
                _src = _src.deferred;
                this.domain_sid.decode(_src);
            }
            if (this.domain_guid.node == null) {
                if (_domain_guid_nodes < 0 || _domain_guid_nodes > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.domain_guid.node = new byte[_domain_guid_nodes];
            }
            _src = _src.derive(_domain_guid_nodei);
            for (int _i = 0; _i < _domain_guid_nodes; ++_i) {
                this.domain_guid.node[_i] = (byte)_src.dec_ndr_small();
            }
        }
    }

    public static class NetrServerAuthenticate3
    extends DcerpcMessage {
        public int retval;
        public String server_name;
        public String account_name;
        public short secure_channel_type;
        public String computer_name;
        public byte[] client_credential;
        public byte[] server_credential;
        public int negotiate_flags;
        public int account_rid;

        public int getOpnum() {
            return 26;
        }

        public NetrServerAuthenticate3(String server_name, String account_name, short secure_channel_type, String computer_name, byte[] client_credential, byte[] server_credential, int negotiate_flags, int account_rid) {
            this.server_name = server_name;
            this.account_name = account_name;
            this.secure_channel_type = secure_channel_type;
            this.computer_name = computer_name;
            this.client_credential = client_credential;
            this.server_credential = server_credential;
            this.negotiate_flags = negotiate_flags;
            this.account_rid = account_rid;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            NdrBuffer _start = _dst;
            _dst.enc_ndr_referent((Object)this.server_name, 1);
            if (this.server_name != null) {
                _dst.enc_ndr_string(this.server_name);
            }
            _dst.enc_ndr_string(this.account_name);
            _dst.enc_ndr_short((int)this.secure_channel_type);
            _dst.enc_ndr_string(this.computer_name);
            int _client_credentials = 8;
            int _client_credentiali = _dst.index;
            _dst.advance(1 * _client_credentials);
            _dst = _dst.derive(_client_credentiali);
            for (int _i = 0; _i < _client_credentials; ++_i) {
                _dst.enc_ndr_small((int)this.client_credential[_i]);
            }
            _dst.enc_ndr_long(this.negotiate_flags);
            _start.setIndex(_dst.getIndex());
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            int _server_credentials = 8;
            int _server_credentiali = _src.index;
            _src.advance(1 * _server_credentials);
            if (this.server_credential == null) {
                if (_server_credentials < 0 || _server_credentials > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.server_credential = new byte[_server_credentials];
            }
            _src = _src.derive(_server_credentiali);
            for (int _i = 0; _i < _server_credentials; ++_i) {
                this.server_credential[_i] = (byte)_src.dec_ndr_small();
            }
            this.negotiate_flags = _src.dec_ndr_long();
            this.account_rid = _src.dec_ndr_long();
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class NetrServerAuthenticate2
    extends DcerpcMessage {
        public int retval;
        public String server_name;
        public String account_name;
        public short secure_channel_type;
        public String computer_name;
        public byte[] client_credential;
        public byte[] server_credential;
        public int negotiate_flags;

        public int getOpnum() {
            return 15;
        }

        public NetrServerAuthenticate2(String server_name, String account_name, short secure_channel_type, String computer_name, byte[] client_credential, byte[] server_credential, int negotiate_flags) {
            this.server_name = server_name;
            this.account_name = account_name;
            this.secure_channel_type = secure_channel_type;
            this.computer_name = computer_name;
            this.client_credential = client_credential;
            this.server_credential = server_credential;
            this.negotiate_flags = negotiate_flags;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            NdrBuffer _start = _dst;
            _dst.enc_ndr_referent((Object)this.server_name, 1);
            if (this.server_name != null) {
                _dst.enc_ndr_string(this.server_name);
            }
            _dst.enc_ndr_string(this.account_name);
            _dst.enc_ndr_short((int)this.secure_channel_type);
            _dst.enc_ndr_string(this.computer_name);
            int _client_credentials = 8;
            int _client_credentiali = _dst.index;
            _dst.advance(1 * _client_credentials);
            _dst = _dst.derive(_client_credentiali);
            for (int _i = 0; _i < _client_credentials; ++_i) {
                _dst.enc_ndr_small((int)this.client_credential[_i]);
            }
            _dst.enc_ndr_long(this.negotiate_flags);
            _start.setIndex(_dst.getIndex());
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            int _server_credentials = 8;
            int _server_credentiali = _src.index;
            _src.advance(1 * _server_credentials);
            if (this.server_credential == null) {
                if (_server_credentials < 0 || _server_credentials > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.server_credential = new byte[_server_credentials];
            }
            _src = _src.derive(_server_credentiali);
            for (int _i = 0; _i < _server_credentials; ++_i) {
                this.server_credential[_i] = (byte)_src.dec_ndr_small();
            }
            this.negotiate_flags = _src.dec_ndr_long();
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class NetrServerReqChallenge
    extends DcerpcMessage {
        public int retval;
        public String server_name;
        public String computer_name;
        public byte[] client_challenge;
        public byte[] server_challenge;

        public int getOpnum() {
            return 4;
        }

        public NetrServerReqChallenge(String server_name, String computer_name, byte[] client_challenge, byte[] server_challenge) {
            this.server_name = server_name;
            this.computer_name = computer_name;
            this.client_challenge = client_challenge;
            this.server_challenge = server_challenge;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            _dst.enc_ndr_referent((Object)this.server_name, 1);
            if (this.server_name != null) {
                _dst.enc_ndr_string(this.server_name);
            }
            _dst.enc_ndr_string(this.computer_name);
            int _client_challenges = 8;
            int _client_challengei = _dst.index;
            _dst.advance(1 * _client_challenges);
            _dst = _dst.derive(_client_challengei);
            for (int _i = 0; _i < _client_challenges; ++_i) {
                _dst.enc_ndr_small((int)this.client_challenge[_i]);
            }
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            int _server_challenges = 8;
            int _server_challengei = _src.index;
            _src.advance(1 * _server_challenges);
            if (this.server_challenge == null) {
                if (_server_challenges < 0 || _server_challenges > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.server_challenge = new byte[_server_challenges];
            }
            _src = _src.derive(_server_challengei);
            for (int _i = 0; _i < _server_challenges; ++_i) {
                this.server_challenge[_i] = (byte)_src.dec_ndr_small();
            }
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class NetrLogonSamLogon
    extends DcerpcMessage {
        public int retval;
        public String logon_server;
        public String computer_name;
        public NetrAuthenticator authenticator;
        public NetrAuthenticator return_authenticator;
        public short logon_level;
        public NdrObject logon;
        public short validation_level;
        public NdrObject validation;
        public byte authoritative;

        public int getOpnum() {
            return 2;
        }

        public NetrLogonSamLogon(String logon_server, String computer_name, NetrAuthenticator authenticator, NetrAuthenticator return_authenticator, short logon_level, NdrObject logon, short validation_level, NdrObject validation, byte authoritative) {
            this.logon_server = logon_server;
            this.computer_name = computer_name;
            this.authenticator = authenticator;
            this.return_authenticator = return_authenticator;
            this.logon_level = logon_level;
            this.logon = logon;
            this.validation_level = validation_level;
            this.validation = validation;
            this.authoritative = authoritative;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            _dst.enc_ndr_referent((Object)this.logon_server, 1);
            if (this.logon_server != null) {
                _dst.enc_ndr_string(this.logon_server);
            }
            _dst.enc_ndr_referent((Object)this.computer_name, 1);
            if (this.computer_name != null) {
                _dst.enc_ndr_string(this.computer_name);
            }
            _dst.enc_ndr_referent((Object)this.authenticator, 1);
            if (this.authenticator != null) {
                this.authenticator.encode(_dst);
            }
            _dst.enc_ndr_referent((Object)this.return_authenticator, 1);
            if (this.return_authenticator != null) {
                this.return_authenticator.encode(_dst);
            }
            _dst.enc_ndr_short((int)this.logon_level);
            short _descr = this.logon_level;
            _dst.enc_ndr_short((int)_descr);
            _dst.enc_ndr_referent((Object)this.logon, 1);
            if (this.logon != null) {
                _dst = _dst.deferred;
                this.logon.encode(_dst);
            }
            _dst.enc_ndr_short((int)this.validation_level);
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            int _return_authenticatorp = _src.dec_ndr_long();
            if (_return_authenticatorp != 0) {
                if (this.return_authenticator == null) {
                    this.return_authenticator = new NetrAuthenticator();
                }
                this.return_authenticator.decode(_src);
            }
            _src.dec_ndr_short();
            int _validationp = _src.dec_ndr_long();
            if (_validationp != 0) {
                if (this.validation == null) {
                    this.validation = new NetrSamInfo2();
                }
                _src = _src.deferred;
                this.validation.decode(_src);
            }
            this.authoritative = (byte)_src.dec_ndr_small();
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class NetrSamInfo2
    extends NdrObject {
        public long last_logon;
        public long last_logoff;
        public long kick_off_time;
        public long last_password_change;
        public long allow_password_change;
        public long force_password_change;
        public rpc.unicode_string account_name;
        public rpc.unicode_string full_name;
        public rpc.unicode_string logon_script;
        public rpc.unicode_string profile_path;
        public rpc.unicode_string home_directory;
        public rpc.unicode_string home_drive;
        public short logon_count;
        public short bad_password_count;
        public int rid;
        public int primary_gid;
        public samr.SamrRidWithAttributeArray groups;
        public int user_flags;
        public NetrUserSessionKey key;
        public rpc.unicode_string logon_server;
        public rpc.unicode_string domain;
        public rpc.sid_t logon_domain;
        public NetrLMSessionKey lm_session_key;
        public int acct_flags;
        public int[] unknown;
        public int sid_count;
        public NetrSidAndAttributes[] extra_sids;

        public void encode(NdrBuffer _dst) throws NdrException {
            int _i;
            int _i2;
            int _i3;
            _dst.align(8);
            _dst.enc_ndr_hyper(this.last_logon);
            _dst.enc_ndr_hyper(this.last_logoff);
            _dst.enc_ndr_hyper(this.kick_off_time);
            _dst.enc_ndr_hyper(this.last_password_change);
            _dst.enc_ndr_hyper(this.allow_password_change);
            _dst.enc_ndr_hyper(this.force_password_change);
            _dst.enc_ndr_short((int)this.account_name.length);
            _dst.enc_ndr_short((int)this.account_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.account_name.buffer, 1);
            _dst.enc_ndr_short((int)this.full_name.length);
            _dst.enc_ndr_short((int)this.full_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.full_name.buffer, 1);
            _dst.enc_ndr_short((int)this.logon_script.length);
            _dst.enc_ndr_short((int)this.logon_script.maximum_length);
            _dst.enc_ndr_referent((Object)this.logon_script.buffer, 1);
            _dst.enc_ndr_short((int)this.profile_path.length);
            _dst.enc_ndr_short((int)this.profile_path.maximum_length);
            _dst.enc_ndr_referent((Object)this.profile_path.buffer, 1);
            _dst.enc_ndr_short((int)this.home_directory.length);
            _dst.enc_ndr_short((int)this.home_directory.maximum_length);
            _dst.enc_ndr_referent((Object)this.home_directory.buffer, 1);
            _dst.enc_ndr_short((int)this.home_drive.length);
            _dst.enc_ndr_short((int)this.home_drive.maximum_length);
            _dst.enc_ndr_referent((Object)this.home_drive.buffer, 1);
            _dst.enc_ndr_short((int)this.logon_count);
            _dst.enc_ndr_short((int)this.bad_password_count);
            _dst.enc_ndr_long(this.rid);
            _dst.enc_ndr_long(this.primary_gid);
            _dst.enc_ndr_long(this.groups.count);
            _dst.enc_ndr_referent((Object)this.groups.rids, 1);
            _dst.enc_ndr_long(this.user_flags);
            int _key_keys = 16;
            int _key_keyi = _dst.index;
            _dst.advance(1 * _key_keys);
            _dst.enc_ndr_short((int)this.logon_server.length);
            _dst.enc_ndr_short((int)this.logon_server.maximum_length);
            _dst.enc_ndr_referent((Object)this.logon_server.buffer, 1);
            _dst.enc_ndr_short((int)this.domain.length);
            _dst.enc_ndr_short((int)this.domain.maximum_length);
            _dst.enc_ndr_referent((Object)this.domain.buffer, 1);
            _dst.enc_ndr_referent((Object)this.logon_domain, 1);
            int _lm_session_key_keys = 8;
            int _lm_session_key_keyi = _dst.index;
            _dst.advance(1 * _lm_session_key_keys);
            _dst.enc_ndr_long(this.acct_flags);
            int _unknowns = 7;
            int _unknowni = _dst.index;
            _dst.advance(4 * _unknowns);
            _dst.enc_ndr_long(this.sid_count);
            _dst.enc_ndr_referent((Object)this.extra_sids, 1);
            if (this.account_name.buffer != null) {
                _dst = _dst.deferred;
                int _account_name_bufferl = this.account_name.length / 2;
                int _account_name_buffers = this.account_name.maximum_length / 2;
                _dst.enc_ndr_long(_account_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_account_name_bufferl);
                int _account_name_bufferi = _dst.index;
                _dst.advance(2 * _account_name_bufferl);
                _dst = _dst.derive(_account_name_bufferi);
                for (_i3 = 0; _i3 < _account_name_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.account_name.buffer[_i3]);
                }
            }
            if (this.full_name.buffer != null) {
                _dst = _dst.deferred;
                int _full_name_bufferl = this.full_name.length / 2;
                int _full_name_buffers = this.full_name.maximum_length / 2;
                _dst.enc_ndr_long(_full_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_full_name_bufferl);
                int _full_name_bufferi = _dst.index;
                _dst.advance(2 * _full_name_bufferl);
                _dst = _dst.derive(_full_name_bufferi);
                for (_i3 = 0; _i3 < _full_name_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.full_name.buffer[_i3]);
                }
            }
            if (this.logon_script.buffer != null) {
                _dst = _dst.deferred;
                int _logon_script_bufferl = this.logon_script.length / 2;
                int _logon_script_buffers = this.logon_script.maximum_length / 2;
                _dst.enc_ndr_long(_logon_script_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_logon_script_bufferl);
                int _logon_script_bufferi = _dst.index;
                _dst.advance(2 * _logon_script_bufferl);
                _dst = _dst.derive(_logon_script_bufferi);
                for (_i3 = 0; _i3 < _logon_script_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.logon_script.buffer[_i3]);
                }
            }
            if (this.profile_path.buffer != null) {
                _dst = _dst.deferred;
                int _profile_path_bufferl = this.profile_path.length / 2;
                int _profile_path_buffers = this.profile_path.maximum_length / 2;
                _dst.enc_ndr_long(_profile_path_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_profile_path_bufferl);
                int _profile_path_bufferi = _dst.index;
                _dst.advance(2 * _profile_path_bufferl);
                _dst = _dst.derive(_profile_path_bufferi);
                for (_i3 = 0; _i3 < _profile_path_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.profile_path.buffer[_i3]);
                }
            }
            if (this.home_directory.buffer != null) {
                _dst = _dst.deferred;
                int _home_directory_bufferl = this.home_directory.length / 2;
                int _home_directory_buffers = this.home_directory.maximum_length / 2;
                _dst.enc_ndr_long(_home_directory_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_home_directory_bufferl);
                int _home_directory_bufferi = _dst.index;
                _dst.advance(2 * _home_directory_bufferl);
                _dst = _dst.derive(_home_directory_bufferi);
                for (_i3 = 0; _i3 < _home_directory_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.home_directory.buffer[_i3]);
                }
            }
            if (this.home_drive.buffer != null) {
                _dst = _dst.deferred;
                int _home_drive_bufferl = this.home_drive.length / 2;
                int _home_drive_buffers = this.home_drive.maximum_length / 2;
                _dst.enc_ndr_long(_home_drive_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_home_drive_bufferl);
                int _home_drive_bufferi = _dst.index;
                _dst.advance(2 * _home_drive_bufferl);
                _dst = _dst.derive(_home_drive_bufferi);
                for (_i3 = 0; _i3 < _home_drive_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.home_drive.buffer[_i3]);
                }
            }
            if (this.groups.rids != null) {
                _dst = _dst.deferred;
                int _groups_ridss = this.groups.count;
                _dst.enc_ndr_long(_groups_ridss);
                int _groups_ridsi = _dst.index;
                _dst.advance(8 * _groups_ridss);
                _dst = _dst.derive(_groups_ridsi);
                for (_i2 = 0; _i2 < _groups_ridss; ++_i2) {
                    this.groups.rids[_i2].encode(_dst);
                }
            }
            _dst = _dst.derive(_key_keyi);
            for (_i = 0; _i < _key_keys; ++_i) {
                _dst.enc_ndr_small((int)this.key.key[_i]);
            }
            if (this.logon_server.buffer != null) {
                _dst = _dst.deferred;
                int _logon_server_bufferl = this.logon_server.length / 2;
                int _logon_server_buffers = this.logon_server.maximum_length / 2;
                _dst.enc_ndr_long(_logon_server_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_logon_server_bufferl);
                int _logon_server_bufferi = _dst.index;
                _dst.advance(2 * _logon_server_bufferl);
                _dst = _dst.derive(_logon_server_bufferi);
                for (_i3 = 0; _i3 < _logon_server_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.logon_server.buffer[_i3]);
                }
            }
            if (this.domain.buffer != null) {
                _dst = _dst.deferred;
                int _domain_bufferl = this.domain.length / 2;
                int _domain_buffers = this.domain.maximum_length / 2;
                _dst.enc_ndr_long(_domain_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_domain_bufferl);
                int _domain_bufferi = _dst.index;
                _dst.advance(2 * _domain_bufferl);
                _dst = _dst.derive(_domain_bufferi);
                for (_i3 = 0; _i3 < _domain_bufferl; ++_i3) {
                    _dst.enc_ndr_short((int)this.domain.buffer[_i3]);
                }
            }
            if (this.logon_domain != null) {
                _dst = _dst.deferred;
                this.logon_domain.encode(_dst);
            }
            _dst = _dst.derive(_lm_session_key_keyi);
            for (_i = 0; _i < _lm_session_key_keys; ++_i) {
                _dst.enc_ndr_small((int)this.lm_session_key.key[_i]);
            }
            _dst = _dst.derive(_unknowni);
            for (_i = 0; _i < _unknowns; ++_i) {
                _dst.enc_ndr_long(this.unknown[_i]);
            }
            if (this.extra_sids != null) {
                _dst = _dst.deferred;
                int _extra_sidss = this.sid_count;
                _dst.enc_ndr_long(_extra_sidss);
                int _extra_sidsi = _dst.index;
                _dst.advance(8 * _extra_sidss);
                _dst = _dst.derive(_extra_sidsi);
                for (_i2 = 0; _i2 < _extra_sidss; ++_i2) {
                    this.extra_sids[_i2].encode(_dst);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            int _i;
            int _i2;
            int _i3;
            _src.align(8);
            this.last_logon = _src.dec_ndr_hyper();
            this.last_logoff = _src.dec_ndr_hyper();
            this.kick_off_time = _src.dec_ndr_hyper();
            this.last_password_change = _src.dec_ndr_hyper();
            this.allow_password_change = _src.dec_ndr_hyper();
            this.force_password_change = _src.dec_ndr_hyper();
            _src.align(4);
            if (this.account_name == null) {
                this.account_name = new rpc.unicode_string();
            }
            this.account_name.length = (short)_src.dec_ndr_short();
            this.account_name.maximum_length = (short)_src.dec_ndr_short();
            int _account_name_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.full_name == null) {
                this.full_name = new rpc.unicode_string();
            }
            this.full_name.length = (short)_src.dec_ndr_short();
            this.full_name.maximum_length = (short)_src.dec_ndr_short();
            int _full_name_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.logon_script == null) {
                this.logon_script = new rpc.unicode_string();
            }
            this.logon_script.length = (short)_src.dec_ndr_short();
            this.logon_script.maximum_length = (short)_src.dec_ndr_short();
            int _logon_script_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.profile_path == null) {
                this.profile_path = new rpc.unicode_string();
            }
            this.profile_path.length = (short)_src.dec_ndr_short();
            this.profile_path.maximum_length = (short)_src.dec_ndr_short();
            int _profile_path_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.home_directory == null) {
                this.home_directory = new rpc.unicode_string();
            }
            this.home_directory.length = (short)_src.dec_ndr_short();
            this.home_directory.maximum_length = (short)_src.dec_ndr_short();
            int _home_directory_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.home_drive == null) {
                this.home_drive = new rpc.unicode_string();
            }
            this.home_drive.length = (short)_src.dec_ndr_short();
            this.home_drive.maximum_length = (short)_src.dec_ndr_short();
            int _home_drive_bufferp = _src.dec_ndr_long();
            this.logon_count = (short)_src.dec_ndr_short();
            this.bad_password_count = (short)_src.dec_ndr_short();
            this.rid = _src.dec_ndr_long();
            this.primary_gid = _src.dec_ndr_long();
            _src.align(4);
            if (this.groups == null) {
                this.groups = new samr.SamrRidWithAttributeArray();
            }
            this.groups.count = _src.dec_ndr_long();
            int _groups_ridsp = _src.dec_ndr_long();
            this.user_flags = _src.dec_ndr_long();
            _src.align(1);
            if (this.key == null) {
                this.key = new NetrUserSessionKey();
            }
            int _key_keys = 16;
            int _key_keyi = _src.index;
            _src.advance(1 * _key_keys);
            _src.align(4);
            if (this.logon_server == null) {
                this.logon_server = new rpc.unicode_string();
            }
            this.logon_server.length = (short)_src.dec_ndr_short();
            this.logon_server.maximum_length = (short)_src.dec_ndr_short();
            int _logon_server_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.domain == null) {
                this.domain = new rpc.unicode_string();
            }
            this.domain.length = (short)_src.dec_ndr_short();
            this.domain.maximum_length = (short)_src.dec_ndr_short();
            int _domain_bufferp = _src.dec_ndr_long();
            int _logon_domainp = _src.dec_ndr_long();
            _src.align(1);
            if (this.lm_session_key == null) {
                this.lm_session_key = new NetrLMSessionKey();
            }
            int _lm_session_key_keys = 8;
            int _lm_session_key_keyi = _src.index;
            _src.advance(1 * _lm_session_key_keys);
            this.acct_flags = _src.dec_ndr_long();
            int _unknowns = 7;
            int _unknowni = _src.index;
            _src.advance(4 * _unknowns);
            this.sid_count = _src.dec_ndr_long();
            int _extra_sidsp = _src.dec_ndr_long();
            if (_account_name_bufferp != 0) {
                _src = _src.deferred;
                int _account_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _account_name_bufferl = _src.dec_ndr_long();
                int _account_name_bufferi = _src.index;
                _src.advance(2 * _account_name_bufferl);
                if (this.account_name.buffer == null) {
                    if (_account_name_buffers < 0 || _account_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.account_name.buffer = new short[_account_name_buffers];
                }
                _src = _src.derive(_account_name_bufferi);
                for (_i3 = 0; _i3 < _account_name_bufferl; ++_i3) {
                    this.account_name.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_full_name_bufferp != 0) {
                _src = _src.deferred;
                int _full_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _full_name_bufferl = _src.dec_ndr_long();
                int _full_name_bufferi = _src.index;
                _src.advance(2 * _full_name_bufferl);
                if (this.full_name.buffer == null) {
                    if (_full_name_buffers < 0 || _full_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.full_name.buffer = new short[_full_name_buffers];
                }
                _src = _src.derive(_full_name_bufferi);
                for (_i3 = 0; _i3 < _full_name_bufferl; ++_i3) {
                    this.full_name.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_logon_script_bufferp != 0) {
                _src = _src.deferred;
                int _logon_script_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _logon_script_bufferl = _src.dec_ndr_long();
                int _logon_script_bufferi = _src.index;
                _src.advance(2 * _logon_script_bufferl);
                if (this.logon_script.buffer == null) {
                    if (_logon_script_buffers < 0 || _logon_script_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.logon_script.buffer = new short[_logon_script_buffers];
                }
                _src = _src.derive(_logon_script_bufferi);
                for (_i3 = 0; _i3 < _logon_script_bufferl; ++_i3) {
                    this.logon_script.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_profile_path_bufferp != 0) {
                _src = _src.deferred;
                int _profile_path_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _profile_path_bufferl = _src.dec_ndr_long();
                int _profile_path_bufferi = _src.index;
                _src.advance(2 * _profile_path_bufferl);
                if (this.profile_path.buffer == null) {
                    if (_profile_path_buffers < 0 || _profile_path_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.profile_path.buffer = new short[_profile_path_buffers];
                }
                _src = _src.derive(_profile_path_bufferi);
                for (_i3 = 0; _i3 < _profile_path_bufferl; ++_i3) {
                    this.profile_path.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_home_directory_bufferp != 0) {
                _src = _src.deferred;
                int _home_directory_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _home_directory_bufferl = _src.dec_ndr_long();
                int _home_directory_bufferi = _src.index;
                _src.advance(2 * _home_directory_bufferl);
                if (this.home_directory.buffer == null) {
                    if (_home_directory_buffers < 0 || _home_directory_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.home_directory.buffer = new short[_home_directory_buffers];
                }
                _src = _src.derive(_home_directory_bufferi);
                for (_i3 = 0; _i3 < _home_directory_bufferl; ++_i3) {
                    this.home_directory.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_home_drive_bufferp != 0) {
                _src = _src.deferred;
                int _home_drive_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _home_drive_bufferl = _src.dec_ndr_long();
                int _home_drive_bufferi = _src.index;
                _src.advance(2 * _home_drive_bufferl);
                if (this.home_drive.buffer == null) {
                    if (_home_drive_buffers < 0 || _home_drive_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.home_drive.buffer = new short[_home_drive_buffers];
                }
                _src = _src.derive(_home_drive_bufferi);
                for (_i3 = 0; _i3 < _home_drive_bufferl; ++_i3) {
                    this.home_drive.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_groups_ridsp != 0) {
                _src = _src.deferred;
                int _groups_ridss = _src.dec_ndr_long();
                int _groups_ridsi = _src.index;
                _src.advance(8 * _groups_ridss);
                if (this.groups.rids == null) {
                    if (_groups_ridss < 0 || _groups_ridss > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.groups.rids = new samr.SamrRidWithAttribute[_groups_ridss];
                }
                _src = _src.derive(_groups_ridsi);
                for (_i2 = 0; _i2 < _groups_ridss; ++_i2) {
                    if (this.groups.rids[_i2] == null) {
                        this.groups.rids[_i2] = new samr.SamrRidWithAttribute();
                    }
                    this.groups.rids[_i2].decode(_src);
                }
            }
            if (this.key.key == null) {
                if (_key_keys < 0 || _key_keys > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.key.key = new byte[_key_keys];
            }
            _src = _src.derive(_key_keyi);
            for (_i = 0; _i < _key_keys; ++_i) {
                this.key.key[_i] = (byte)_src.dec_ndr_small();
            }
            if (_logon_server_bufferp != 0) {
                _src = _src.deferred;
                int _logon_server_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _logon_server_bufferl = _src.dec_ndr_long();
                int _logon_server_bufferi = _src.index;
                _src.advance(2 * _logon_server_bufferl);
                if (this.logon_server.buffer == null) {
                    if (_logon_server_buffers < 0 || _logon_server_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.logon_server.buffer = new short[_logon_server_buffers];
                }
                _src = _src.derive(_logon_server_bufferi);
                for (_i3 = 0; _i3 < _logon_server_bufferl; ++_i3) {
                    this.logon_server.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_domain_bufferp != 0) {
                _src = _src.deferred;
                int _domain_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _domain_bufferl = _src.dec_ndr_long();
                int _domain_bufferi = _src.index;
                _src.advance(2 * _domain_bufferl);
                if (this.domain.buffer == null) {
                    if (_domain_buffers < 0 || _domain_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.domain.buffer = new short[_domain_buffers];
                }
                _src = _src.derive(_domain_bufferi);
                for (_i3 = 0; _i3 < _domain_bufferl; ++_i3) {
                    this.domain.buffer[_i3] = (short)_src.dec_ndr_short();
                }
            }
            if (_logon_domainp != 0) {
                if (this.logon_domain == null) {
                    this.logon_domain = new rpc.sid_t();
                }
                _src = _src.deferred;
                this.logon_domain.decode(_src);
            }
            if (this.lm_session_key.key == null) {
                if (_lm_session_key_keys < 0 || _lm_session_key_keys > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.lm_session_key.key = new byte[_lm_session_key_keys];
            }
            _src = _src.derive(_lm_session_key_keyi);
            for (_i = 0; _i < _lm_session_key_keys; ++_i) {
                this.lm_session_key.key[_i] = (byte)_src.dec_ndr_small();
            }
            if (this.unknown == null) {
                if (_unknowns < 0 || _unknowns > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.unknown = new int[_unknowns];
            }
            _src = _src.derive(_unknowni);
            for (_i = 0; _i < _unknowns; ++_i) {
                this.unknown[_i] = _src.dec_ndr_long();
            }
            if (_extra_sidsp != 0) {
                _src = _src.deferred;
                int _extra_sidss = _src.dec_ndr_long();
                int _extra_sidsi = _src.index;
                _src.advance(8 * _extra_sidss);
                if (this.extra_sids == null) {
                    if (_extra_sidss < 0 || _extra_sidss > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.extra_sids = new NetrSidAndAttributes[_extra_sidss];
                }
                _src = _src.derive(_extra_sidsi);
                for (_i2 = 0; _i2 < _extra_sidss; ++_i2) {
                    if (this.extra_sids[_i2] == null) {
                        this.extra_sids[_i2] = new NetrSidAndAttributes();
                    }
                    this.extra_sids[_i2].decode(_src);
                }
            }
        }
    }

    public static class NetrSidAndAttributes
    extends NdrObject {
        public rpc.sid_t sid;
        public int attributes;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_referent((Object)this.sid, 1);
            _dst.enc_ndr_long(this.attributes);
            if (this.sid != null) {
                _dst = _dst.deferred;
                this.sid.encode(_dst);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            int _sidp = _src.dec_ndr_long();
            this.attributes = _src.dec_ndr_long();
            if (_sidp != 0) {
                if (this.sid == null) {
                    this.sid = new rpc.sid_t();
                }
                _src = _src.deferred;
                this.sid.decode(_src);
            }
        }
    }

    public static class NetrLMSessionKey
    extends NdrObject {
        public byte[] key;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(1);
            int _keys = 8;
            int _keyi = _dst.index;
            _dst.advance(1 * _keys);
            _dst = _dst.derive(_keyi);
            for (int _i = 0; _i < _keys; ++_i) {
                _dst.enc_ndr_small((int)this.key[_i]);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(1);
            int _keys = 8;
            int _keyi = _src.index;
            _src.advance(1 * _keys);
            if (this.key == null) {
                if (_keys < 0 || _keys > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.key = new byte[_keys];
            }
            _src = _src.derive(_keyi);
            for (int _i = 0; _i < _keys; ++_i) {
                this.key[_i] = (byte)_src.dec_ndr_small();
            }
        }
    }

    public static class NetrUserSessionKey
    extends NdrObject {
        public byte[] key;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(1);
            int _keys = 16;
            int _keyi = _dst.index;
            _dst.advance(1 * _keys);
            _dst = _dst.derive(_keyi);
            for (int _i = 0; _i < _keys; ++_i) {
                _dst.enc_ndr_small((int)this.key[_i]);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(1);
            int _keys = 16;
            int _keyi = _src.index;
            _src.advance(1 * _keys);
            if (this.key == null) {
                if (_keys < 0 || _keys > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.key = new byte[_keys];
            }
            _src = _src.derive(_keyi);
            for (int _i = 0; _i < _keys; ++_i) {
                this.key[_i] = (byte)_src.dec_ndr_small();
            }
        }
    }

    public static class NetrNetworkInfo
    extends NdrObject {
        public NetrIdentityInfo identity_info;
        public byte[] challenge;
        public NetrChallengeResponse nt;
        public NetrChallengeResponse lm;

        public void encode(NdrBuffer _dst) throws NdrException {
            int _i;
            _dst.align(4);
            _dst.enc_ndr_short((int)this.identity_info.domain_name.length);
            _dst.enc_ndr_short((int)this.identity_info.domain_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.identity_info.domain_name.buffer, 1);
            _dst.enc_ndr_long(this.identity_info.parameter_control);
            _dst.enc_ndr_long(this.identity_info.logon_id_low);
            _dst.enc_ndr_long(this.identity_info.logon_id_high);
            _dst.enc_ndr_short((int)this.identity_info.account_name.length);
            _dst.enc_ndr_short((int)this.identity_info.account_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.identity_info.account_name.buffer, 1);
            _dst.enc_ndr_short((int)this.identity_info.workstation.length);
            _dst.enc_ndr_short((int)this.identity_info.workstation.maximum_length);
            _dst.enc_ndr_referent((Object)this.identity_info.workstation.buffer, 1);
            int _challenges = 8;
            int _challengei = _dst.index;
            _dst.advance(1 * _challenges);
            _dst.enc_ndr_short((int)this.nt.length);
            _dst.enc_ndr_short((int)this.nt.maximum_length);
            _dst.enc_ndr_referent((Object)this.nt.data, 1);
            _dst.enc_ndr_short((int)this.lm.length);
            _dst.enc_ndr_short((int)this.lm.maximum_length);
            _dst.enc_ndr_referent((Object)this.lm.data, 1);
            if (this.identity_info.domain_name.buffer != null) {
                _dst = _dst.deferred;
                int _identity_info_domain_name_bufferl = this.identity_info.domain_name.length / 2;
                int _identity_info_domain_name_buffers = this.identity_info.domain_name.maximum_length / 2;
                _dst.enc_ndr_long(_identity_info_domain_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_identity_info_domain_name_bufferl);
                int _identity_info_domain_name_bufferi = _dst.index;
                _dst.advance(2 * _identity_info_domain_name_bufferl);
                _dst = _dst.derive(_identity_info_domain_name_bufferi);
                for (_i = 0; _i < _identity_info_domain_name_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.identity_info.domain_name.buffer[_i]);
                }
            }
            if (this.identity_info.account_name.buffer != null) {
                _dst = _dst.deferred;
                int _identity_info_account_name_bufferl = this.identity_info.account_name.length / 2;
                int _identity_info_account_name_buffers = this.identity_info.account_name.maximum_length / 2;
                _dst.enc_ndr_long(_identity_info_account_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_identity_info_account_name_bufferl);
                int _identity_info_account_name_bufferi = _dst.index;
                _dst.advance(2 * _identity_info_account_name_bufferl);
                _dst = _dst.derive(_identity_info_account_name_bufferi);
                for (_i = 0; _i < _identity_info_account_name_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.identity_info.account_name.buffer[_i]);
                }
            }
            if (this.identity_info.workstation.buffer != null) {
                _dst = _dst.deferred;
                int _identity_info_workstation_bufferl = this.identity_info.workstation.length / 2;
                int _identity_info_workstation_buffers = this.identity_info.workstation.maximum_length / 2;
                _dst.enc_ndr_long(_identity_info_workstation_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_identity_info_workstation_bufferl);
                int _identity_info_workstation_bufferi = _dst.index;
                _dst.advance(2 * _identity_info_workstation_bufferl);
                _dst = _dst.derive(_identity_info_workstation_bufferi);
                for (_i = 0; _i < _identity_info_workstation_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.identity_info.workstation.buffer[_i]);
                }
            }
            _dst = _dst.derive(_challengei);
            for (int _i2 = 0; _i2 < _challenges; ++_i2) {
                _dst.enc_ndr_small((int)this.challenge[_i2]);
            }
            if (this.nt.data != null) {
                _dst = _dst.deferred;
                int _nt_datal = this.nt.length;
                short _nt_datas = this.nt.maximum_length;
                _dst.enc_ndr_long((int)_nt_datas);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_nt_datal);
                int _nt_datai = _dst.index;
                _dst.advance(1 * _nt_datal);
                _dst = _dst.derive(_nt_datai);
                for (_i = 0; _i < _nt_datal; ++_i) {
                    _dst.enc_ndr_small((int)this.nt.data[_i]);
                }
            }
            if (this.lm.data != null) {
                _dst = _dst.deferred;
                int _lm_datal = this.lm.length;
                short _lm_datas = this.lm.maximum_length;
                _dst.enc_ndr_long((int)_lm_datas);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_lm_datal);
                int _lm_datai = _dst.index;
                _dst.advance(1 * _lm_datal);
                _dst = _dst.derive(_lm_datai);
                for (_i = 0; _i < _lm_datal; ++_i) {
                    _dst.enc_ndr_small((int)this.lm.data[_i]);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            int _i;
            _src.align(4);
            _src.align(4);
            if (this.identity_info == null) {
                this.identity_info = new NetrIdentityInfo();
            }
            _src.align(4);
            if (this.identity_info.domain_name == null) {
                this.identity_info.domain_name = new rpc.unicode_string();
            }
            this.identity_info.domain_name.length = (short)_src.dec_ndr_short();
            this.identity_info.domain_name.maximum_length = (short)_src.dec_ndr_short();
            int _identity_info_domain_name_bufferp = _src.dec_ndr_long();
            this.identity_info.parameter_control = _src.dec_ndr_long();
            this.identity_info.logon_id_low = _src.dec_ndr_long();
            this.identity_info.logon_id_high = _src.dec_ndr_long();
            _src.align(4);
            if (this.identity_info.account_name == null) {
                this.identity_info.account_name = new rpc.unicode_string();
            }
            this.identity_info.account_name.length = (short)_src.dec_ndr_short();
            this.identity_info.account_name.maximum_length = (short)_src.dec_ndr_short();
            int _identity_info_account_name_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.identity_info.workstation == null) {
                this.identity_info.workstation = new rpc.unicode_string();
            }
            this.identity_info.workstation.length = (short)_src.dec_ndr_short();
            this.identity_info.workstation.maximum_length = (short)_src.dec_ndr_short();
            int _identity_info_workstation_bufferp = _src.dec_ndr_long();
            int _challenges = 8;
            int _challengei = _src.index;
            _src.advance(1 * _challenges);
            _src.align(4);
            if (this.nt == null) {
                this.nt = new NetrChallengeResponse();
            }
            this.nt.length = (short)_src.dec_ndr_short();
            this.nt.maximum_length = (short)_src.dec_ndr_short();
            int _nt_datap = _src.dec_ndr_long();
            _src.align(4);
            if (this.lm == null) {
                this.lm = new NetrChallengeResponse();
            }
            this.lm.length = (short)_src.dec_ndr_short();
            this.lm.maximum_length = (short)_src.dec_ndr_short();
            int _lm_datap = _src.dec_ndr_long();
            if (_identity_info_domain_name_bufferp != 0) {
                _src = _src.deferred;
                int _identity_info_domain_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _identity_info_domain_name_bufferl = _src.dec_ndr_long();
                int _identity_info_domain_name_bufferi = _src.index;
                _src.advance(2 * _identity_info_domain_name_bufferl);
                if (this.identity_info.domain_name.buffer == null) {
                    if (_identity_info_domain_name_buffers < 0 || _identity_info_domain_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.identity_info.domain_name.buffer = new short[_identity_info_domain_name_buffers];
                }
                _src = _src.derive(_identity_info_domain_name_bufferi);
                for (_i = 0; _i < _identity_info_domain_name_bufferl; ++_i) {
                    this.identity_info.domain_name.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
            if (_identity_info_account_name_bufferp != 0) {
                _src = _src.deferred;
                int _identity_info_account_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _identity_info_account_name_bufferl = _src.dec_ndr_long();
                int _identity_info_account_name_bufferi = _src.index;
                _src.advance(2 * _identity_info_account_name_bufferl);
                if (this.identity_info.account_name.buffer == null) {
                    if (_identity_info_account_name_buffers < 0 || _identity_info_account_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.identity_info.account_name.buffer = new short[_identity_info_account_name_buffers];
                }
                _src = _src.derive(_identity_info_account_name_bufferi);
                for (_i = 0; _i < _identity_info_account_name_bufferl; ++_i) {
                    this.identity_info.account_name.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
            if (_identity_info_workstation_bufferp != 0) {
                _src = _src.deferred;
                int _identity_info_workstation_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _identity_info_workstation_bufferl = _src.dec_ndr_long();
                int _identity_info_workstation_bufferi = _src.index;
                _src.advance(2 * _identity_info_workstation_bufferl);
                if (this.identity_info.workstation.buffer == null) {
                    if (_identity_info_workstation_buffers < 0 || _identity_info_workstation_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.identity_info.workstation.buffer = new short[_identity_info_workstation_buffers];
                }
                _src = _src.derive(_identity_info_workstation_bufferi);
                for (_i = 0; _i < _identity_info_workstation_bufferl; ++_i) {
                    this.identity_info.workstation.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
            if (this.challenge == null) {
                if (_challenges < 0 || _challenges > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.challenge = new byte[_challenges];
            }
            _src = _src.derive(_challengei);
            for (int _i2 = 0; _i2 < _challenges; ++_i2) {
                this.challenge[_i2] = (byte)_src.dec_ndr_small();
            }
            if (_nt_datap != 0) {
                _src = _src.deferred;
                int _nt_datas = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _nt_datal = _src.dec_ndr_long();
                int _nt_datai = _src.index;
                _src.advance(1 * _nt_datal);
                if (this.nt.data == null) {
                    if (_nt_datas < 0 || _nt_datas > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.nt.data = new byte[_nt_datas];
                }
                _src = _src.derive(_nt_datai);
                for (_i = 0; _i < _nt_datal; ++_i) {
                    this.nt.data[_i] = (byte)_src.dec_ndr_small();
                }
            }
            if (_lm_datap != 0) {
                _src = _src.deferred;
                int _lm_datas = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _lm_datal = _src.dec_ndr_long();
                int _lm_datai = _src.index;
                _src.advance(1 * _lm_datal);
                if (this.lm.data == null) {
                    if (_lm_datas < 0 || _lm_datas > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.lm.data = new byte[_lm_datas];
                }
                _src = _src.derive(_lm_datai);
                for (_i = 0; _i < _lm_datal; ++_i) {
                    this.lm.data[_i] = (byte)_src.dec_ndr_small();
                }
            }
        }
    }

    public static class NetrChallengeResponse
    extends NdrObject {
        public short length;
        public short maximum_length;
        public byte[] data;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_short((int)this.length);
            _dst.enc_ndr_short((int)this.maximum_length);
            _dst.enc_ndr_referent((Object)this.data, 1);
            if (this.data != null) {
                _dst = _dst.deferred;
                int _datal = this.length;
                short _datas = this.maximum_length;
                _dst.enc_ndr_long((int)_datas);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_datal);
                int _datai = _dst.index;
                _dst.advance(1 * _datal);
                _dst = _dst.derive(_datai);
                for (int _i = 0; _i < _datal; ++_i) {
                    _dst.enc_ndr_small((int)this.data[_i]);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            this.length = (short)_src.dec_ndr_short();
            this.maximum_length = (short)_src.dec_ndr_short();
            int _datap = _src.dec_ndr_long();
            if (_datap != 0) {
                _src = _src.deferred;
                int _datas = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _datal = _src.dec_ndr_long();
                int _datai = _src.index;
                _src.advance(1 * _datal);
                if (this.data == null) {
                    if (_datas < 0 || _datas > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.data = new byte[_datas];
                }
                _src = _src.derive(_datai);
                for (int _i = 0; _i < _datal; ++_i) {
                    this.data[_i] = (byte)_src.dec_ndr_small();
                }
            }
        }
    }

    public static class NetrIdentityInfo
    extends NdrObject {
        public rpc.unicode_string domain_name;
        public int parameter_control;
        public int logon_id_low;
        public int logon_id_high;
        public rpc.unicode_string account_name;
        public rpc.unicode_string workstation;

        public void encode(NdrBuffer _dst) throws NdrException {
            int _i;
            _dst.align(4);
            _dst.enc_ndr_short((int)this.domain_name.length);
            _dst.enc_ndr_short((int)this.domain_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.domain_name.buffer, 1);
            _dst.enc_ndr_long(this.parameter_control);
            _dst.enc_ndr_long(this.logon_id_low);
            _dst.enc_ndr_long(this.logon_id_high);
            _dst.enc_ndr_short((int)this.account_name.length);
            _dst.enc_ndr_short((int)this.account_name.maximum_length);
            _dst.enc_ndr_referent((Object)this.account_name.buffer, 1);
            _dst.enc_ndr_short((int)this.workstation.length);
            _dst.enc_ndr_short((int)this.workstation.maximum_length);
            _dst.enc_ndr_referent((Object)this.workstation.buffer, 1);
            if (this.domain_name.buffer != null) {
                _dst = _dst.deferred;
                int _domain_name_bufferl = this.domain_name.length / 2;
                int _domain_name_buffers = this.domain_name.maximum_length / 2;
                _dst.enc_ndr_long(_domain_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_domain_name_bufferl);
                int _domain_name_bufferi = _dst.index;
                _dst.advance(2 * _domain_name_bufferl);
                _dst = _dst.derive(_domain_name_bufferi);
                for (_i = 0; _i < _domain_name_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.domain_name.buffer[_i]);
                }
            }
            if (this.account_name.buffer != null) {
                _dst = _dst.deferred;
                int _account_name_bufferl = this.account_name.length / 2;
                int _account_name_buffers = this.account_name.maximum_length / 2;
                _dst.enc_ndr_long(_account_name_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_account_name_bufferl);
                int _account_name_bufferi = _dst.index;
                _dst.advance(2 * _account_name_bufferl);
                _dst = _dst.derive(_account_name_bufferi);
                for (_i = 0; _i < _account_name_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.account_name.buffer[_i]);
                }
            }
            if (this.workstation.buffer != null) {
                _dst = _dst.deferred;
                int _workstation_bufferl = this.workstation.length / 2;
                int _workstation_buffers = this.workstation.maximum_length / 2;
                _dst.enc_ndr_long(_workstation_buffers);
                _dst.enc_ndr_long(0);
                _dst.enc_ndr_long(_workstation_bufferl);
                int _workstation_bufferi = _dst.index;
                _dst.advance(2 * _workstation_bufferl);
                _dst = _dst.derive(_workstation_bufferi);
                for (_i = 0; _i < _workstation_bufferl; ++_i) {
                    _dst.enc_ndr_short((int)this.workstation.buffer[_i]);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            int _i;
            _src.align(4);
            _src.align(4);
            if (this.domain_name == null) {
                this.domain_name = new rpc.unicode_string();
            }
            this.domain_name.length = (short)_src.dec_ndr_short();
            this.domain_name.maximum_length = (short)_src.dec_ndr_short();
            int _domain_name_bufferp = _src.dec_ndr_long();
            this.parameter_control = _src.dec_ndr_long();
            this.logon_id_low = _src.dec_ndr_long();
            this.logon_id_high = _src.dec_ndr_long();
            _src.align(4);
            if (this.account_name == null) {
                this.account_name = new rpc.unicode_string();
            }
            this.account_name.length = (short)_src.dec_ndr_short();
            this.account_name.maximum_length = (short)_src.dec_ndr_short();
            int _account_name_bufferp = _src.dec_ndr_long();
            _src.align(4);
            if (this.workstation == null) {
                this.workstation = new rpc.unicode_string();
            }
            this.workstation.length = (short)_src.dec_ndr_short();
            this.workstation.maximum_length = (short)_src.dec_ndr_short();
            int _workstation_bufferp = _src.dec_ndr_long();
            if (_domain_name_bufferp != 0) {
                _src = _src.deferred;
                int _domain_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _domain_name_bufferl = _src.dec_ndr_long();
                int _domain_name_bufferi = _src.index;
                _src.advance(2 * _domain_name_bufferl);
                if (this.domain_name.buffer == null) {
                    if (_domain_name_buffers < 0 || _domain_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.domain_name.buffer = new short[_domain_name_buffers];
                }
                _src = _src.derive(_domain_name_bufferi);
                for (_i = 0; _i < _domain_name_bufferl; ++_i) {
                    this.domain_name.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
            if (_account_name_bufferp != 0) {
                _src = _src.deferred;
                int _account_name_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _account_name_bufferl = _src.dec_ndr_long();
                int _account_name_bufferi = _src.index;
                _src.advance(2 * _account_name_bufferl);
                if (this.account_name.buffer == null) {
                    if (_account_name_buffers < 0 || _account_name_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.account_name.buffer = new short[_account_name_buffers];
                }
                _src = _src.derive(_account_name_bufferi);
                for (_i = 0; _i < _account_name_bufferl; ++_i) {
                    this.account_name.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
            if (_workstation_bufferp != 0) {
                _src = _src.deferred;
                int _workstation_buffers = _src.dec_ndr_long();
                _src.dec_ndr_long();
                int _workstation_bufferl = _src.dec_ndr_long();
                int _workstation_bufferi = _src.index;
                _src.advance(2 * _workstation_bufferl);
                if (this.workstation.buffer == null) {
                    if (_workstation_buffers < 0 || _workstation_buffers > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.workstation.buffer = new short[_workstation_buffers];
                }
                _src = _src.derive(_workstation_bufferi);
                for (_i = 0; _i < _workstation_bufferl; ++_i) {
                    this.workstation.buffer[_i] = (short)_src.dec_ndr_short();
                }
            }
        }
    }

    public static class NetrAuthenticator
    extends NdrObject {
        public byte[] cred;
        public int timestamp;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            int _creds = 8;
            int _credi = _dst.index;
            _dst.advance(1 * _creds);
            _dst.enc_ndr_long(this.timestamp);
            _dst = _dst.derive(_credi);
            for (int _i = 0; _i < _creds; ++_i) {
                _dst.enc_ndr_small((int)this.cred[_i]);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            int _creds = 8;
            int _credi = _src.index;
            _src.advance(1 * _creds);
            this.timestamp = _src.dec_ndr_long();
            if (this.cred == null) {
                if (_creds < 0 || _creds > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.cred = new byte[_creds];
            }
            _src = _src.derive(_credi);
            for (int _i = 0; _i < _creds; ++_i) {
                this.cred[_i] = (byte)_src.dec_ndr_small();
            }
        }
    }
}

