/*
 * Decompiled with CFR 0.152.
 */
package jespa.dns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import jespa.dns.DnsException;
import jespa.dns.RecordsFile;
import jespa.security.Properties;
import jespa.util.CacheMap;
import jespa.util.Csv;
import jespa.util.LogStream;

public class Dns {
    public static final String WARNING_API_NOT_SUPPORTED = "EVEN IF DECLARED PUBLIC, CLASSES OR INTERFACES THAT ARE NOT DOCUMENTED ARE NOT SUPPORTED AND MAY CHANGE AT ANY TIME WITHOUT NOTICE.";
    public static final long CAP_SRV = 1L;
    public static final long CAP_MSDCS = 2L;
    public static final long CAP_SITES = 4L;
    static final long DEFAULT_TTL = 5000L;
    static CacheMap<Map, Dns> dnsContexts = new CacheMap("DNS: dnsContexts", 14400L, 3600L);
    String[] servers;
    String factoryClassname = "com.sun.jndi.dns.DnsContextFactory";
    int si = 0;
    RecordsFile recordsFile = null;
    Map cache = null;
    long ttl = -1L;
    LogStream log = LogStream.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dns getInstance(Map properties) throws DnsException {
        CacheMap<Map, Dns> cacheMap = dnsContexts;
        synchronized (cacheMap) {
            String[] keys = new String[]{"dns.servers", "dns.records.path", "dns.cache.ttl", "dns.site", "dns.jndifactory.classname"};
            Map props = Properties.getFilteredProperties(properties, keys);
            Dns dns = dnsContexts.get(props);
            if (dns == null) {
                dns = new Dns(props);
                dnsContexts.put(props, dns);
            }
            return dns;
        }
    }

    public Dns(Map props) throws DnsException {
        String ttl;
        this.servers = new String[]{""};
        String str = (String)props.get("dns.servers");
        if (str != null && str.trim().length() > 0) {
            try {
                this.servers = Csv.parseRow(str, ',', 5);
            }
            catch (IOException ioe) {
                throw new DnsException(0, "Failed to parse property: dns.servers", ioe);
            }
        }
        if ((str = (String)props.get("dns.jndifactory.classname")) != null) {
            String string = this.factoryClassname = (str = str.trim()).length() > 0 ? str : null;
        }
        if ((str = (String)props.get("dns.records.path")) != null && (str = str.trim()).length() > 0) {
            this.recordsFile = new RecordsFile(str);
        }
        this.ttl = (ttl = (String)props.get("dns.cache.ttl")) == null ? 5000L : Long.parseLong(ttl);
        if (LogStream.level >= 4) {
            this.log.println("DNS: " + props.get("dns.servers"));
        }
    }

    long getPropertyAsLong(Map props, String name, long def) throws DnsException {
        if (props.containsKey(name)) {
            Object ret = props.get(name);
            if (ret == null) {
                throw new DnsException(0, "Cannot parse null as numeric value: " + name);
            }
            String p = (String)ret;
            try {
                if (p.startsWith("0x")) {
                    return Long.parseLong(p.substring(2), 16);
                }
                return Long.parseLong(p);
            }
            catch (NumberFormatException nfe) {
                throw new DnsException(0, "Failed to parse property: " + name, nfe);
            }
        }
        return def;
    }

    DnsRecord[] getRecordsByName0(String name, String type) throws DnsException {
        DnsException de = null;
        int start = this.si;
        if (name == null || name.length() == 0 || type == null || type.length() == 0) {
            throw new DnsException(0, "Invalid parameters");
        }
        type = type.toUpperCase();
        while (true) {
            String server = this.servers[this.si];
            if (LogStream.level >= 4) {
                String msg = "DNS: '" + type + "' record lookup for " + name;
                msg = server.length() == 0 ? msg + " at the default server" : msg + " at server " + server;
                this.log.println(msg);
            }
            try {
                Hashtable<String, String> env = new Hashtable<String, String>(1);
                if (this.factoryClassname != null) {
                    env.put("java.naming.factory.initial", this.factoryClassname);
                }
                if (server.length() > 0) {
                    env.put("java.naming.provider.url", "dns://" + server);
                } else {
                    env.put("java.naming.provider.url", "dns:");
                }
                InitialDirContext context = new InitialDirContext(env);
                Attributes attributes = context.getAttributes(name, new String[]{type});
                if (type.equals("A")) {
                    ArrayList<DnsRecordA> list = new ArrayList<DnsRecordA>();
                    Attribute attr = attributes.get(type);
                    if (attr != null) {
                        NamingEnumeration<?> values = attr.getAll();
                        while (values.hasMoreElements()) {
                            String value = (String)values.nextElement();
                            DnsRecordA r = new DnsRecordA();
                            r.name = name;
                            r.expiration = 0L;
                            r.address = value;
                            list.add(r);
                        }
                        return list.toArray(new DnsRecordA[list.size()]);
                    }
                    throw new DnsException(3, "No records found: " + server);
                }
                if (type.equals("SRV")) {
                    ArrayList<DnsRecordSrv> list = new ArrayList<DnsRecordSrv>();
                    Attribute attr = attributes.get(type);
                    if (attr != null) {
                        NamingEnumeration<?> values = attr.getAll();
                        while (values.hasMoreElements()) {
                            String value = (String)values.nextElement();
                            DnsRecordSrv r = new DnsRecordSrv();
                            r.name = name;
                            r.expiration = 0L;
                            try {
                                String[] arr = Csv.parseRow(value, ' ', 4);
                                r.priority = Integer.parseInt(arr[0]);
                                r.weight = Integer.parseInt(arr[1]);
                                r.port = Integer.parseInt(arr[2]);
                                String target = arr[3];
                                if (target.charAt(target.length() - 1) == '.') {
                                    target = target.substring(0, target.length() - 1);
                                }
                                r.target = target;
                            }
                            catch (Exception e) {
                                throw new DnsException(0, "Failed to parse DNS SRV record: " + value, e);
                            }
                            list.add(r);
                        }
                        return list.toArray(new DnsRecordSrv[list.size()]);
                    }
                    throw new DnsException(3, "No records found: " + server);
                }
                throw new DnsException(0, "Unsupported DNS record type: " + type);
            }
            catch (NamingException ne) {
                Throwable t = ne.getCause();
                if (t == null) {
                    t = ne;
                }
                if (t instanceof NameNotFoundException) {
                    throw new DnsException(3, t.getMessage() + ": " + server, t);
                }
                de = new DnsException(0, t.getMessage() + ": " + server, t);
                if (LogStream.level >= 2) {
                    de.printStackTrace(this.log);
                }
                this.si = (this.si + 1) % this.servers.length;
                if (this.si != start) continue;
                throw de;
            }
            break;
        }
    }

    boolean isDotQuadIP(String hostname) {
        if (Character.isDigit(hostname.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = hostname.length();
            char[] data = hostname.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    return true;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnsRecord[] getRecordsByName(String name, String type) throws DnsException {
        if (type.equals("A") && this.isDotQuadIP(name)) {
            DnsRecord[] ret = new DnsRecordA[]{new DnsRecordA()};
            ret[0].name = name;
            ret[0].expiration = 0L;
            ret[0].address = name;
            return ret;
        }
        Dns dns = this;
        synchronized (dns) {
            String key;
            CacheEntry ce;
            if (this.recordsFile != null && this.recordsFile.isModified()) {
                this.cache = this.recordsFile.getRecords();
                if (LogStream.level >= 3) {
                    this.log.println("DNS: Loaded " + this.cache.size() + " records from file: " + this.recordsFile);
                    for (String key2 : this.cache.keySet()) {
                        this.log.println("DNS:  " + key2 + ":");
                        CacheEntry ce2 = (CacheEntry)this.cache.get(key2);
                        for (int ri = 0; ri < ce2.records.length; ++ri) {
                            DnsRecord r;
                            if (ce2.records[ri] instanceof DnsRecordSrv) {
                                r = (DnsRecordSrv)ce2.records[ri];
                                this.log.println("DNS:    " + r.priority + " " + r.weight + " " + r.port + " " + r.target);
                                continue;
                            }
                            if (ce2.records[ri] instanceof DnsRecordA) {
                                r = (DnsRecordA)ce2.records[ri];
                                this.log.println("DNS:    " + ((DnsRecordA)r).address);
                                continue;
                            }
                            this.log.println("DNS:    Unknown record type: " + ce2.records[ri]);
                        }
                    }
                }
            }
            if (this.cache == null) {
                this.cache = new HashMap();
            }
            if ((ce = (CacheEntry)this.cache.get(key = (type + ":" + name).toLowerCase())) != null && ce.expiration > 0L && System.currentTimeMillis() > ce.expiration) {
                this.cache.remove(key);
                ce = null;
            }
            if (ce == null) {
                ce = new CacheEntry();
                ce.records = this.getRecordsByName0(name, type);
                ce.ri = 0;
                ce.expiration = System.currentTimeMillis() + this.ttl;
                this.cache.put(key, ce);
                if (LogStream.level >= 4) {
                    this.log.println("DNS: '" + type + "' record lookup for " + name + " returned " + ce.records.length + " records");
                }
            } else if (LogStream.level >= 4) {
                this.log.println("DNS: '" + type + "' record lookup for " + name + " found " + ce.records.length + " records in cache");
            }
            DnsRecord[] ret = ce.records;
            if (ce.records.length > 0) {
                if (ce.records[0] instanceof DnsRecordA) {
                    ret = new DnsRecordA[ce.records.length];
                } else if (ce.records[0] instanceof DnsRecordSrv) {
                    ret = new DnsRecordSrv[ce.records.length];
                } else {
                    throw new DnsException(0, "Unexpected DNS record type: " + ce.records[0]);
                }
                for (int i = 0; i < ce.records.length; ++i) {
                    ret[(ce.ri + i) % ret.length] = ce.records[i];
                }
                ce.ri = (ce.ri + 1) % ce.records.length;
            }
            return ret;
        }
    }

    public DnsRecord getRecordByName(String name, String type) throws DnsException {
        DnsRecord[] records = this.getRecordsByName(name, type);
        return records[0];
    }

    static class CacheEntry {
        long expiration;
        int ri;
        DnsRecord[] records;

        CacheEntry() {
        }

        public String toString() {
            String ret = "CacheEntry{expiration=" + this.expiration + ",ri=" + this.ri + ",records=";
            for (int i = 0; i < this.records.length; ++i) {
                ret = ret + this.records[i].toString();
            }
            return ret + "}";
        }
    }

    public static class DnsRecordSrv
    extends DnsRecord {
        public int priority;
        public int weight;
        public int port;
        public String target;

        public String toString() {
            return "DnsRecord[name=" + this.name + ",expiration=" + this.expiration + ",priority=" + this.priority + ",weight=" + this.weight + ",port=" + this.port + ",target=" + this.target + "]";
        }
    }

    public static class DnsRecordA
    extends DnsRecord {
        public String address;

        public String toString() {
            return "DnsRecordA[name=" + this.name + ",expiration=" + this.expiration + ",address=" + this.address + "]";
        }
    }

    public static class DnsRecord {
        public String name;
        public long expiration;

        public String toString() {
            return "DnsRecord[name=" + this.name + ",expiration=" + this.expiration + "]";
        }
    }
}

