/*
 * Decompiled with CFR 0.152.
 */
package jespa.dns;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jespa.dns.Dns;
import jespa.dns.DnsException;
import jespa.util.CommentFilterReader;
import jespa.util.Csv;

class RecordsFile
extends File {
    static final long MODIFIED_EXPIRATION = 5000L;
    long isModifiedExpiration = 0L;
    long lastModifiedExpiration = 0L;

    RecordsFile(String path) {
        super(path);
    }

    boolean isModified() {
        long ctime = System.currentTimeMillis();
        if (ctime > this.isModifiedExpiration) {
            long mtime = this.lastModified();
            if (mtime > this.lastModifiedExpiration) {
                this.lastModifiedExpiration = mtime;
                return true;
            }
            this.isModifiedExpiration = ctime + 5000L;
        }
        return false;
    }

    Map getRecords() throws DnsException {
        try {
            String[] row;
            CommentFilterReader reader = new CommentFilterReader(new FileReader(this), '#');
            HashMap<String, Dns.CacheEntry> ret = new HashMap<String, Dns.CacheEntry>();
            while ((row = Csv.readRow(reader, ' ', 5)) != null) {
                Dns.DnsRecord[] records;
                Dns.DnsRecord r;
                Dns.DnsRecord r0;
                int rn;
                if (row.length < 3) continue;
                String name = row[0];
                String type = row[1].toUpperCase();
                String key = (type + ":" + name).toLowerCase();
                Dns.CacheEntry ce = (Dns.CacheEntry)ret.get(key);
                int n = rn = ce == null ? 0 : ce.records.length;
                if (type.equals("SRV")) {
                    r0 = new Dns.DnsRecordSrv();
                    r0.priority = Integer.parseInt(row[2]);
                    r0.weight = Integer.parseInt(row[3]);
                    r0.port = Integer.parseInt(row[4]);
                    String target = row[5];
                    if (target.charAt(target.length() - 1) == '.') {
                        target = target.substring(0, target.length() - 1);
                    }
                    r0.target = target;
                    r = r0;
                    records = new Dns.DnsRecordSrv[rn + 1];
                } else if (type.equals("A")) {
                    r0 = new Dns.DnsRecordA();
                    ((Dns.DnsRecordA)r0).address = row[2];
                    r = r0;
                    records = new Dns.DnsRecordA[rn + 1];
                } else {
                    throw new DnsException(0, "Record type is not supported: " + type);
                }
                r.name = name;
                r.expiration = 0L;
                if (ce == null) {
                    ce = new Dns.CacheEntry();
                    ce.expiration = -1L;
                    ce.ri = 0;
                    records[0] = r;
                    ce.records = records;
                    ret.put(key, ce);
                    continue;
                }
                for (int ri = 0; ri < ce.records.length; ++ri) {
                    records[ri] = ce.records[ri];
                }
                records[ri] = r;
                ce.records = records;
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new DnsException(0, "Failed to load DNS records from path: " + this.toString(), ioe);
        }
    }
}

