/*
 * Decompiled with CFR 0.152.
 */
package jespa.examples;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.util.Base64;
import jespa.http.HttpSecurityService;
import jespa.http.HttpSecurityServletRequest;
import jespa.ntlm.NtlmSecurityProvider;
import jespa.security.Account;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.Log4jLogStream;
import jespa.util.LogStream;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class MyHttpSecurityFilter
extends HttpSecurityService
implements Filter {
    static final String SECRET = "Spiral Architect";
    Logger logger = null;
    LogStream log = null;
    Map props = null;

    public void init(FilterConfig config) throws ServletException {
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            properties.put(name, config.getInitParameter(name));
        }
        try {
            super.init(config.getFilterName(), config.getServletContext(), properties);
        }
        catch (SecurityProviderException spe) {
            throw new ServletException((Throwable)spe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onPropertiesUpdate(Map props) throws SecurityProviderException {
        block10: {
            String encpass;
            this.props = props;
            if (this.logger != null) {
                LogStream.setInstance(null);
                this.log = LogStream.getInstance();
                this.logger.removeAllAppenders();
                this.logger = null;
            }
            super.onPropertiesUpdate(props);
            String logPath = (String)props.get("jespa.log.path");
            if (logPath != null) {
                try {
                    this.logger = Logger.getLogger(this.getClass());
                    this.logger.addAppender((Appender)new DailyRollingFileAppender((Layout)new SimpleLayout(), logPath, "'.'yyyy-MM-dd"));
                    LogStream.setInstance(new Log4jLogStream(this.logger, Level.INFO));
                    this.log = LogStream.getInstance();
                }
                catch (IOException ioe) {
                    throw new SecurityProviderException(0, null, ioe);
                }
            }
            if ((encpass = (String)props.remove("my.service.password.encrypted")) != null) {
                try {
                    String plaintext = (String)props.get("jespa.service.password");
                    if (plaintext != null) {
                        String ciphertext = this.passwordEncrypt(plaintext);
                        if (ciphertext == null) break block10;
                        if (LogStream.level >= 3) {
                            this.log.println("MyHttpSecurityFilter: my.service.password.encrypted = " + ciphertext);
                        }
                        break block10;
                    }
                    props.put("jespa.service.password", this.passwordDecrypt(encpass));
                }
                catch (GeneralSecurityException gse) {
                    throw new SecurityProviderException(0, null, gse);
                }
            }
        }
        if (LogStream.level >= 3) {
            this.log.println("MyHttpSecurityService: properties updated: " + props);
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected void onException(SecurityProviderException spe, HttpServletRequest req, HttpServletResponse rsp, SecurityProvider sp) throws SecurityProviderException {
        if (LogStream.level >= 4) {
            this.log.println("MyHttpSecurityService: onException: " + spe);
        }
        HttpSession ssn = req.getSession(true);
        ssn.setAttribute("my.message", (Object)spe.getMessage());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isDisabled;
        String disabled = (String)this.props.get("my.disabled");
        boolean bl = isDisabled = disabled != null && (disabled.equalsIgnoreCase("true") || disabled.equals("1") || disabled.equalsIgnoreCase("yes"));
        if (isDisabled) {
            if (LogStream.level >= 3) {
                this.log.println("MyHttpSecurityFilter: my.disabled = true, calling chain.doFilter directly");
            }
            chain.doFilter(request, response);
        } else {
            super.doFilter(request, response, new InnerFilterChain(chain));
        }
    }

    String passwordEncrypt(String plaintext) throws GeneralSecurityException {
        byte[] secret = (SECRET.hashCode() + "").substring(0, 8).getBytes();
        Cipher des = Cipher.getInstance("DES");
        des.init(1, new SecretKeySpec(secret, "DES"));
        byte[] ciphertext = des.doFinal(plaintext.getBytes());
        return Base64.encode((byte[])ciphertext);
    }

    String passwordDecrypt(String ciphertext) throws GeneralSecurityException {
        byte[] secret = (SECRET.hashCode() + "").substring(0, 8).getBytes();
        Cipher des = Cipher.getInstance("DES");
        des.init(2, new SecretKeySpec(secret, "DES"));
        byte[] plaintext = des.doFinal(Base64.decode((String)ciphertext));
        return new String(plaintext);
    }

    class InnerFilterChain
    implements FilterChain {
        FilterChain inner;

        InnerFilterChain(FilterChain inner) {
            this.inner = inner;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            LogStream cfr_ignored_0 = MyHttpSecurityFilter.this.log;
            if (LogStream.level >= 3) {
                MyHttpSecurityFilter.this.log.println("MyHttpSecurityFilter: The request has successfully passed through the HttpSecurityService");
            }
            if (request instanceof HttpSecurityServletRequest) {
                HttpSecurityServletRequest hssr;
                SecurityProvider sp;
                LogStream cfr_ignored_1 = MyHttpSecurityFilter.this.log;
                if (LogStream.level >= 3) {
                    MyHttpSecurityFilter.this.log.println("MyHttpSecurityFilter: The request has been authenticated (or the connection was previously authenticated) by the HttpSecurityService");
                }
                if ((sp = (hssr = (HttpSecurityServletRequest)request).getSecurityProvider()) instanceof NtlmSecurityProvider) {
                    LogStream cfr_ignored_2 = MyHttpSecurityFilter.this.log;
                    if (LogStream.level >= 3) {
                        MyHttpSecurityFilter.this.log.println("MyHttpSecurityFilter: The request has been authenticated (or the connection was previously authenticated) using the NtlmSecurityProvider");
                    }
                    NtlmSecurityProvider nsp = (NtlmSecurityProvider)sp;
                    try {
                        Account acct = nsp.getAccount(null, null);
                        LogStream cfr_ignored_3 = MyHttpSecurityFilter.this.log;
                        if (LogStream.level >= 3) {
                            MyHttpSecurityFilter.this.log.println("MyHttpSecurityFilter: getRemoteUser: " + hssr.getRemoteUser() + ", domain.dns.name=" + acct.getProperty("domain.dns.name") + ", sAMAccountName=" + acct.getProperty("sAMAccountName"));
                        }
                    }
                    catch (SecurityProviderException spe) {
                        throw new ServletException((Throwable)spe);
                    }
                }
            }
            this.inner.doFilter(request, response);
        }
    }
}

