/*
 * Decompiled with CFR 0.152.
 */
package jespa.examples;

import java.util.Map;
import jespa.ntlm.NtlmDomain;
import jespa.ntlm.NtlmResponse;
import jespa.ntlm.NtlmSecurityProvider;
import jespa.security.Account;
import jespa.security.Domain;
import jespa.security.PasswordCredential;
import jespa.security.Properties;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProviderException;

public class MyNtlmSecurityProvider
extends NtlmSecurityProvider {
    MyAccount account;

    public MyNtlmSecurityProvider(Map properties) {
        super(properties);
    }

    public Domain getDomain(String dname, String[] attrs) throws SecurityProviderException {
        if (attrs != null) {
            throw new SecurityProviderException(0, "Currently not supported, attrs must be null");
        }
        String nbtName = (String)this.get("domain.netbios.name");
        String dnsName = (String)this.get("domain.dns.name");
        if (nbtName == null && dnsName == null) {
            throw new SecurityProviderException(0, "domain.netbios.name and / or domain.dns.name properties are required");
        }
        if (dname == null || dname.equalsIgnoreCase(nbtName) || dname.equalsIgnoreCase(dnsName)) {
            NtlmDomain ret = new NtlmDomain();
            if (nbtName != null) {
                ret.put("domain.netbios.name", nbtName);
            }
            if (dnsName != null) {
                ret.put("domain.dns.name", dnsName);
            }
            return ret;
        }
        throw new SecurityProviderException(0, "Domain not found: " + dname);
    }

    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        if (acctname != null && (attrs != null || attrs.length != 0)) {
            throw new SecurityProviderException(0, "Currently not implemented, acctname and attrs must be null or empty");
        }
        return this.account;
    }

    public void authenticate(Object credential) throws SecurityProviderException {
        String nbtName = (String)this.getProperty("domain.netbios.name");
        String dnsName = (String)this.getProperty("domain.dns.name");
        String myusername = (String)this.getProperty("my.username");
        String mypassword = (String)this.getProperty("my.password");
        if (credential instanceof NtlmResponse) {
            NtlmResponse resp = (NtlmResponse)credential;
            String domain = resp.getDomain();
            String username = resp.getUsername();
            if (domain == null || domain.trim().length() == 0) {
                domain = nbtName;
            }
            if ((domain.equalsIgnoreCase(nbtName) || domain.equalsIgnoreCase(dnsName)) && username.equalsIgnoreCase(myusername)) {
                NtlmResponse local = new NtlmResponse(resp, domain, myusername, mypassword.toCharArray(), this.getTargetInformation());
                if (resp.equals(local)) {
                    this.account = new MyAccount(this);
                    this.account.put("domain.dns.name", this.getProperty("domain.dns.name"));
                    this.account.put("sAMAccountName", myusername);
                    return;
                }
                throw new SecurityProviderException(2, "Invalid credentials for " + domain + '\\' + username);
            }
            throw new SecurityProviderException(1, "Account not found for " + domain + '\\' + username);
        }
        if (credential instanceof PasswordCredential) {
            PasswordCredential cred = (PasswordCredential)credential;
            SecurityPrincipal princ = cred.getSecurityPrincipal();
            String domain = princ.getDomain();
            String username = princ.getUsername();
            if ((domain == null || domain.trim().length() == 0 || domain.equalsIgnoreCase(nbtName) || domain.equalsIgnoreCase(dnsName)) && username.equalsIgnoreCase(myusername)) {
                String password = new String(cred.getPassword());
                if (password.equals(mypassword)) {
                    this.identity = nbtName + "\\" + username;
                    this.account = new MyAccount(this);
                    this.account.put("sAMAccountName", username);
                    return;
                }
                throw new SecurityProviderException(2, "Invalid credentials for " + domain + '\\' + username);
            }
            throw new SecurityProviderException(1, "Account not found for " + domain + '\\' + username);
        }
        throw new SecurityProviderException(0, "Unsupported credential type");
    }

    public class MyAccount
    extends Properties
    implements Account {
        NtlmSecurityProvider provider;

        MyAccount(NtlmSecurityProvider provider) throws SecurityProviderException {
            this.provider = provider;
        }

        public boolean isMemberOf(String group) throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void create(String[] attrs) throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void create() throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void update(String[] attrs) throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void update() throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void delete() throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void setPassword(char[] password) throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }

        public void changePassword(char[] oldpassword, char[] newpassword) throws SecurityProviderException {
            throw new SecurityProviderException(0, "Not implemented");
        }
    }
}

