/*
 * Decompiled with CFR 0.152.
 */
package jespa.examples;

import java.io.IOException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jespa.examples.WordPressSecurityProvider;
import jespa.security.Account;
import jespa.security.PasswordCredential;
import jespa.security.Properties;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;
import jespa.util.Php;

public class WordPressAccount
extends Properties
implements Account {
    static final String[] USERS_FIELDS = new String[]{"ID", "user_login", "user_nicename", "user_email", "user_url", "user_registered", "user_activation_key", "display_name"};
    static final String DEFAULT_ACCOUNT_NAME_REGEX = "\\S+";
    WordPressSecurityProvider provider;
    Map original;
    LogStream log;

    static String esc(String str) {
        char[] sch = str.toCharArray();
        char[] rch = null;
        int ri = 0;
        for (int si = 0; si < sch.length; ++si) {
            char[] tmp;
            char ch = sch[si];
            switch (ch) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\"': 
                case '\'': 
                case '\\': {
                    if (rch == null) {
                        rch = new char[sch.length + 1];
                        System.arraycopy(sch, 0, rch, 0, si);
                        ri = si;
                    }
                    if (ri == rch.length) {
                        tmp = new char[rch.length * 2];
                        System.arraycopy(rch, 0, tmp, 0, rch.length);
                        rch = tmp;
                    }
                    rch[ri++] = 92;
                }
            }
            if (rch == null) continue;
            if (ri == rch.length) {
                tmp = new char[rch.length * 2];
                System.arraycopy(rch, 0, tmp, 0, rch.length);
                rch = tmp;
            }
            rch[ri++] = ch;
        }
        if (rch == null) {
            return str;
        }
        if (ri == rch.length) {
            return new String(rch);
        }
        return new String(rch, 0, ri);
    }

    public WordPressAccount(WordPressSecurityProvider provider, String acctname) throws SecurityProviderException {
        this.provider = provider;
        this.original = new HashMap();
        this.log = LogStream.getInstance();
        if (LogStream.level >= 4) {
            this.log.println("WordPressAccount: " + provider.get("bindstr"));
        }
        this.setProperty("user_login", acctname);
    }

    public void setProperty(String name, Object obj) throws SecurityProviderException {
        if (name.equals("user_login")) {
            String expr;
            Pattern p;
            Matcher m;
            String acctname = (String)obj;
            if (this.provider.containsKey("domain.dns.name") || this.provider.containsKey("domain.netbios.name")) {
                SecurityPrincipal principal = new SecurityPrincipal(acctname);
                if (!this.provider.isPossibleAuthority(principal.getDomain())) {
                    throw new SecurityProviderException(0, "SecurityProvider is not an authority for domain: " + principal.getDomain());
                }
                acctname = principal.getUsername();
            }
            if (!(m = (p = Pattern.compile(expr = (String)this.provider.getProperty("account.name.regex", DEFAULT_ACCOUNT_NAME_REGEX))).matcher(acctname)).matches()) {
                throw new SecurityProviderException(0, "Account name validation failed");
            }
            obj = acctname;
        }
        super.setProperty(name, obj);
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        Object ret = super.getProperty(name, NO_PROPERTY);
        if (ret == NO_PROPERTY && name.equals("capabilities")) {
            if (!this.containsKey("wp_capabilities")) {
                this.load(null, new String[]{"wp_capabilities"});
            }
            if (this.containsKey("wp_capabilities")) {
                try {
                    ret = Php.unserialize((String)this.get("wp_capabilities"));
                }
                catch (IOException ioe) {
                    if (LogStream.level >= 1) {
                        ioe.printStackTrace(this.log);
                    }
                    throw new SecurityProviderException(0, "Failed to retrieve capabilities Map", ioe);
                }
            }
        }
        if (ret == NO_PROPERTY) {
            return def;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(String acctname, String[] attrs) throws SecurityProviderException {
        block32: {
            if (acctname == null) {
                acctname = (String)this.getProperty("user_login");
            }
            ArrayList<String> user_attrs = new ArrayList<String>();
            ArrayList<String> meta_attrs = new ArrayList<String>();
            if (attrs == Account.ALL_ATTRS) {
                for (int ui = 0; ui < USERS_FIELDS.length; ++ui) {
                    user_attrs.add(USERS_FIELDS[ui]);
                }
            } else {
                if (attrs == null) {
                    attrs = USERS_FIELDS;
                }
                for (int ai = 0; ai < attrs.length; ++ai) {
                    String attr = attrs[ai];
                    if (attr.equalsIgnoreCase("user_pass")) {
                        user_attrs.add(attr);
                        continue;
                    }
                    for (int ui = 0; ui < USERS_FIELDS.length; ++ui) {
                        if (attr.equalsIgnoreCase(USERS_FIELDS[ui])) {
                            user_attrs.add(attr);
                            continue;
                        }
                        meta_attrs.add(attr);
                    }
                }
            }
            try {
                Connection connection = this.provider.getSqlConnection();
                Statement statement = connection.createStatement();
                try {
                    String tablePrefix = (String)this.provider.getProperty("table.prefix");
                    if (user_attrs.size() > 0) {
                        Iterator iter = user_attrs.iterator();
                        String fields = "";
                        while (iter.hasNext()) {
                            String attr = (String)iter.next();
                            fields = fields + ", " + WordPressAccount.esc(attr);
                        }
                        fields = fields.substring(2);
                        String sql = "SELECT " + fields + " FROM " + WordPressAccount.esc(tablePrefix) + "users WHERE user_login='" + WordPressAccount.esc(acctname) + "'";
                        if (LogStream.level >= 4) {
                            this.log.println("WordPressAccount: " + sql);
                        }
                        statement.executeQuery(sql);
                        ResultSet resultSet = statement.getResultSet();
                        try {
                            int count = 0;
                            while (resultSet.next()) {
                                if (count != 0) {
                                    throw new SecurityProviderException(0, "Too many results");
                                }
                                for (String attr : user_attrs) {
                                    this.setProperty(attr, resultSet.getString(attr));
                                }
                                ++count;
                            }
                            if (count == 0) {
                                throw new SecurityProviderException(1, "Account not found: " + acctname);
                            }
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    if (attrs != Account.ALL_ATTRS && meta_attrs.size() <= 0) break block32;
                    String sql = "SELECT m.meta_key, m.meta_value FROM " + WordPressAccount.esc(tablePrefix) + "users u, " + WordPressAccount.esc(tablePrefix) + "usermeta m WHERE m.user_id = u.ID and u.user_login = '" + WordPressAccount.esc(acctname) + "'";
                    if (LogStream.level >= 4) {
                        this.log.println("WordPressAccount: " + sql);
                    }
                    statement.executeQuery(sql);
                    ResultSet resultSet = statement.getResultSet();
                    try {
                        block17: while (resultSet.next()) {
                            String meta_key = resultSet.getString("meta_key");
                            if (attrs == Account.ALL_ATTRS) {
                                this.setProperty(meta_key, resultSet.getString("meta_value"));
                                continue;
                            }
                            for (String attr : meta_attrs) {
                                if (!attr.equalsIgnoreCase(meta_key)) continue;
                                this.setProperty(meta_key, resultSet.getString("meta_value"));
                                continue block17;
                            }
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException se) {
                throw new SecurityProviderException(0, "Failed to query database for account: " + acctname, se);
            }
        }
        this.original = new HashMap();
        this.original.putAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(String acctname, String[] attrs, boolean insert) throws SecurityProviderException {
        if (acctname == null) {
            acctname = (String)this.getProperty("user_login");
        }
        if (attrs == Account.ALL_ATTRS) {
            HashMap merge = new HashMap(this.original);
            merge.putAll(this);
            attrs = new String[merge.size()];
            merge.keySet().toArray(attrs);
        } else if (attrs == null) {
            attrs = USERS_FIELDS;
        }
        ArrayList<String> user_attrs = new ArrayList<String>();
        ArrayList<String> meta_attrs = new ArrayList<String>();
        for (int ai = 0; ai < attrs.length; ++ai) {
            int ui;
            String attr = attrs[ai];
            for (ui = 0; ui < USERS_FIELDS.length; ++ui) {
                if (!attr.equalsIgnoreCase(USERS_FIELDS[ui])) continue;
                if (attr.equalsIgnoreCase("ID")) break;
                user_attrs.add(attr);
                break;
            }
            if (ui != USERS_FIELDS.length) continue;
            meta_attrs.add(attr);
        }
        try {
            Connection connection = this.provider.getSqlConnection();
            Statement statement = connection.createStatement();
            try {
                String tablePrefix = (String)this.provider.getProperty("table.prefix");
                if (user_attrs.size() > 0) {
                    String fields = "";
                    String values = "";
                    for (String attr : user_attrs) {
                        String ovalu;
                        String value = (String)this.get(attr);
                        if (value == (ovalu = (String)this.original.get(attr))) continue;
                        if (attr.equalsIgnoreCase("user_status")) {
                            value = value == null ? "0" : WordPressAccount.esc(value);
                        } else {
                            String string = value = value == null ? "NULL" : "'" + WordPressAccount.esc(value) + "'";
                        }
                        if (insert) {
                            fields = fields + ", " + WordPressAccount.esc(attr);
                            values = values + ", " + value;
                            continue;
                        }
                        fields = fields + ", " + WordPressAccount.esc(attr) + "=" + value;
                    }
                    if (fields.length() > 0) {
                        String sql;
                        fields = fields.substring(2);
                        if (insert) {
                            values = values.substring(2);
                            if (!user_attrs.contains("user_registered")) {
                                fields = fields + ", user_registered";
                                values = values + ", NOW()";
                            }
                            String user_email = (String)this.getProperty("user_email");
                            sql = "INSERT INTO " + WordPressAccount.esc(tablePrefix) + "users (" + fields + ") SELECT " + values + " FROM dual WHERE NOT EXISTS (SELECT * FROM " + WordPressAccount.esc(tablePrefix) + "users WHERE user_login='" + WordPressAccount.esc(acctname) + "' OR user_email='" + WordPressAccount.esc(user_email) + "')";
                        } else {
                            sql = "UPDATE " + WordPressAccount.esc(tablePrefix) + "users SET " + fields + " WHERE user_login='" + WordPressAccount.esc(acctname) + "'";
                        }
                        if (LogStream.level >= 4) {
                            this.log.println("WordPressAccount: " + sql);
                        }
                        int n = statement.executeUpdate(sql);
                        if (LogStream.level >= 4) {
                            this.log.println("WordPressAccount: " + n + " rows affected");
                        }
                        if (n != 1) {
                            if (insert) {
                                throw new SecurityProviderException(6, "An account with the same name or email address already exists");
                            }
                            throw new SecurityProviderException(0, "Unexpected SQL update count: " + n);
                        }
                        for (String attr : user_attrs) {
                            String value = (String)this.get(attr);
                            if (value == null) {
                                this.original.remove(attr);
                            } else {
                                this.original.put(attr, value);
                            }
                            if (!attr.equalsIgnoreCase("user_login")) continue;
                            acctname = value;
                        }
                    }
                }
                if (meta_attrs.size() > 0) {
                    if (acctname == null || acctname.trim().length() == 0) {
                        throw new SecurityProviderException(0, "The user_login attribute is required");
                    }
                    Iterator iter = meta_attrs.iterator();
                    block13: while (iter.hasNext()) {
                        String sql = null;
                        String attr = (String)iter.next();
                        String value = (String)this.get(attr);
                        String ovalu = (String)this.original.get(attr);
                        if (value != null) {
                            if (ovalu != null) {
                                if (!value.equals(ovalu)) {
                                    sql = "UPDATE " + tablePrefix + "usermeta m, " + tablePrefix + "users u SET m.meta_value = '" + WordPressAccount.esc(value) + "' WHERE m.user_id = u.ID AND u.user_login = '" + WordPressAccount.esc(acctname) + "' AND m.meta_key = '" + WordPressAccount.esc(attr) + "'";
                                }
                            } else {
                                sql = "INSERT INTO " + tablePrefix + "usermeta (user_id, meta_key, meta_value) SELECT ID, '" + WordPressAccount.esc(attr) + "', '" + WordPressAccount.esc(value) + "' FROM " + tablePrefix + "users WHERE user_login = '" + WordPressAccount.esc(acctname) + "'";
                            }
                        } else if (ovalu != null) {
                            sql = "DELETE m FROM " + tablePrefix + "usermeta m, " + tablePrefix + "users u WHERE m.user_id = u.ID AND u.user_login = '" + WordPressAccount.esc(acctname) + "' AND m.meta_key = '" + WordPressAccount.esc(attr) + "' AND m.meta_value = '" + WordPressAccount.esc(ovalu) + "'";
                        }
                        if (sql == null) continue;
                        if (LogStream.level >= 4) {
                            this.log.println("WordPressAccount: " + sql);
                        }
                        int n = statement.executeUpdate(sql);
                        if (LogStream.level >= 4) {
                            this.log.println("WordPressAccount: " + n + " rows affected");
                        }
                        switch (sql.charAt(0)) {
                            case 'I': 
                            case 'U': {
                                this.original.put(attr, value);
                                continue block13;
                            }
                            case 'D': {
                                this.original.remove(attr);
                                continue block13;
                            }
                        }
                        throw new SecurityProviderException(0, "Unexpected SQL statement type");
                    }
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException se) {
            throw new SecurityProviderException(0, "Failed to query database for account: " + acctname, se);
        }
    }

    public void create(String[] attrs) throws SecurityProviderException {
        String user_login = (String)this.getProperty("user_login");
        String[] defaults = new String[]{"user_nicename", user_login, "display_name", user_login, "nickname", user_login, "rich_editing", "true", "comment_shortcuts", "false", "admin_color", "fresh", "wp_capabilities", "a:1:{s:10:\"subscriber\";b:1;}"};
        for (int di = 0; di < defaults.length; di += 2) {
            String key = defaults[di + 0];
            String val = defaults[di + 1];
            if (this.containsKey(key)) continue;
            this.setProperty(key, val);
        }
        this.store(null, attrs, true);
    }

    public void create() throws SecurityProviderException {
        this.create(Account.ALL_ATTRS);
    }

    public void update(String[] attrs) throws SecurityProviderException {
        this.store(null, attrs, false);
    }

    public void update() throws SecurityProviderException {
        this.update(Account.ALL_ATTRS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SecurityProviderException {
        String acctname = (String)this.getProperty("user_login");
        try {
            Connection connection = this.provider.getSqlConnection();
            Statement statement = connection.createStatement();
            try {
                String tablePrefix = (String)this.provider.getProperty("table.prefix");
                String sql = "DELETE m FROM " + tablePrefix + "usermeta m, " + tablePrefix + "users u WHERE m.user_id = u.ID and u.user_login ='" + WordPressAccount.esc(acctname) + "'";
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + sql);
                }
                int n = statement.executeUpdate(sql);
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + n + " rows affected");
                }
                sql = "DELETE FROM " + tablePrefix + "users u WHERE user_login ='" + WordPressAccount.esc(acctname) + "'";
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + sql);
                }
                n = statement.executeUpdate(sql);
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + n + " rows affected");
                }
                if (n != 1) {
                    throw new SecurityProviderException(0, "Failed to delete account: " + acctname);
                }
                if (LogStream.level >= 3) {
                    this.log.println("WordPressAccount: Successfully deleted account: " + acctname);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException se) {
            throw new SecurityProviderException(0, "Failed to delete account: " + acctname, se);
        }
    }

    public boolean isMemberOf(String role) throws SecurityProviderException {
        boolean result = false;
        SecurityPrincipal principal = new SecurityPrincipal(role.toLowerCase());
        if (this.provider.isPossibleAuthority(principal.getDomain())) {
            Map capabilities = (Map)this.getProperty("capabilities", NO_PROPERTY);
            if (LogStream.level >= 4) {
                this.log.println("WordPressAccount: isMemberOf: " + (capabilities != NO_PROPERTY ? capabilities.toString() : "capabilities not retrieved"));
            }
            result = capabilities != NO_PROPERTY && "1".equals(capabilities.get(principal.getUsername()));
        } else if (LogStream.level >= 4) {
            this.log.println("WordPressAccount: isMemberOf: Not authority for domain: " + principal.getDomain());
        }
        if (LogStream.level >= 3) {
            this.log.println("WordPressAccount: isMemberOf(" + role + ") is " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(char[] password) throws SecurityProviderException {
        String acctname = (String)this.getProperty("user_login");
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        String setting = "$P$B" + this.provider.phpass_encode64(salt, 8);
        String user_pass = this.provider.phpass_crypt_private(new String(password), setting);
        if (user_pass.length() != 34) {
            throw new SecurityProviderException(0, "Failed to construct valid password");
        }
        try {
            Connection connection = this.provider.getSqlConnection();
            Statement statement = connection.createStatement();
            try {
                String tablePrefix = (String)this.provider.getProperty("table.prefix");
                String sql = "UPDATE " + WordPressAccount.esc(tablePrefix) + "users SET user_pass='" + WordPressAccount.esc(user_pass) + "' WHERE user_login='" + WordPressAccount.esc(acctname) + "'";
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + sql);
                }
                int n = statement.executeUpdate(sql);
                if (LogStream.level >= 4) {
                    this.log.println("WordPressAccount: " + n + " rows affected");
                }
                if (n != 1) {
                    throw new SecurityProviderException(0, "Failed to update password for account: " + acctname);
                }
                if (LogStream.level >= 3) {
                    this.log.println("WordPressAccount: Successfully updated password for account: " + acctname);
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException se) {
            throw new SecurityProviderException(0, "Failed to update password for account: " + acctname, se);
        }
    }

    public void changePassword(char[] oldpassword, char[] newpassword) throws SecurityProviderException {
        String acctname = (String)this.getProperty("user_login");
        PasswordCredential cred = new PasswordCredential(acctname, oldpassword);
        this.provider.authenticate(cred);
        this.setPassword(newpassword);
    }
}

