/*
 * Decompiled with CFR 0.152.
 */
package jespa.examples;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import jespa.examples.WordPressAccount;
import jespa.io.ByteBuffer;
import jespa.io.EncodingException;
import jespa.security.Account;
import jespa.security.PasswordCredential;
import jespa.security.SecurityPrincipal;
import jespa.security.SecurityProvider;
import jespa.security.SecurityProviderException;
import jespa.util.LogStream;

public class WordPressSecurityProvider
extends SecurityProvider {
    static final String DEFAULT_TABLE_PREFIX = "wp_";
    Connection connection = null;
    WordPressAccount account = null;
    LogStream log = LogStream.getInstance();

    public WordPressSecurityProvider(Map properties) {
        super(properties);
        if (LogStream.level >= 4) {
            this.log.println("WordPressSecurityProvider: " + properties.get("bindstr"));
        }
    }

    protected void encodeObject(ByteBuffer bb, Object obj) throws EncodingException {
        if (obj instanceof WordPressAccount) {
            WordPressAccount acct = (WordPressAccount)obj;
            bb.encodeUint16le(30);
            try {
                this.encodeObject(bb, acct.getProperty("user_login"));
            }
            catch (SecurityProviderException se) {
                throw new EncodingException("Failed to encode user_login", se);
            }
            bb.encodeUint16le(acct.size());
            for (Object key : acct.keySet()) {
                Object val;
                if (key == (val = acct.get(key))) {
                    val = DUPLICATE_REFERENCE;
                }
                this.encodeObject(bb, key);
                this.encodeObject(bb, val);
            }
        } else if (obj instanceof WordPressSecurityProvider) {
            HashMap m = (HashMap)((HashMap)obj).clone();
            m.remove("service.password");
            bb.encodeUint16le(31);
            bb.encodeUint16le(m.size());
            for (Object key : m.keySet()) {
                Object val;
                if (key == (val = m.get(key))) {
                    val = DUPLICATE_REFERENCE;
                }
                this.encodeObject(bb, key);
                this.encodeObject(bb, val);
            }
        } else {
            super.encodeObject(bb, obj);
        }
    }

    protected Object decodeObject(ByteBuffer bb) throws EncodingException {
        int start = bb.getIndex();
        int type = bb.decodeUint16le();
        if (type == 30) {
            WordPressAccount acct;
            String user_login = (String)this.decodeObject(bb);
            try {
                acct = new WordPressAccount(this, user_login);
            }
            catch (SecurityProviderException se) {
                throw new EncodingException("Failed to decode WordPressAccount", se);
            }
            int len = bb.decodeUint16le();
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                acct.put(key, val);
            }
            return acct;
        }
        if (type == 31) {
            int len = bb.decodeUint16le();
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            for (int i = 0; i < len; ++i) {
                Object key = this.decodeObject(bb);
                Object val = this.decodeObject(bb);
                if (val == DUPLICATE_REFERENCE) {
                    val = key;
                }
                m.put(key, val);
            }
            return m;
        }
        bb.setIndex(start);
        return super.decodeObject(bb);
    }

    public Object exportState() throws SecurityProviderException {
        try {
            ByteBuffer bb = new ByteBuffer();
            this.encodeObject(bb, this.identity);
            this.encodeObject(bb, this.account);
            this.encodeObject(bb, this);
            return bb.getBuffer();
        }
        catch (EncodingException ee) {
            throw new SecurityProviderException(0, "Failed to export state", ee);
        }
    }

    public void importState(Object ostate) throws SecurityProviderException {
        byte[] bytes;
        if (ostate != null && (bytes = (byte[])ostate).length > 0) {
            try {
                ByteBuffer bb = new ByteBuffer(bytes, 0, bytes.length);
                this.identity = (String)this.decodeObject(bb);
                this.account = (WordPressAccount)this.decodeObject(bb);
                HashMap m = (HashMap)this.decodeObject(bb);
                this.putAll(m);
                return;
            }
            catch (EncodingException ee) {
                throw new SecurityProviderException(0, "Failed to import state", ee);
            }
        }
        throw new SecurityProviderException(0, "Failed to import state");
    }

    public Object getProperty(String name, Object def) throws SecurityProviderException {
        Object ret = super.getProperty(name, NO_PROPERTY);
        if (ret == NO_PROPERTY && name.equals("table.prefix")) {
            ret = DEFAULT_TABLE_PREFIX;
        }
        if (ret == NO_PROPERTY) {
            return def;
        }
        return ret;
    }

    Connection getSqlConnection() throws SecurityProviderException {
        if (this.connection == null) {
            if (LogStream.level >= 4) {
                this.log.println("WordPressSecurityProvider: getSqlConnection: " + this);
            }
            String bindstr = (String)this.getProperty("bindstr");
            String acctname = (String)this.getProperty("service.acctname");
            String password = (String)this.getProperty("service.password");
            String driver = (String)this.getProperty("jdbc.driver.classname", NO_PROPERTY);
            if (driver != NO_PROPERTY) {
                try {
                    Class.forName(driver);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SecurityProviderException(0, "Failed to load JDBC driver", cnfe);
                }
            }
            try {
                this.connection = DriverManager.getConnection(bindstr, acctname, password);
            }
            catch (SQLException se) {
                throw new SecurityProviderException(0, "Failed to create SQL connection", se);
            }
        }
        return this.connection;
    }

    boolean isPossibleAuthority(String name) throws SecurityProviderException {
        if (name == null) {
            return true;
        }
        String dname = (String)this.getProperty("domain.dns.name", null);
        String nname = (String)this.getProperty("domain.netbios.name", null);
        if (name.equalsIgnoreCase(dname)) {
            return true;
        }
        return name.equalsIgnoreCase(nname);
    }

    public Account getAccount(String acctname, String[] attrs) throws SecurityProviderException {
        if (acctname != null) {
            SecurityPrincipal p = new SecurityPrincipal(acctname);
            if (!this.isPossibleAuthority(p.getDomain())) {
                throw new SecurityProviderException(1, "SecurityProvider is not an authority for domain: " + p.getDomain());
            }
            acctname = p.getUsername();
        }
        if (this.account != null && acctname == null) {
            if (attrs == null) {
                return this.account;
            }
            acctname = (String)this.account.get("user_login");
        }
        if (acctname == null) {
            throw new SecurityProviderException(0, "The acctname parameter is required");
        }
        WordPressAccount acct = new WordPressAccount(this, acctname);
        acct.load(acctname, attrs);
        return acct;
    }

    String phpass_encode64(byte[] input, int count) {
        char[] itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        String output = "";
        int i = 0;
        do {
            int value = input[i++] & 0xFF;
            output = output + itoa64[value & 0x3F];
            if (i < count) {
                value |= (input[i] & 0xFF) << 8;
            }
            output = output + itoa64[value >> 6 & 0x3F];
            if (i++ >= count) break;
            if (i < count) {
                value |= (input[i] & 0xFF) << 16;
            }
            output = output + itoa64[value >> 12 & 0x3F];
            if (i++ >= count) break;
            output = output + itoa64[value >> 18 & 0x3F];
        } while (i < count);
        return output;
    }

    String phpass_crypt_private(String password, String setting) throws SecurityProviderException {
        if (!setting.startsWith("$P$")) {
            throw new SecurityProviderException(0, "Password hash type is not supported");
        }
        try {
            String salt = setting.substring(4, 12);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] hash = salt.getBytes();
            byte[] pass = password.getBytes("UTF-8");
            int count = 8193;
            while (count-- > 0) {
                md5.update(hash, 0, hash.length);
                md5.update(pass, 0, pass.length);
                hash = md5.digest();
                md5.reset();
            }
            return setting.substring(0, 12) + this.phpass_encode64(hash, 16);
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityProviderException(0, "Failed to compute password hash", gse);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SecurityProviderException(0, "Failed to compute password hash", uee);
        }
    }

    String canonicalizeAccountName(SecurityPrincipal securityPrincipal, int canonicalForm) throws SecurityProviderException {
        if (canonicalForm == 0) {
            return securityPrincipal.getName();
        }
        if (canonicalForm == 1) {
            throw new SecurityProviderException(0, "DN account name canonicalization not supported");
        }
        if (canonicalForm == 2) {
            return securityPrincipal.getUsername();
        }
        if (canonicalForm == 3) {
            String dname = (String)this.getProperty("domain.netbios.name");
            return dname + '\\' + securityPrincipal.getUsername();
        }
        if (canonicalForm == 4) {
            String dname = (String)this.getProperty("domain.dns.name");
            return securityPrincipal.getUsername() + '@' + dname;
        }
        throw new SecurityProviderException(0, "Unsupported account name canonical form: " + canonicalForm);
    }

    public void authenticate(Object credential) throws SecurityProviderException {
        if (credential instanceof PasswordCredential) {
            PasswordCredential cred = (PasswordCredential)credential;
            SecurityPrincipal p = cred.getSecurityPrincipal();
            String acctname = p.getName();
            String password = new String(cred.getPassword());
            String[] attrs = new String[]{"user_login", "user_pass", "user_email", "display_name", "wp_capabilities"};
            this.account = (WordPressAccount)this.getAccount(acctname, attrs);
            String setting = (String)this.account.remove("user_pass");
            if (!setting.equals(this.phpass_crypt_private(password, setting))) {
                throw new SecurityProviderException(2, "Invalid credentials: " + acctname);
            }
            int canonicalForm = (int)this.getPropertyAsLong("account.canonicalForm", 0L);
            this.identity = this.canonicalizeAccountName(p, canonicalForm);
            if (LogStream.level >= 4) {
                this.log.println("WordPressSecurityProvider: Authentication successful for " + this.identity);
            }
        } else {
            throw new SecurityProviderException(0, "Unsupported credential type");
        }
    }

    public void dispose() throws SecurityProviderException {
        this.account = null;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException se) {
                throw new SecurityProviderException(0, "Failed to close SQL connection", se);
            }
            finally {
                this.connection = null;
            }
        }
    }
}

