/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import jespa.http.CookieException;
import jespa.http.HeaderList;

class CookieList
extends ArrayList {
    static String[] EXCLUDES_REQUEST = new String[]{"Comment", "CommentURL", "Discard", "Domain", "Expires", "Max-Age", "Path", "Port", "Secure", "HttpOnly", "Version"};

    CookieList() {
    }

    static String pathcanon(String path) throws CookieException {
        int ci;
        if (path == null || path == "") {
            return "/";
        }
        if (path.charAt(0) != '/') {
            throw new CookieException("Path must start with /");
        }
        for (ci = path.length(); ci > 1 && path.charAt(ci - 1) == '/'; --ci) {
        }
        if (ci < path.length()) {
            path = path.substring(0, ci);
        }
        return path;
    }

    boolean addAll(String header) throws CookieException {
        byte[] ascii = HeaderList.toAsciiBytes(header);
        Cookie.Attrs attrs = new Cookie.Attrs();
        String val = null;
        String key = null;
        int ei = 0;
        int si = 0;
        int ai = 0;
        int state = 10;
        for (ai = 0; state > 0 && ai <= ascii.length; ++ai) {
            int ch = (char)(ai == ascii.length ? 0 : (char)ascii[ai]);
            switch (state) {
                case 10: {
                    if (ch == 59 || ch == 0) break;
                }
                case 20: {
                    if (ch == 32 || ch == 9) break;
                    if (ch < 32) {
                        throw new CookieException("Invalid cookie attribute value pair");
                    }
                    ++state;
                }
                case 11: 
                case 21: {
                    si = ai;
                    ei = ai + 1;
                    ++state;
                    break;
                }
                case 12: 
                case 22: {
                    if (state == 12) {
                        if (ch == 59 || ch == 0) {
                            key = HeaderList.toAsciiString(ascii, si, ei - si);
                            val = "true";
                            state = 30;
                            break;
                        }
                        if (ch == 61) {
                            key = HeaderList.toAsciiString(ascii, si, ei - si);
                            state = 20;
                            break;
                        }
                    } else if (ch == 59 || ch == 0) {
                        val = HeaderList.toAsciiString(ascii, si, ei - si);
                        state = 30;
                        break;
                    }
                    if (ch == 32 || ch == 9) break;
                    if (ch < 32) {
                        throw new CookieException("Invalid cookie attribute value pair");
                    }
                    ei = ai + 1;
                    break;
                }
                default: {
                    throw new CookieException("Invalid cookie parse state: " + state);
                }
            }
            if (state != 30) continue;
            if (!(key.equalsIgnoreCase("Comment") || key.equalsIgnoreCase("CommentURL") || key.equalsIgnoreCase("Discard"))) {
                if (key.equalsIgnoreCase("Domain")) {
                    int len = val.length();
                    if (len < 1 || len > 253) {
                        throw new CookieException("Unexpected Domain attribute: len=" + len);
                    }
                    attrs.domain = val;
                } else if (!key.equalsIgnoreCase("Expires") && !key.equalsIgnoreCase("Max-Age")) {
                    if (key.equalsIgnoreCase("Path")) {
                        attrs.path = CookieList.pathcanon(val);
                    } else if (key.equalsIgnoreCase("Port") || key.equalsIgnoreCase("Secure") || key.equalsIgnoreCase("Version")) {
                        // empty if block
                    }
                }
            }
            Cookie cookie = new Cookie(attrs, key, val);
            this.add(cookie);
            state = 10;
        }
        if (state != 10) {
            throw new CookieException("Invalid cookie attribute value pair");
        }
        return true;
    }

    boolean isStringInArray(String key, String[] arr) {
        for (int ai = 0; ai < arr.length; ++ai) {
            if (!key.equalsIgnoreCase(arr[ai])) continue;
            return true;
        }
        return false;
    }

    String getCookieHeader(String path, String[] excludes) throws CookieException {
        HashMap<String, Cookie> map = new HashMap<String, Cookie>();
        path = CookieList.pathcanon(path);
        char[] ppath = path.toCharArray();
        for (int pi = 0; pi <= ppath.length; ++pi) {
            if (pi != ppath.length && ppath[pi] != '/') continue;
            String subpath = pi == 0 ? "/" : path.substring(0, pi);
            for (Cookie cookie : this) {
                if (!subpath.equals(cookie.attrs.path) || this.isStringInArray(cookie.name, excludes)) continue;
                map.put(cookie.name.toLowerCase(), cookie);
            }
        }
        if (map.size() == 0) {
            return null;
        }
        String ret = "";
        for (Cookie cookie : map.values()) {
            if (ret != "") {
                ret = ret + "; ";
            }
            ret = ret + cookie.name + '=' + cookie.value;
        }
        return ret;
    }

    public String toString() {
        Iterator iter = this.iterator();
        String ret = "";
        while (iter.hasNext()) {
            Cookie cookie = (Cookie)iter.next();
            if (ret != "") {
                ret = ret + "; ";
            }
            ret = ret + cookie.attrs.path + ": " + cookie.name + '=' + cookie.value;
        }
        return ret;
    }

    static class Cookie {
        Attrs attrs;
        String name;
        String value;

        Cookie(Attrs attrs, String name, String value) {
            this.attrs = attrs;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.attrs.path + ": " + this.name + "=" + this.value;
        }

        static class Attrs {
            String domain;
            String path = "/";
            Date expires;
            boolean secure;
            boolean httpOnly;

            Attrs() {
            }

            public String toString() {
                return "domain=" + this.domain + ",path=" + this.path + ",expires=" + this.expires + ",secure=" + this.secure + ",httpOnly=" + this.httpOnly;
            }
        }
    }
}

