/*
 * Decompiled with CFR 0.152.
 */
package jespa.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jcifs.util.Base64;
import jespa.http.HttpInputStream;
import jespa.http.HttpOutputStream;
import jespa.util.RFC822;

class HeaderList
extends ArrayList {
    HeaderList() {
    }

    static byte[] toAsciiBytes(String str) {
        try {
            return str == null ? new byte[]{} : str.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static String toAsciiString(byte[] bytes, int off, int len) {
        try {
            return new String(bytes, off, len, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    static String toAsciiString(byte[] bytes) {
        return HeaderList.toAsciiString(bytes, 0, bytes.length);
    }

    void append(String key, String val) {
        this.add(new Header(key, val));
    }

    void append(String key, byte[] val) {
        this.add(new Header(key, val));
    }

    void set(String key, String val) {
        Header header = this.getHeader(key);
        if (header == null) {
            this.add(new Header(key, val));
        } else {
            header.val = HeaderList.toAsciiBytes(val);
        }
    }

    Header getHeader(String name) {
        for (Header header : this) {
            if (header.key == null || !header.key.equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    Header getHeader(String key, byte[] val, int len, boolean ignoreCase) {
        for (Header header : this) {
            String sval;
            String hval;
            if (header.key == null || !header.key.equalsIgnoreCase(key)) continue;
            if (len == -1 && header.val.length == val.length) {
                len = header.val.length;
            }
            if (len == -1 || len > header.val.length || !(hval = HeaderList.toAsciiString(header.val, 0, len)).regionMatches(ignoreCase, 0, sval = HeaderList.toAsciiString(val, 0, len), 0, len)) continue;
            return header;
        }
        return null;
    }

    Header getHeader(String key, String val, int vlen, boolean ignoreCase) {
        for (Header header : this) {
            String hval;
            if (header.key == null || !header.key.equalsIgnoreCase(key)) continue;
            if (vlen == -1 && header.val.length == val.length()) {
                vlen = header.val.length;
            }
            if (vlen == -1 || vlen > header.val.length || !(hval = HeaderList.toAsciiString(header.val, 0, vlen)).regionMatches(ignoreCase, 0, val, 0, vlen)) continue;
            return header;
        }
        return null;
    }

    byte[] getHeaderBytes(String name) {
        Header header = this.getHeader(name);
        if (header != null) {
            return header.val;
        }
        return null;
    }

    byte[] getHeaderBytesBase64(String name, String prefix, boolean ignoreCase) {
        int off;
        Header header = prefix == null ? this.getHeader(name) : this.getHeader(name, prefix, off, ignoreCase);
        if (header != null) {
            for (off = prefix.length(); header.val.length > off && header.val[off] == 32; ++off) {
            }
            if (header.val.length > off) {
                String val = HeaderList.toAsciiString(header.val, off, header.val.length - off);
                return Base64.decode((String)val);
            }
            return new byte[0];
        }
        return null;
    }

    String getHeaderString(String name) {
        Header header = this.getHeader(name);
        if (header != null) {
            return HeaderList.toAsciiString(header.val);
        }
        return null;
    }

    String getHeaderString(String key, String val, int len, boolean ignoreCase) {
        for (Header header : this) {
            if (header.key == null || !header.key.equalsIgnoreCase(key)) continue;
            String sval = HeaderList.toAsciiString(header.val);
            if (len == -1 && sval.length() == val.length()) {
                len = sval.length();
            }
            if (len == -1 || !sval.regionMatches(ignoreCase, 0, val, 0, len)) continue;
            return sval;
        }
        return null;
    }

    String getHeaderString(String key, String val, boolean ignoreCase) {
        return this.getHeaderString(key, val, -1, ignoreCase);
    }

    String getHeaderString(int n) {
        Header header = (Header)this.get(n);
        if (header != null) {
            return HeaderList.toAsciiString(header.val);
        }
        return null;
    }

    String getHeaderKeyString(int n) {
        Header header = (Header)this.get(n);
        if (header != null) {
            return header.key;
        }
        return null;
    }

    Map getHeaderMap() {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (Header header : this) {
            ArrayList<String> list = (ArrayList<String>)map.get(header.key);
            if (list == null) {
                list = new ArrayList<String>(1);
                map.put(header.key, list);
            }
            list.add(HeaderList.toAsciiString(header.val));
        }
        return Collections.unmodifiableMap(map);
    }

    void write(HttpOutputStream out) throws IOException {
        for (Header header : this) {
            if (header.key == null) continue;
            out.write(header.key.getBytes("US-ASCII"));
            out.write(58);
            out.write(32);
            out.write(header.val);
            out.write(13);
            out.write(10);
        }
    }

    void read(HttpInputStream in) throws IOException {
        String line;
        while ((line = in.readLine()) != null && !line.equals("")) {
            byte[][] header = RFC822.parseHeader(line);
            this.append(new String(header[0], "US-ASCII"), header[1]);
        }
    }

    public Object clone() {
        HeaderList copy = new HeaderList();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            copy.add(iter.next());
        }
        return copy;
    }

    public String toString() {
        String ret = null;
        for (Header header : this) {
            ret = ret == null ? "" : ret + ", ";
            ret = ret + header.toString();
        }
        return ret;
    }

    class Header {
        String key;
        byte[] val;

        Header(String key, byte[] val) {
            this.key = key;
            this.val = val;
        }

        Header(String key, String val) {
            this(key, HeaderList.toAsciiBytes(val));
        }

        public String toString() {
            return (this.key == null ? "" : this.key + ": ") + HeaderList.toAsciiString(this.val);
        }
    }
}

